/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.codenorm;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.saxon.om.FastStringBuffer;

class UnicodeDataGenerator {
    static final String copyright = "Copyright \u00a9 1998-1999 Unicode, Inc.";
    private static final boolean DEBUG = false;
    private static String dir;
    private static String UNICODE_DATA;
    private static String COMPOSITION_EXCLUSIONS;
    private static List canonicalClassKeys;
    private static List canonicalClassValues;
    private static List decompositionKeys;
    private static List decompositionValues;
    private static List exclusionList;
    private static List compatibilityList;

    private UnicodeDataGenerator() {
    }

    static void build() {
        try {
            UnicodeDataGenerator.readExclusionList();
            UnicodeDataGenerator.buildDecompositionTables();
        }
        catch (IOException iOException) {
            System.err.println("Can't load data file." + iOException + ", " + iOException.getMessage());
        }
    }

    private static void readExclusionList() throws IOException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(new FileReader(dir + '/' + COMPOSITION_EXCLUSIONS), 5120);
        while ((string = bufferedReader.readLine()) != null) {
            int n = string.indexOf(35);
            if (n != -1) {
                string = string.substring(0, n);
            }
            if (string.length() == 0) continue;
            int n2 = string.indexOf(32);
            if (n2 < 0) {
                n2 = string.length();
            }
            int n3 = Integer.parseInt(string.substring(0, n2), 16);
            exclusionList.add(new Integer(n3));
        }
        bufferedReader.close();
    }

    private static void buildDecompositionTables() throws IOException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(new FileReader(dir + '/' + UNICODE_DATA), 65536);
        boolean bl = false;
        while ((string = bufferedReader.readLine()) != null) {
            String string2;
            boolean bl2;
            int n;
            int n2 = string.indexOf(35);
            if (n2 != -1) {
                string = string.substring(0, n2);
            }
            if (string.length() == 0) continue;
            int n3 = 0;
            int n4 = string.indexOf(59);
            try {
                n = Integer.parseInt(string.substring(n3, n4), 16);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalStateException("Bad hex value in line:\n" + string);
            }
            if (n == 192) {
                System.out.println("debug: " + string);
            }
            n4 = string.indexOf(59, n4 + 1);
            n4 = string.indexOf(59, n4 + 1);
            n3 = n4 + 1;
            int n5 = Integer.parseInt(string.substring(n3, n4 = string.indexOf(59, n3)));
            if (n5 != (n5 & 0xFF)) {
                System.err.println("Bad canonical class at: " + string);
            }
            canonicalClassKeys.add(new Integer(n));
            canonicalClassValues.add(new Integer(n5));
            n4 = string.indexOf(59, n4 + 1);
            n3 = n4 + 1;
            if (n3 == (n4 = string.indexOf(59, n3))) continue;
            String string3 = string.substring(n3, n4);
            boolean bl3 = bl2 = string3.charAt(0) == '<';
            if (bl2) {
                compatibilityList.add(new Integer(n));
            }
            if ((string2 = UnicodeDataGenerator.fromHex(string3)).length() < 1 || string2.length() > 2 && !bl2) {
                System.err.println("Bad decomp at: " + string);
            }
            decompositionKeys.add(new Integer(n));
            decompositionValues.add(string2);
        }
        bufferedReader.close();
    }

    public static String fromHex(String string) {
        FastStringBuffer fastStringBuffer = new FastStringBuffer(5);
        block7: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case ' ': {
                    continue block7;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': 
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': {
                    int n = string.indexOf(32, i);
                    if (n < 0) {
                        n = string.length();
                    }
                    try {
                        fastStringBuffer.append((char)Integer.parseInt(string.substring(i, n), 16));
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new IllegalArgumentException("Bad hex value in " + string);
                    }
                    i = n;
                    continue block7;
                }
                case '<': {
                    int n = string.indexOf(62, i);
                    if (n > 0) {
                        i = n;
                        continue block7;
                    }
                }
                default: {
                    throw new IllegalArgumentException("Bad hex value in " + string);
                }
            }
        }
        return fastStringBuffer.toString();
    }

    public static String hex(char c) {
        String string = Integer.toString(c, 16).toUpperCase();
        return "0000".substring(string.length(), 4) + string;
    }

    public static String hex(String string, String string2) {
        FastStringBuffer fastStringBuffer = new FastStringBuffer(20);
        for (int i = 0; i < string.length(); ++i) {
            if (i != 0) {
                fastStringBuffer.append(string2);
            }
            fastStringBuffer.append(UnicodeDataGenerator.hex(string.charAt(i)));
        }
        return fastStringBuffer.toString();
    }

    private static void generateJava(PrintStream printStream) {
        printStream.println("package net.sf.saxon.codenorm;");
        printStream.println("");
        printStream.println("//This module was generated by running net.sf.saxon.codenorm.UnicodeDataGenerator");
        printStream.println("//*** DO NOT EDIT! ***");
        printStream.println("//The strange format of this file is carefully chosen to avoid breaking Java compiler limits");
        printStream.println("");
        printStream.println("public class UnicodeData {");
        printStream.println("public static final String[] canonicalClassKeys = {");
        UnicodeDataGenerator.printArray(printStream, canonicalClassKeys.iterator());
        printStream.println("};");
        printStream.println("public static final String[] canonicalClassValues = {");
        UnicodeDataGenerator.printArray(printStream, canonicalClassValues.iterator());
        printStream.println("};");
        printStream.println("public static final String[] decompositionKeys = {");
        UnicodeDataGenerator.printArray(printStream, decompositionKeys.iterator());
        printStream.println("};");
        printStream.println("public static final String[] decompositionValues = {");
        UnicodeDataGenerator.printStringArray(printStream, decompositionValues.iterator());
        printStream.println("};");
        printStream.println("public static final String[] exclusionList = {");
        UnicodeDataGenerator.printArray(printStream, exclusionList.iterator());
        printStream.println("};");
        printStream.println("public static final String[] compatibilityList = {");
        UnicodeDataGenerator.printArray(printStream, compatibilityList.iterator());
        printStream.println("};");
        printStream.println("}");
    }

    private static void printArray(PrintStream printStream, Iterator iterator) {
        int n = 0;
        FastStringBuffer fastStringBuffer = new FastStringBuffer(120);
        if (!iterator.hasNext()) {
            return;
        }
        fastStringBuffer.append('\"');
        while (true) {
            if (++n == 20) {
                n = 0;
                fastStringBuffer.append("\",");
                printStream.println(fastStringBuffer.toString());
                fastStringBuffer.setLength(0);
                fastStringBuffer.append('\"');
            }
            int n2 = (Integer)iterator.next();
            fastStringBuffer.append(Integer.toString(n2, 32));
            if (!iterator.hasNext()) break;
            fastStringBuffer.append(",");
        }
        fastStringBuffer.append("\"");
        printStream.println(fastStringBuffer.toString());
    }

    private static void printStringArray(PrintStream printStream, Iterator iterator) {
        int n = 0;
        FastStringBuffer fastStringBuffer = new FastStringBuffer(120);
        if (!iterator.hasNext()) {
            return;
        }
        while (true) {
            if (++n == 20) {
                n = 0;
                printStream.println(fastStringBuffer.toString());
                fastStringBuffer.setLength(0);
            }
            String string = (String)iterator.next();
            UnicodeDataGenerator.appendJavaString(string, fastStringBuffer);
            if (!iterator.hasNext()) break;
            fastStringBuffer.append(", ");
        }
        printStream.println(fastStringBuffer.toString());
    }

    private static void appendJavaString(String string, FastStringBuffer fastStringBuffer) {
        fastStringBuffer.append('\"');
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\\') {
                fastStringBuffer.append("\\\\");
                continue;
            }
            if (c == '\"') {
                fastStringBuffer.append("\\\"");
                continue;
            }
            if (c > ' ' && c < '\u007f') {
                fastStringBuffer.append(c);
                continue;
            }
            fastStringBuffer.append("\\u");
            char c2 = "0123456789abcdef".charAt(c & 0xF);
            char c3 = "0123456789abcdef".charAt(c >> 4 & 0xF);
            char c4 = "0123456789abcdef".charAt(c >> 8 & 0xF);
            char c5 = "0123456789abcdef".charAt(c >> 12 & 0xF);
            fastStringBuffer.append(c5);
            fastStringBuffer.append(c4);
            fastStringBuffer.append(c3);
            fastStringBuffer.append(c2);
        }
        fastStringBuffer.append('\"');
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length != 2) {
            System.err.println("Usage: java UnicodeDataGenerator dir UnicodeData.java");
            System.err.println("where dir is the directory containing the files UnicodeData.text and CompositionExclusions.txt from the Unicode character database");
        }
        dir = stringArray[0];
        UnicodeDataGenerator.build();
        PrintStream printStream = new PrintStream(new FileOutputStream(new File(stringArray[1])));
        UnicodeDataGenerator.generateJava(printStream);
    }

    static {
        UNICODE_DATA = "UnicodeData.txt";
        COMPOSITION_EXCLUSIONS = "CompositionExclusions.txt";
        canonicalClassKeys = new ArrayList(30000);
        canonicalClassValues = new ArrayList(30000);
        decompositionKeys = new ArrayList(6000);
        decompositionValues = new ArrayList(6000);
        exclusionList = new ArrayList(200);
        compatibilityList = new ArrayList(8000);
    }
}

