/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink;

import org.apache.beam.runners.core.construction.PTransformTranslation;
import org.apache.beam.runners.flink.FlinkBatchTransformTranslators;
import org.apache.beam.runners.flink.FlinkBatchTranslationContext;
import org.apache.beam.runners.flink.FlinkPipelineTranslator;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.io.DiscardingOutputFormat;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FlinkBatchPipelineTranslator
extends FlinkPipelineTranslator {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(FlinkBatchPipelineTranslator.class);
    private final @UnknownKeyFor @NonNull @Initialized FlinkBatchTranslationContext batchContext;
    private @UnknownKeyFor @NonNull @Initialized int depth = 0;

    public FlinkBatchPipelineTranslator(@UnknownKeyFor @NonNull @Initialized ExecutionEnvironment env, @UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
        this.batchContext = new FlinkBatchTranslationContext(env, options);
    }

    @Override
    public void translate(@UnknownKeyFor @NonNull @Initialized Pipeline pipeline) {
        this.batchContext.init(pipeline);
        super.translate(pipeline);
        for (DataSet<?> dataSet : this.batchContext.getDanglingDataSets().values()) {
            dataSet.output((OutputFormat)new DiscardingOutputFormat());
        }
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Pipeline.PipelineVisitor.CompositeBehavior enterCompositeTransform(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node node) {
        LOG.info("{} enterCompositeTransform- {}", (Object)FlinkBatchPipelineTranslator.genSpaces(this.depth), (Object)node.getFullName());
        ++this.depth;
        BatchTransformTranslator<?> translator = FlinkBatchPipelineTranslator.getTranslator(node, this.batchContext);
        if (translator != null) {
            this.applyBatchTransform(node.getTransform(), node, translator);
            LOG.info("{} translated- {}", (Object)FlinkBatchPipelineTranslator.genSpaces(this.depth), (Object)node.getFullName());
            return Pipeline.PipelineVisitor.CompositeBehavior.DO_NOT_ENTER_TRANSFORM;
        }
        return Pipeline.PipelineVisitor.CompositeBehavior.ENTER_TRANSFORM;
    }

    public void leaveCompositeTransform(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node node) {
        --this.depth;
        LOG.info("{} leaveCompositeTransform- {}", (Object)FlinkBatchPipelineTranslator.genSpaces(this.depth), (Object)node.getFullName());
    }

    public void visitPrimitiveTransform(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node node) {
        LOG.info("{} visitPrimitiveTransform- {}", (Object)FlinkBatchPipelineTranslator.genSpaces(this.depth), (Object)node.getFullName());
        PTransform transform = node.getTransform();
        BatchTransformTranslator<?> translator = FlinkBatchTransformTranslators.getTranslator(transform, this.batchContext);
        if (translator == null) {
            String transformUrn = PTransformTranslation.urnForTransform((PTransform)transform);
            throw new UnsupportedOperationException("The transform " + transformUrn + " is currently not supported.");
        }
        this.applyBatchTransform(transform, node, translator);
    }

    private <T extends PTransform<?, ?>> void applyBatchTransform(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> transform, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node node, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized BatchTransformTranslator<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> translator) {
        PTransform<?, ?> typedTransform = transform;
        BatchTransformTranslator<?> typedTranslator = translator;
        this.batchContext.setCurrentTransform(node.toAppliedPTransform(this.getPipeline()));
        typedTranslator.translateNode(typedTransform, this.batchContext);
    }

    private static /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized BatchTransformTranslator<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> getTranslator(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node node, @UnknownKeyFor @NonNull @Initialized FlinkBatchTranslationContext context) {
        @Nullable PTransform transform = node.getTransform();
        if (transform == null) {
            return null;
        }
        return FlinkBatchTransformTranslators.getTranslator(transform, context);
    }

    public static interface BatchTransformTranslator<@UnknownKeyFor TransformT extends @UnknownKeyFor @NonNull @Initialized PTransform> {
        default public @UnknownKeyFor @NonNull @Initialized boolean canTranslate(TransformT transform, @UnknownKeyFor @NonNull @Initialized FlinkBatchTranslationContext context) {
            return true;
        }

        public void translateNode(TransformT var1, @UnknownKeyFor @NonNull @Initialized FlinkBatchTranslationContext var2);
    }
}

