/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct;

import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.display.HasDisplayData;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

class DisplayDataValidator {
    private DisplayDataValidator() {
    }

    static void validatePipeline(@UnknownKeyFor @NonNull @Initialized Pipeline pipeline) {
        DisplayDataValidator.validateTransforms(pipeline);
    }

    static void validateOptions(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
        DisplayDataValidator.evaluateDisplayData((HasDisplayData)options);
    }

    private static void validateTransforms(@UnknownKeyFor @NonNull @Initialized Pipeline pipeline) {
        pipeline.traverseTopologically((Pipeline.PipelineVisitor)Visitor.INSTANCE);
    }

    private static void evaluateDisplayData(@UnknownKeyFor @NonNull @Initialized HasDisplayData component) {
        DisplayData.from((HasDisplayData)component);
    }

    private static class Visitor
    extends Pipeline.PipelineVisitor.Defaults {
        private static final @UnknownKeyFor @NonNull @Initialized Visitor INSTANCE = new Visitor();

        private Visitor() {
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Pipeline.PipelineVisitor.CompositeBehavior enterCompositeTransform(// Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node node) {
            if (!node.isRootNode()) {
                DisplayDataValidator.evaluateDisplayData((HasDisplayData)node.getTransform());
            }
            return Pipeline.PipelineVisitor.CompositeBehavior.ENTER_TRANSFORM;
        }

        public void visitPrimitiveTransform(// Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node node) {
            DisplayDataValidator.evaluateDisplayData((HasDisplayData)node.getTransform());
        }
    }
}

