/*
 * Decompiled with CFR 0.152.
 */
package org.kie.internal.runtime.error;

import java.util.stream.Stream;
import org.kie.internal.runtime.error.ExecutionError;
import org.kie.internal.runtime.error.ExecutionErrorContext;

public interface ExecutionErrorFilter {
    public boolean accept(ExecutionErrorContext var1);

    public ExecutionError filter(ExecutionErrorContext var1);

    public Integer getPriority();

    default public boolean isCausedBy(Throwable throwable, Class<?> ... types) {
        while (throwable != null) {
            Class<?> throwableClass = throwable.getClass();
            boolean matched = Stream.of(types).filter((? super T clazz) -> clazz != null).anyMatch(clazz -> clazz.isAssignableFrom(throwableClass));
            if (matched) {
                return true;
            }
            throwable = throwable.getCause();
        }
        return false;
    }

    default public <T> T extract(Throwable throwable, Class<T> type) {
        while (throwable != null) {
            if (type.isAssignableFrom(throwable.getClass())) {
                return (T)throwable;
            }
            throwable = throwable.getCause();
        }
        return null;
    }
}

