/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.databaselookup.readallcache;

import java.util.BitSet;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.pipeline.transforms.databaselookup.readallcache.Index;
import org.apache.hop.pipeline.transforms.databaselookup.readallcache.SearchingContext;

class EqIndex
extends Index {
    private final boolean isMatchingNonEquality;

    static Index nonEqualityIndex(int column, IValueMeta valueMeta, int rowsAmount) {
        return new EqIndex(column, valueMeta, rowsAmount, true);
    }

    EqIndex(int column, IValueMeta valueMeta, int rowsAmount) {
        this(column, valueMeta, rowsAmount, false);
    }

    private EqIndex(int column, IValueMeta valueMeta, int rowsAmount, boolean isMatchingNonEquality) {
        super(column, valueMeta, rowsAmount);
        this.isMatchingNonEquality = isMatchingNonEquality;
    }

    @Override
    void doApply(SearchingContext context, IValueMeta lookupMeta, Object lookupValue) throws HopException {
        int length;
        int firstValue = this.findInsertionPointOf(new Index.IndexedValue(lookupValue, -1));
        if (firstValue == (length = this.values.length) || this.valueMeta.compare(this.values[firstValue].key, lookupValue) != 0) {
            if (this.isMatchingNonEquality) {
                return;
            }
            context.setEmpty();
        } else {
            BitSet bitSet = context.getWorkingSet();
            bitSet.set(this.values[firstValue].row, true);
            for (int lastValue = firstValue + 1; lastValue != length && this.valueMeta.compare(this.values[lastValue].key, lookupValue) == 0; ++lastValue) {
                bitSet.set(this.values[lastValue].row, true);
            }
            context.intersect(bitSet, this.isMatchingNonEquality);
        }
    }

    @Override
    int getRestrictionPower() {
        return this.isMatchingNonEquality ? Short.MAX_VALUE : Short.MIN_VALUE;
    }
}

