/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.testing.xp;

import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.extension.ExtensionPoint;
import org.apache.hop.core.extension.IExtensionPoint;
import org.apache.hop.core.gui.IGc;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.pipeline.PipelinePainterExtension;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.testing.PipelineUnitTest;
import org.apache.hop.testing.PipelineUnitTestTweak;
import org.apache.hop.testing.gui.TestingGuiPlugin;

@ExtensionPoint(id="DrawTweakOnTransformExtensionPoint", description="Draws a marker on top of a transform if is tweaked", extensionPointId="PipelinePainterTransform")
public class DrawTweakOnTransformExtensionPoint
implements IExtensionPoint<PipelinePainterExtension> {
    public void callExtensionPoint(ILogChannel log, IVariables variables, PipelinePainterExtension ext) throws HopException {
        TransformMeta transformMeta = ext.transformMeta;
        PipelineUnitTest unitTest = TestingGuiPlugin.getCurrentUnitTest(ext.pipelineMeta);
        if (unitTest == null) {
            return;
        }
        PipelineUnitTestTweak tweak = unitTest.findTweak(transformMeta.getName());
        if (tweak == null || tweak.getTweak() == null) {
            return;
        }
        try {
            switch (tweak.getTweak()) {
                case NONE: {
                    break;
                }
                case REMOVE_TRANSFORM: {
                    this.drawRemovedTweak(ext, transformMeta);
                    break;
                }
                case BYPASS_TRANSFORM: {
                    this.drawBypassedTweak(ext, transformMeta);
                    break;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void drawRemovedTweak(PipelinePainterExtension ext, TransformMeta transformMeta) {
        IGc gc = ext.gc;
        int iconSize = ext.iconSize;
        int x = ext.x1 - 5;
        int y = ext.y1 - 5;
        gc.setLineWidth(transformMeta.isSelected() ? 4 : 3);
        gc.setForeground(IGc.EColor.CRYSTAL);
        gc.setBackground(IGc.EColor.LIGHTGRAY);
        gc.setFont(IGc.EFont.GRAPH);
        gc.drawLine(x, y, x + iconSize / 2, y + iconSize / 2);
        gc.drawLine(x + iconSize / 2, y, x, y + iconSize / 2);
    }

    protected void drawBypassedTweak(PipelinePainterExtension ext, TransformMeta transformMeta) {
        IGc gc = ext.gc;
        int iconSize = ext.iconSize;
        int x = ext.x1 - 5;
        int y = ext.y1 - 5;
        int aW = iconSize / 2;
        int aH = 3 * iconSize / 8;
        gc.setForeground(IGc.EColor.CRYSTAL);
        gc.setBackground(IGc.EColor.CRYSTAL);
        int[] arrow = new int[]{x, y + aH / 3, x + 5 * aW / 8, y + aH / 3, x + 5 * aW / 8, y, x + aW, y + aH / 2, x + 5 * aW / 8, y + aH, x + 5 * aW / 8, y + 2 * aH / 3, x, y + 2 * aH / 3};
        gc.fillPolygon(arrow);
    }
}

