/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.testing.xp;

import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.extension.ExtensionPoint;
import org.apache.hop.core.extension.IExtensionPoint;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.testing.UnitTestResult;
import org.apache.hop.ui.hopgui.file.pipeline.extension.HopGuiPipelineFinishedExtension;

@ExtensionPoint(id="HopGuiUpdateStateMapExtensionPoint", description="Update the state map with unit test results in the Hop GUI pipeline graph so that it can be rendered", extensionPointId="HopGuiPipelineFinished")
public class HopGuiUpdateStateMapExtensionPoint
implements IExtensionPoint<HopGuiPipelineFinishedExtension> {
    public void callExtensionPoint(ILogChannel log, IVariables variables, HopGuiPipelineFinishedExtension ext) throws HopException {
        List results = (List)ext.pipeline.getExtensionDataMap().get("UnitTestResults");
        if (results != null && !results.isEmpty()) {
            HashMap stateMap = ext.pipelineGraph.getStateMap();
            if (stateMap == null) {
                stateMap = new HashMap();
                ext.pipelineGraph.setStateMap(stateMap);
            }
            HashMap<String, Boolean> resultsMap = new HashMap<String, Boolean>();
            stateMap.put("GoldenDataSetResults", resultsMap);
            for (UnitTestResult result : results) {
                if (!StringUtils.isNotEmpty((String)result.getDataSetName())) continue;
                resultsMap.put(result.getDataSetName(), !result.isError());
            }
        }
    }
}

