/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.coders;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import org.apache.beam.sdk.coders.AtomicCoder;
import org.apache.beam.sdk.coders.ByteArrayCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class BigIntegerCoder
extends AtomicCoder<BigInteger> {
    private static final @UnknownKeyFor @NonNull @Initialized BigIntegerCoder INSTANCE = new BigIntegerCoder();
    private static final @UnknownKeyFor @NonNull @Initialized ByteArrayCoder BYTE_ARRAY_CODER = ByteArrayCoder.of();

    public static @UnknownKeyFor @NonNull @Initialized BigIntegerCoder of() {
        return INSTANCE;
    }

    private BigIntegerCoder() {
    }

    @Override
    public void encode(@UnknownKeyFor @NonNull @Initialized BigInteger value, @UnknownKeyFor @NonNull @Initialized OutputStream outStream) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized CoderException {
        this.encode(value, outStream, Coder.Context.NESTED);
    }

    @Override
    public void encode(@UnknownKeyFor @NonNull @Initialized BigInteger value, @UnknownKeyFor @NonNull @Initialized OutputStream outStream, @UnknownKeyFor @NonNull @Initialized Coder.Context context) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized CoderException {
        Preconditions.checkNotNull((Object)value, (Object)String.format("cannot encode a null %s", BigInteger.class.getSimpleName()));
        BYTE_ARRAY_CODER.encode(value.toByteArray(), outStream, context);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized BigInteger decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized CoderException {
        return this.decode(inStream, Coder.Context.NESTED);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized BigInteger decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream, @UnknownKeyFor @NonNull @Initialized Coder.Context context) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized CoderException {
        return new BigInteger(BYTE_ARRAY_CODER.decode(inStream, context));
    }

    @Override
    public void verifyDeterministic() {
        BYTE_ARRAY_CODER.verifyDeterministic();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean consistentWithEquals() {
        return true;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean isRegisterByteSizeObserverCheap(@UnknownKeyFor @NonNull @Initialized BigInteger value) {
        return true;
    }

    @Override
    protected @UnknownKeyFor @NonNull @Initialized long getEncodedElementByteSize(@UnknownKeyFor @NonNull @Initialized BigInteger value) throws @UnknownKeyFor @NonNull @Initialized Exception {
        Preconditions.checkNotNull((Object)value, (Object)String.format("cannot encode a null %s", BigInteger.class.getSimpleName()));
        return BYTE_ARRAY_CODER.getEncodedElementByteSize(value.toByteArray());
    }
}

