/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.fs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.beam.sdk.io.FileSystems;
import org.apache.beam.sdk.io.fs.ResolveOptions;
import org.apache.beam.sdk.io.fs.ResourceId;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;

public final class ResourceIdTester {
    public static void runResourceIdBattery(@UnknownKeyFor @NonNull @Initialized ResourceId baseDirectory) {
        Preconditions.checkArgument((boolean)baseDirectory.isDirectory(), (String)"baseDirectory %s is not a directory", (Object)baseDirectory);
        ArrayList<ResourceId> allResourceIds = new ArrayList<ResourceId>();
        allResourceIds.add(baseDirectory);
        ResourceIdTester.validateResourceIds(allResourceIds);
        ResourceIdTester.validateResolvingIds(baseDirectory, allResourceIds);
        ResourceIdTester.validateFailureResolvingIds(baseDirectory);
    }

    private static void validateResolvingIds(@UnknownKeyFor @NonNull @Initialized ResourceId baseDirectory, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized ResourceId> allResourceIds) {
        ResourceId file1 = baseDirectory.resolve("child1", ResolveOptions.StandardResolveOptions.RESOLVE_FILE);
        ResourceId file2 = baseDirectory.resolve("child2", ResolveOptions.StandardResolveOptions.RESOLVE_FILE);
        ResourceId file2a = baseDirectory.resolve("child2", ResolveOptions.StandardResolveOptions.RESOLVE_FILE);
        allResourceIds.add(file1);
        allResourceIds.add(file2);
        MatcherAssert.assertThat((String)"Resolved file isDirectory()", (Object)file1.isDirectory(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((String)"Resolved file isDirectory()", (Object)file2.isDirectory(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((String)"Resolved file isDirectory()", (Object)file2a.isDirectory(), (Matcher)Matchers.is((Object)false));
        ResourceId dir1 = baseDirectory.resolve("child1", ResolveOptions.StandardResolveOptions.RESOLVE_DIRECTORY);
        ResourceId dir2 = baseDirectory.resolve("child2", ResolveOptions.StandardResolveOptions.RESOLVE_DIRECTORY);
        ResourceId dir2a = baseDirectory.resolve("child2", ResolveOptions.StandardResolveOptions.RESOLVE_DIRECTORY);
        MatcherAssert.assertThat((String)"Resolved directory isDirectory()", (Object)dir1.isDirectory(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((String)"Resolved directory isDirectory()", (Object)dir2.isDirectory(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((String)"Resolved directory isDirectory()", (Object)dir2a.isDirectory(), (Matcher)Matchers.is((Object)true));
        allResourceIds.add(dir1);
        allResourceIds.add(dir2);
        ResourceIdTester.assertEqualityGroups(Arrays.asList(Arrays.asList(file1), Arrays.asList(file2, file2a), Arrays.asList(dir1, dir1.getCurrentDirectory()), Arrays.asList(dir2, dir2a, dir2.getCurrentDirectory()), Arrays.asList(baseDirectory, file1.getCurrentDirectory(), file2.getCurrentDirectory())));
        ResourceIdTester.assertEqualityGroups(Arrays.asList(Arrays.asList(file1.toString()), Arrays.asList(file2.toString(), file2a.toString()), Arrays.asList(dir1.toString(), dir1.getCurrentDirectory().toString()), Arrays.asList(dir2.toString(), dir2a.toString(), dir2.getCurrentDirectory().toString()), Arrays.asList(baseDirectory.toString(), file1.getCurrentDirectory().toString(), file2.getCurrentDirectory().toString())));
    }

    private static <T> void assertEqualityGroups(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized List<T>> equalityGroups) {
        for (int i = 0; i < equalityGroups.size(); ++i) {
            int j;
            List<T> current = equalityGroups.get(i);
            for (j = 0; j < current.size(); ++j) {
                for (int k = 0; k < current.size(); ++k) {
                    Assert.assertEquals((String)("Value at " + j + " should equal value at " + k + " in equality group " + i), current.get(j), current.get(k));
                }
            }
            for (j = 0; j < equalityGroups.size(); ++j) {
                if (i == j) continue;
                Assert.assertTrue((String)(current + " should not match any in " + equalityGroups.get(j)), (boolean)Collections.disjoint(current, (Collection)equalityGroups.get(j)));
            }
        }
    }

    private static void validateFailureResolvingIds(@UnknownKeyFor @NonNull @Initialized ResourceId baseDirectory) {
        try {
            ResourceId badFile = baseDirectory.resolve("file/", ResolveOptions.StandardResolveOptions.RESOLVE_FILE);
            Assert.fail((String)String.format("Resolving badFile %s should have failed", badFile));
        }
        catch (IllegalArgumentException badFile) {
            // empty catch block
        }
        ResourceId file = baseDirectory.resolve("file", ResolveOptions.StandardResolveOptions.RESOLVE_FILE);
        try {
            file.resolve("file2", ResolveOptions.StandardResolveOptions.RESOLVE_FILE);
            Assert.fail((String)String.format("Should not be able to resolve against file resource %s", file));
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private static void validateResourceIds(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized ResourceId> resourceIds) {
        for (ResourceId resourceId : resourceIds) {
            MatcherAssert.assertThat((String)"ResourceId equal to itself", (Object)resourceId, (Matcher)Matchers.equalTo((Object)resourceId));
            ResourceId cloned = resourceId.isDirectory() ? FileSystems.matchNewResource(resourceId.toString(), true) : FileSystems.matchNewResource(resourceId.toString(), false);
            MatcherAssert.assertThat((String)"ResourceId equals clone of itself", (Object)cloned, (Matcher)Matchers.equalTo((Object)resourceId));
            MatcherAssert.assertThat((String)"ResourceId toString consistency", (Object)cloned.toString(), (Matcher)Matchers.equalTo((Object)resourceId.toString()));
            MatcherAssert.assertThat((String)"ResourceId isDirectory consistency", (Object)cloned.isDirectory(), (Matcher)Matchers.equalTo((Object)resourceId.isDirectory()));
        }
    }

    private ResourceIdTester() {
    }
}

