/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.range;

import org.apache.beam.sdk.io.range.RangeTracker;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OffsetRangeTracker
implements RangeTracker<Long> {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(OffsetRangeTracker.class);
    private @UnknownKeyFor @NonNull @Initialized long startOffset;
    private @UnknownKeyFor @NonNull @Initialized long stopOffset;
    private @UnknownKeyFor @NonNull @Initialized long lastRecordStart = -1L;
    private @UnknownKeyFor @NonNull @Initialized long offsetOfLastSplitPoint = -1L;
    private @UnknownKeyFor @NonNull @Initialized long splitPointsSeen = 0L;
    private @UnknownKeyFor @NonNull @Initialized boolean done = false;
    public static final @UnknownKeyFor @NonNull @Initialized long OFFSET_INFINITY = Long.MAX_VALUE;

    public OffsetRangeTracker(@UnknownKeyFor @NonNull @Initialized long startOffset, @UnknownKeyFor @NonNull @Initialized long stopOffset) {
        this.startOffset = startOffset;
        this.stopOffset = stopOffset;
    }

    private OffsetRangeTracker() {
    }

    public synchronized @UnknownKeyFor @NonNull @Initialized boolean isStarted() {
        return this.offsetOfLastSplitPoint != -1L || this.done;
    }

    public synchronized @UnknownKeyFor @NonNull @Initialized boolean isDone() {
        return this.done;
    }

    @Override
    public synchronized @UnknownKeyFor @NonNull @Initialized Long getStartPosition() {
        return this.startOffset;
    }

    @Override
    public synchronized @UnknownKeyFor @NonNull @Initialized Long getStopPosition() {
        return this.stopOffset;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean tryReturnRecordAt(@UnknownKeyFor @NonNull @Initialized boolean isAtSplitPoint, @UnknownKeyFor @NonNull @Initialized Long recordStart) {
        return this.tryReturnRecordAt(isAtSplitPoint, (long)recordStart);
    }

    @Override
    public synchronized @UnknownKeyFor @NonNull @Initialized boolean tryReturnRecordAt(@UnknownKeyFor @NonNull @Initialized boolean isAtSplitPoint, @UnknownKeyFor @NonNull @Initialized long recordStart) {
        if (!this.isStarted() && !isAtSplitPoint) {
            throw new IllegalStateException(String.format("The first record [starting at %d] must be at a split point", recordStart));
        }
        if (recordStart < this.startOffset) {
            throw new IllegalStateException(String.format("Trying to return record [starting at %d] which is before the start offset [%d]", recordStart, this.startOffset));
        }
        if (recordStart < this.lastRecordStart) {
            throw new IllegalStateException(String.format("Trying to return record [starting at %d] which is before the last-returned record [starting at %d]", recordStart, this.lastRecordStart));
        }
        if (this.lastRecordStart == -1L) {
            this.startOffset = recordStart;
        }
        this.lastRecordStart = recordStart;
        if (isAtSplitPoint) {
            if (recordStart == this.offsetOfLastSplitPoint) {
                throw new IllegalStateException(String.format("Record at a split point has same offset as the previous split point: previous split point at %d, current record starts at %d", this.offsetOfLastSplitPoint, recordStart));
            }
            if (recordStart >= this.stopOffset) {
                this.done = true;
                return false;
            }
            this.offsetOfLastSplitPoint = recordStart;
            ++this.splitPointsSeen;
        }
        return true;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean trySplitAtPosition(@UnknownKeyFor @NonNull @Initialized Long splitOffset) {
        return this.trySplitAtPosition((long)splitOffset);
    }

    @Override
    public synchronized @UnknownKeyFor @NonNull @Initialized boolean trySplitAtPosition(@UnknownKeyFor @NonNull @Initialized long splitOffset) {
        if (this.stopOffset == Long.MAX_VALUE) {
            LOG.debug("Refusing to split {} at {}: stop position unspecified", (Object)this, (Object)splitOffset);
            return false;
        }
        if (!this.isStarted()) {
            LOG.debug("Refusing to split {} at {}: unstarted", (Object)this, (Object)splitOffset);
            return false;
        }
        if (splitOffset <= this.lastRecordStart) {
            LOG.debug("Refusing to split {} at {}: already past proposed split position", (Object)this, (Object)splitOffset);
            return false;
        }
        if (splitOffset < this.startOffset || splitOffset >= this.stopOffset) {
            LOG.debug("Refusing to split {} at {}: proposed split position out of range", (Object)this, (Object)splitOffset);
            return false;
        }
        LOG.debug("Agreeing to split {} at {}", (Object)this, (Object)splitOffset);
        this.stopOffset = splitOffset;
        return true;
    }

    public synchronized @UnknownKeyFor @NonNull @Initialized long getPositionForFractionConsumed(@UnknownKeyFor @NonNull @Initialized double fraction) {
        if (this.stopOffset == Long.MAX_VALUE) {
            throw new IllegalArgumentException("getPositionForFractionConsumed is not applicable to an unbounded range: " + this);
        }
        return (long)Math.floor((double)this.startOffset + fraction * (double)(this.stopOffset - this.startOffset));
    }

    @Override
    public synchronized @UnknownKeyFor @NonNull @Initialized double getFractionConsumed() {
        if (!this.isStarted()) {
            return 0.0;
        }
        if (this.isDone()) {
            return 1.0;
        }
        if (this.stopOffset == Long.MAX_VALUE) {
            return 0.0;
        }
        if (this.lastRecordStart >= this.stopOffset) {
            return 1.0;
        }
        return Math.min(1.0, 1.0 * (double)(this.lastRecordStart - this.startOffset) / (double)(this.stopOffset - this.startOffset));
    }

    public synchronized @UnknownKeyFor @NonNull @Initialized long getSplitPointsProcessed() {
        if (!this.isStarted()) {
            return 0L;
        }
        if (this.isDone()) {
            return this.splitPointsSeen;
        }
        Preconditions.checkState((this.splitPointsSeen > 0L ? 1 : 0) != 0, (String)"A started rangeTracker should have seen > 0 split points (is %s)", (long)this.splitPointsSeen);
        return this.splitPointsSeen - 1L;
    }

    public synchronized @UnknownKeyFor @NonNull @Initialized boolean markDone() {
        this.done = true;
        return false;
    }

    @SideEffectFree
    public synchronized @UnknownKeyFor @NonNull @Initialized String toString() {
        String stopString;
        String string = stopString = this.stopOffset == Long.MAX_VALUE ? "infinity" : String.valueOf(this.stopOffset);
        if (this.lastRecordStart >= 0L) {
            return String.format("<at [starting at %d] of offset range [%d, %s)>", this.lastRecordStart, this.startOffset, stopString);
        }
        return String.format("<unstarted in offset range [%d, %s)>", this.startOffset, stopString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    @UnknownKeyFor @NonNull @Initialized OffsetRangeTracker copy() {
        OffsetRangeTracker offsetRangeTracker = this;
        synchronized (offsetRangeTracker) {
            OffsetRangeTracker res;
            OffsetRangeTracker offsetRangeTracker2 = res = new OffsetRangeTracker();
            synchronized (offsetRangeTracker2) {
                res.startOffset = this.startOffset;
                res.stopOffset = this.stopOffset;
                res.offsetOfLastSplitPoint = this.offsetOfLastSplitPoint;
                res.lastRecordStart = this.lastRecordStart;
                res.done = this.done;
                res.splitPointsSeen = this.splitPointsSeen;
            }
            return res;
        }
    }
}

