/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas;

import com.google.auto.value.AutoOneOf;
import com.google.auto.value.AutoValue;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.beam.sdk.schemas.AutoOneOf_FieldAccessDescriptor_FieldDescriptor_Qualifier;
import org.apache.beam.sdk.schemas.AutoValue_FieldAccessDescriptor;
import org.apache.beam.sdk.schemas.AutoValue_FieldAccessDescriptor_FieldDescriptor;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.parser.FieldAccessDescriptorParser;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.LinkedListMultimap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Maps;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Sets;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;

@AutoValue
public abstract class FieldAccessDescriptor
implements Serializable {
    public abstract @UnknownKeyFor @NonNull @Initialized boolean getAllFields();

    public abstract @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized FieldDescriptor> getFieldsAccessed();

    public abstract @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized FieldDescriptor, @UnknownKeyFor @NonNull @Initialized FieldAccessDescriptor> getNestedFieldsAccessed();

    abstract @UnknownKeyFor @NonNull @Initialized Builder toBuilder();

    static @UnknownKeyFor @NonNull @Initialized Builder builder() {
        return new AutoValue_FieldAccessDescriptor.Builder().setAllFields(false).setFieldsAccessed(Collections.emptyList()).setNestedFieldsAccessed(Collections.emptyMap());
    }

    public static @UnknownKeyFor @NonNull @Initialized FieldAccessDescriptor withAllFields() {
        return FieldAccessDescriptor.builder().setAllFields(true).build();
    }

    public static @UnknownKeyFor @NonNull @Initialized FieldAccessDescriptor withFieldNames(String ... names) {
        return FieldAccessDescriptor.withFieldNames(Arrays.asList(names));
    }

    public static @UnknownKeyFor @NonNull @Initialized FieldAccessDescriptor withFieldNames(@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized String> fieldNames) {
        List<FieldAccessDescriptor> fields = StreamSupport.stream(fieldNames.spliterator(), false).map(FieldAccessDescriptorParser::parse).collect(Collectors.toList());
        return FieldAccessDescriptor.union(fields);
    }

    public static @UnknownKeyFor @NonNull @Initialized FieldAccessDescriptor withFieldNamesAs(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> fieldNamesAs) {
        ArrayList fields = Lists.newArrayListWithCapacity((int)fieldNamesAs.size());
        for (Map.Entry<String, String> entry : fieldNamesAs.entrySet()) {
            fields.add(FieldAccessDescriptor.create().withFieldNameAs(entry.getKey(), entry.getValue()));
        }
        return FieldAccessDescriptor.union(fields);
    }

    public static @UnknownKeyFor @NonNull @Initialized FieldAccessDescriptor withFieldNames(@UnknownKeyFor @NonNull @Initialized FieldAccessDescriptor baseDescriptor, String ... fieldNames) {
        return FieldAccessDescriptor.withFieldNames(baseDescriptor, Arrays.asList(fieldNames));
    }

    public static @UnknownKeyFor @NonNull @Initialized FieldAccessDescriptor withFieldNames(@UnknownKeyFor @NonNull @Initialized FieldAccessDescriptor baseDescriptor, @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized String> fieldNames) {
        if (baseDescriptor.getFieldsAccessed().isEmpty() && baseDescriptor.getNestedFieldsAccessed().isEmpty()) {
            return FieldAccessDescriptor.withFieldNames(fieldNames);
        }
        if (!baseDescriptor.getFieldsAccessed().isEmpty()) {
            Preconditions.checkArgument((boolean)baseDescriptor.getNestedFieldsAccessed().isEmpty());
            FieldDescriptor fieldDescriptor = (FieldDescriptor)Iterables.getOnlyElement(baseDescriptor.getFieldsAccessed());
            return FieldAccessDescriptor.create().withNestedField(fieldDescriptor, FieldAccessDescriptor.withFieldNames(fieldNames));
        }
        Preconditions.checkArgument((boolean)baseDescriptor.getFieldsAccessed().isEmpty());
        Map.Entry entry = (Map.Entry)Iterables.getOnlyElement(baseDescriptor.getNestedFieldsAccessed().entrySet());
        return FieldAccessDescriptor.create().withNestedField((FieldDescriptor)entry.getKey(), FieldAccessDescriptor.withFieldNames((FieldAccessDescriptor)entry.getValue(), fieldNames));
    }

    public static @UnknownKeyFor @NonNull @Initialized FieldAccessDescriptor withFieldIds(@UnknownKeyFor @NonNull @Initialized FieldAccessDescriptor baseDescriptor, Integer ... fieldIds) {
        return FieldAccessDescriptor.withFieldIds(baseDescriptor, Arrays.asList(fieldIds));
    }

    public static @UnknownKeyFor @NonNull @Initialized FieldAccessDescriptor withFieldIds(@UnknownKeyFor @NonNull @Initialized FieldAccessDescriptor baseDescriptor, @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized Integer> fieldIds) {
        if (baseDescriptor.getFieldsAccessed().isEmpty() && baseDescriptor.getNestedFieldsAccessed().isEmpty()) {
            return FieldAccessDescriptor.withFieldIds(fieldIds);
        }
        if (!baseDescriptor.getFieldsAccessed().isEmpty()) {
            Preconditions.checkArgument((boolean)baseDescriptor.getNestedFieldsAccessed().isEmpty());
            FieldDescriptor fieldDescriptor = (FieldDescriptor)Iterables.getOnlyElement(baseDescriptor.getFieldsAccessed());
            return FieldAccessDescriptor.create().withNestedField(fieldDescriptor, FieldAccessDescriptor.withFieldIds(fieldIds));
        }
        Preconditions.checkArgument((boolean)baseDescriptor.getFieldsAccessed().isEmpty());
        Map.Entry entry = (Map.Entry)Iterables.getOnlyElement(baseDescriptor.getNestedFieldsAccessed().entrySet());
        return FieldAccessDescriptor.create().withNestedField((FieldDescriptor)entry.getKey(), FieldAccessDescriptor.withFieldIds((FieldAccessDescriptor)entry.getValue(), fieldIds));
    }

    public static @UnknownKeyFor @NonNull @Initialized FieldAccessDescriptor withFieldIds(Integer ... ids) {
        return FieldAccessDescriptor.withFieldIds(Arrays.asList(ids));
    }

    public static @UnknownKeyFor @NonNull @Initialized FieldAccessDescriptor withFieldIds(@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized Integer> ids) {
        List<FieldDescriptor> fields = StreamSupport.stream(ids.spliterator(), false).map(n -> FieldDescriptor.builder().setFieldId((Integer)n).build()).collect(Collectors.toList());
        return FieldAccessDescriptor.withFields(fields);
    }

    public static @UnknownKeyFor @NonNull @Initialized FieldAccessDescriptor withFields(FieldDescriptor ... fields) {
        return FieldAccessDescriptor.withFields(Arrays.asList(fields));
    }

    public static @UnknownKeyFor @NonNull @Initialized FieldAccessDescriptor withFields(@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized FieldDescriptor> fields) {
        return FieldAccessDescriptor.builder().setFieldsAccessed(Lists.newArrayList(fields)).build();
    }

    public static @UnknownKeyFor @NonNull @Initialized FieldAccessDescriptor union(@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized FieldAccessDescriptor> fieldAccessDescriptors) {
        LinkedHashSet fieldsAccessed = Sets.newLinkedHashSet();
        LinkedListMultimap nestedFieldsAccessed = LinkedListMultimap.create();
        for (FieldAccessDescriptor fieldAccessDescriptor : fieldAccessDescriptors) {
            if (fieldAccessDescriptor.getAllFields()) {
                return FieldAccessDescriptor.withAllFields();
            }
            for (FieldDescriptor fieldDescriptor : fieldAccessDescriptor.getFieldsAccessed()) {
                fieldsAccessed.add(fieldDescriptor);
                nestedFieldsAccessed.removeAll((Object)fieldDescriptor);
            }
            for (Map.Entry entry : fieldAccessDescriptor.getNestedFieldsAccessed().entrySet()) {
                FieldDescriptor field = (FieldDescriptor)entry.getKey();
                nestedFieldsAccessed.put((Object)field, (Object)((FieldAccessDescriptor)entry.getValue()));
            }
        }
        FieldAccessDescriptor fieldAccessDescriptor = FieldAccessDescriptor.withFields(fieldsAccessed);
        for (Map.Entry entry : nestedFieldsAccessed.asMap().entrySet()) {
            if (fieldsAccessed.contains(entry.getKey())) continue;
            fieldAccessDescriptor = fieldAccessDescriptor.withNestedField((FieldDescriptor)entry.getKey(), FieldAccessDescriptor.union((Iterable)entry.getValue()));
        }
        return fieldAccessDescriptor;
    }

    public static @UnknownKeyFor @NonNull @Initialized FieldAccessDescriptor create() {
        return FieldAccessDescriptor.builder().build();
    }

    public @UnknownKeyFor @NonNull @Initialized FieldAccessDescriptor withFieldNameAs(@UnknownKeyFor @NonNull @Initialized String fieldName, @UnknownKeyFor @NonNull @Initialized String fieldRename) {
        FieldAccessDescriptor fieldAccessDescriptor = FieldAccessDescriptorParser.parse(fieldName).renameSingleField(fieldRename);
        return FieldAccessDescriptor.union((Iterable<FieldAccessDescriptor>)ImmutableList.of((Object)this, (Object)fieldAccessDescriptor));
    }

    private @UnknownKeyFor @NonNull @Initialized FieldAccessDescriptor renameSingleField(@UnknownKeyFor @NonNull @Initialized String fieldRename) {
        Preconditions.checkArgument((boolean)this.referencesSingleField());
        if (!this.getFieldsAccessed().isEmpty()) {
            FieldDescriptor fieldDescriptor = (FieldDescriptor)Iterables.getOnlyElement(this.getFieldsAccessed());
            fieldDescriptor = fieldDescriptor.toBuilder().setFieldRename(fieldRename).build();
            return this.toBuilder().setFieldsAccessed((List<FieldDescriptor>)ImmutableList.of((Object)fieldDescriptor)).build();
        }
        Map.Entry entry = (Map.Entry)Iterables.getOnlyElement(this.getNestedFieldsAccessed().entrySet());
        return this.toBuilder().setNestedFieldsAccessed((Map<FieldDescriptor, FieldAccessDescriptor>)ImmutableMap.of((Object)((FieldDescriptor)entry.getKey()), (Object)((FieldAccessDescriptor)entry.getValue()).renameSingleField(fieldRename))).build();
    }

    public @UnknownKeyFor @NonNull @Initialized FieldAccessDescriptor withNestedField(@UnknownKeyFor @NonNull @Initialized int nestedFieldId, @UnknownKeyFor @NonNull @Initialized FieldAccessDescriptor fieldAccess) {
        FieldDescriptor field = FieldDescriptor.builder().setFieldId(nestedFieldId).build();
        return this.withNestedField(field, fieldAccess);
    }

    public @UnknownKeyFor @NonNull @Initialized FieldAccessDescriptor withNestedField(@UnknownKeyFor @NonNull @Initialized String nestedFieldName, @UnknownKeyFor @NonNull @Initialized FieldAccessDescriptor fieldAccess) {
        FieldDescriptor field = FieldDescriptor.builder().setFieldName(nestedFieldName).build();
        return this.withNestedField(field, fieldAccess);
    }

    public @UnknownKeyFor @NonNull @Initialized FieldAccessDescriptor withNestedFieldAs(@UnknownKeyFor @NonNull @Initialized String nestedFieldName, @UnknownKeyFor @NonNull @Initialized String nestedFieldRename, @UnknownKeyFor @NonNull @Initialized FieldAccessDescriptor fieldAccess) {
        FieldDescriptor field = FieldDescriptor.builder().setFieldName(nestedFieldName).setFieldRename(nestedFieldRename).build();
        return this.withNestedField(field, fieldAccess);
    }

    public @UnknownKeyFor @NonNull @Initialized FieldAccessDescriptor withNestedField(@UnknownKeyFor @NonNull @Initialized FieldDescriptor field, @UnknownKeyFor @NonNull @Initialized FieldAccessDescriptor fieldAccess) {
        LinkedHashMap newNestedFieldAccess = Maps.newLinkedHashMap(this.getNestedFieldsAccessed());
        newNestedFieldAccess.put(field, fieldAccess);
        return this.toBuilder().setNestedFieldsAccessed(newNestedFieldAccess).build();
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Integer> fieldIdsAccessed() {
        return this.getFieldsAccessed().stream().map(FieldDescriptor::getFieldId).collect(Collectors.toList());
    }

    public @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> fieldNamesAccessed() {
        return this.getFieldsAccessed().stream().map(FieldDescriptor::getFieldName).collect(Collectors.toSet());
    }

    public @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized Integer, @UnknownKeyFor @NonNull @Initialized FieldAccessDescriptor> nestedFieldsById() {
        return this.getNestedFieldsAccessed().entrySet().stream().collect(Collectors.toMap(f -> ((FieldDescriptor)f.getKey()).getFieldId(), f -> (FieldAccessDescriptor)f.getValue()));
    }

    public @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized FieldAccessDescriptor> nestedFieldsByName() {
        return this.getNestedFieldsAccessed().entrySet().stream().collect(Collectors.toMap(f -> ((FieldDescriptor)f.getKey()).getFieldName(), f -> (FieldAccessDescriptor)f.getValue()));
    }

    public @UnknownKeyFor @NonNull @Initialized boolean referencesSingleField() {
        if (this.getAllFields()) {
            return false;
        }
        if (this.getFieldsAccessed().size() == 1 && this.getNestedFieldsAccessed().isEmpty()) {
            return true;
        }
        if (this.getFieldsAccessed().isEmpty() && this.getNestedFieldsAccessed().size() == 1) {
            return this.getNestedFieldsAccessed().values().iterator().next().referencesSingleField();
        }
        return false;
    }

    public @UnknownKeyFor @NonNull @Initialized FieldAccessDescriptor resolve(@UnknownKeyFor @NonNull @Initialized Schema schema) {
        List<FieldDescriptor> resolvedFieldIdsAccessed = this.resolveDirectFieldsAccessed(schema);
        Map<FieldDescriptor, FieldAccessDescriptor> resolvedNestedFieldsAccessed = this.resolveNestedFieldsAccessed(schema);
        Preconditions.checkState((!this.getAllFields() || resolvedNestedFieldsAccessed.isEmpty() ? 1 : 0) != 0, (Object)"nested fields cannot be set if allFields is also set");
        resolvedFieldIdsAccessed.removeAll(resolvedNestedFieldsAccessed.keySet());
        return FieldAccessDescriptor.builder().setAllFields(this.getAllFields()).setFieldsAccessed(resolvedFieldIdsAccessed).setNestedFieldsAccessed(resolvedNestedFieldsAccessed).build();
    }

    private @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized FieldDescriptor> resolveDirectFieldsAccessed(@UnknownKeyFor @NonNull @Initialized Schema schema) {
        ArrayList<FieldDescriptor> fields = new ArrayList<FieldDescriptor>();
        for (FieldDescriptor field : this.getFieldsAccessed()) {
            FieldAccessDescriptor.validateFieldDescriptor(schema, field);
            if (field.getFieldId() == null) {
                field = field.toBuilder().setFieldId(schema.indexOf(field.getFieldName())).build();
            }
            if (field.getFieldName() == null) {
                field = field.toBuilder().setFieldName(schema.nameOf(field.getFieldId())).build();
            }
            field = this.fillInMissingQualifiers(field, schema);
            fields.add(field);
        }
        return fields;
    }

    private @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized FieldDescriptor, @UnknownKeyFor @NonNull @Initialized FieldAccessDescriptor> resolveNestedFieldsAccessed(@UnknownKeyFor @NonNull @Initialized Schema schema) {
        LinkedHashMap nestedFields = Maps.newLinkedHashMap();
        for (Map.Entry<FieldDescriptor, FieldAccessDescriptor> entry : this.getNestedFieldsAccessed().entrySet()) {
            FieldDescriptor fieldDescriptor = entry.getKey();
            FieldAccessDescriptor fieldAccessDescriptor = entry.getValue();
            FieldAccessDescriptor.validateFieldDescriptor(schema, fieldDescriptor);
            if (entry.getKey().getFieldId() == null) {
                fieldDescriptor = fieldDescriptor.toBuilder().setFieldId(schema.indexOf(fieldDescriptor.getFieldName())).build();
            } else if (entry.getKey().getFieldName() == null) {
                fieldDescriptor = fieldDescriptor.toBuilder().setFieldName(schema.nameOf(fieldDescriptor.getFieldId())).build();
            }
            fieldDescriptor = this.fillInMissingQualifiers(fieldDescriptor, schema);
            fieldAccessDescriptor = fieldAccessDescriptor.resolve(this.getFieldDescriptorSchema(fieldDescriptor, schema));
            nestedFields.merge(fieldDescriptor, fieldAccessDescriptor, (d1, d2) -> FieldAccessDescriptor.union((Iterable<FieldAccessDescriptor>)ImmutableList.of((Object)d1, (Object)d2)));
        }
        return nestedFields;
    }

    private @UnknownKeyFor @NonNull @Initialized FieldDescriptor fillInMissingQualifiers(@UnknownKeyFor @NonNull @Initialized FieldDescriptor fieldDescriptor, @UnknownKeyFor @NonNull @Initialized Schema schema) {
        Schema.FieldType fieldType = schema.getField(fieldDescriptor.getFieldId()).getType();
        Iterator<FieldDescriptor.Qualifier> qualifierIt = fieldDescriptor.getQualifiers().iterator();
        ArrayList qualifiers = Lists.newArrayList();
        while (fieldType.getTypeName().isCollectionType() || fieldType.getTypeName().isMapType()) {
            FieldDescriptor.Qualifier qualifier;
            FieldDescriptor.Qualifier qualifier2 = qualifier = qualifierIt.hasNext() ? qualifierIt.next() : null;
            if (fieldType.getTypeName().isCollectionType()) {
                qualifier = qualifier == null ? FieldDescriptor.Qualifier.of(FieldDescriptor.ListQualifier.ALL) : qualifier;
                Preconditions.checkArgument((boolean)qualifier.getKind().equals((Object)FieldDescriptor.Qualifier.Kind.LIST));
                Preconditions.checkArgument((boolean)qualifier.getList().equals((Object)FieldDescriptor.ListQualifier.ALL));
                qualifiers.add(qualifier);
                fieldType = fieldType.getCollectionElementType();
                continue;
            }
            if (!fieldType.getTypeName().isMapType()) continue;
            qualifier = qualifier == null ? FieldDescriptor.Qualifier.of(FieldDescriptor.MapQualifier.ALL) : qualifier;
            Preconditions.checkArgument((boolean)qualifier.getKind().equals((Object)FieldDescriptor.Qualifier.Kind.MAP));
            Preconditions.checkArgument((boolean)qualifier.getMap().equals((Object)FieldDescriptor.MapQualifier.ALL));
            qualifiers.add(qualifier);
            fieldType = fieldType.getMapValueType();
        }
        return fieldDescriptor.toBuilder().setQualifiers(qualifiers).build();
    }

    private @UnknownKeyFor @NonNull @Initialized Schema getFieldDescriptorSchema(@UnknownKeyFor @NonNull @Initialized FieldDescriptor fieldDescriptor, @UnknownKeyFor @NonNull @Initialized Schema schema) {
        Schema.FieldType fieldType = schema.getField(fieldDescriptor.getFieldId()).getType();
        while (fieldType.getTypeName().isCollectionType() || fieldType.getTypeName().isMapType()) {
            if (fieldType.getTypeName().isCollectionType()) {
                fieldType = fieldType.getCollectionElementType();
                continue;
            }
            if (!fieldType.getTypeName().isMapType()) continue;
            fieldType = fieldType.getMapValueType();
        }
        return FieldAccessDescriptor.getFieldSchema(fieldType);
    }

    private static @UnknownKeyFor @NonNull @Initialized Schema getFieldSchema(@UnknownKeyFor @NonNull @Initialized Schema.FieldType type) {
        if (Schema.TypeName.ROW.equals((Object)type.getTypeName())) {
            return type.getRowSchema();
        }
        if (type.getTypeName().isCollectionType()) {
            return FieldAccessDescriptor.getFieldSchema(type.getCollectionElementType());
        }
        if (Schema.TypeName.MAP.equals((Object)type.getTypeName())) {
            return FieldAccessDescriptor.getFieldSchema(type.getMapValueType());
        }
        if (Schema.TypeName.LOGICAL_TYPE.equals((Object)type.getTypeName())) {
            return FieldAccessDescriptor.getFieldSchema(type.getLogicalType().getBaseType());
        }
        throw new IllegalArgumentException("FieldType " + type + " must be either a row or a container containing rows");
    }

    private static void validateFieldDescriptor(@UnknownKeyFor @NonNull @Initialized Schema schema, @UnknownKeyFor @NonNull @Initialized FieldDescriptor fieldDescriptor) {
        Integer fieldId = fieldDescriptor.getFieldId();
        if (fieldId != null && (fieldId < 0 || fieldId >= schema.getFieldCount())) {
            throw new IllegalArgumentException("Invalid field id " + fieldId + " for schema " + schema);
        }
        Schema.Field field = fieldId != null ? schema.getField(fieldId) : schema.getField(fieldDescriptor.getFieldName());
        Schema.FieldType fieldType = field.getType();
        block4: for (FieldDescriptor.Qualifier qualifier : fieldDescriptor.getQualifiers()) {
            switch (qualifier.getKind()) {
                case LIST: {
                    Preconditions.checkArgument((boolean)qualifier.getList().equals((Object)FieldDescriptor.ListQualifier.ALL));
                    Preconditions.checkArgument((boolean)fieldType.getTypeName().isCollectionType());
                    fieldType = fieldType.getCollectionElementType();
                    continue block4;
                }
                case MAP: {
                    Preconditions.checkArgument((boolean)qualifier.getMap().equals((Object)FieldDescriptor.MapQualifier.ALL));
                    Preconditions.checkArgument((boolean)fieldType.getTypeName().equals((Object)Schema.TypeName.MAP));
                    fieldType = fieldType.getMapValueType();
                    continue block4;
                }
            }
            throw new IllegalStateException("Unexpected qualifier type " + (Object)((Object)qualifier.getKind()));
        }
    }

    @SideEffectFree
    public final @UnknownKeyFor @NonNull @Initialized String toString() {
        if (this.getAllFields()) {
            return "*";
        }
        List singleSelectors = this.getFieldsAccessed().stream().map(FieldDescriptor::getFieldName).collect(Collectors.toList());
        List nestedSelectors = this.getNestedFieldsAccessed().entrySet().stream().map(e -> ((FieldDescriptor)e.getKey()).getFieldName() + "." + ((FieldAccessDescriptor)e.getValue()).toString()).collect(Collectors.toList());
        return String.join((CharSequence)", ", Iterables.concat(singleSelectors, nestedSelectors));
    }

    @AutoValue.Builder
    static abstract class Builder {
        Builder() {
        }

        abstract @UnknownKeyFor @NonNull @Initialized Builder setAllFields(@UnknownKeyFor @NonNull @Initialized boolean var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder setFieldsAccessed(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized FieldDescriptor> var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder setNestedFieldsAccessed(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized FieldDescriptor, @UnknownKeyFor @NonNull @Initialized FieldAccessDescriptor> var1);

        abstract @UnknownKeyFor @NonNull @Initialized FieldAccessDescriptor build();
    }

    @AutoValue
    public static abstract class FieldDescriptor
    implements Serializable {
        public abstract @Nullable @UnknownKeyFor @Initialized String getFieldName();

        public abstract @Nullable @UnknownKeyFor @Initialized Integer getFieldId();

        public abstract @Nullable @UnknownKeyFor @Initialized String getFieldRename();

        public abstract @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Qualifier> getQualifiers();

        public static @UnknownKeyFor @NonNull @Initialized Builder builder() {
            return new AutoValue_FieldAccessDescriptor_FieldDescriptor.Builder().setQualifiers(Collections.emptyList());
        }

        abstract @UnknownKeyFor @NonNull @Initialized Builder toBuilder();

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract @UnknownKeyFor @NonNull @Initialized Builder setFieldName(@Nullable @UnknownKeyFor @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setFieldId(@Nullable @UnknownKeyFor @Initialized Integer var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setFieldRename(@Nullable @UnknownKeyFor @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setQualifiers(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Qualifier> var1);

            public abstract @UnknownKeyFor @NonNull @Initialized FieldDescriptor build();
        }

        @AutoOneOf(value=Kind.class)
        public static abstract class Qualifier
        implements Serializable {
            public abstract @UnknownKeyFor @NonNull @Initialized Kind getKind();

            public abstract @UnknownKeyFor @NonNull @Initialized ListQualifier getList();

            public abstract @UnknownKeyFor @NonNull @Initialized MapQualifier getMap();

            public static @UnknownKeyFor @NonNull @Initialized Qualifier of(@UnknownKeyFor @NonNull @Initialized ListQualifier qualifier) {
                return AutoOneOf_FieldAccessDescriptor_FieldDescriptor_Qualifier.list(qualifier);
            }

            public static @UnknownKeyFor @NonNull @Initialized Qualifier of(@UnknownKeyFor @NonNull @Initialized MapQualifier qualifier) {
                return AutoOneOf_FieldAccessDescriptor_FieldDescriptor_Qualifier.map(qualifier);
            }

            public static enum Kind {
                LIST,
                MAP;

            }
        }

        public static enum MapQualifier {
            ALL;

        }

        public static enum ListQualifier {
            ALL;

        }
    }
}

