/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas.transforms;

import com.google.auto.value.AutoValue;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.beam.sdk.schemas.FieldAccessDescriptor;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.transforms.AutoValue_Select_Fields;
import org.apache.beam.sdk.schemas.transforms.AutoValue_Select_Flattened;
import org.apache.beam.sdk.schemas.utils.RowSelector;
import org.apache.beam.sdk.schemas.utils.SelectHelpers;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.MoreObjects;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class Select {
    public static <T> @UnknownKeyFor @NonNull @Initialized Fields<T> create() {
        return Select.fieldAccess(FieldAccessDescriptor.create());
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized Fields<T> fieldIds(Integer ... ids) {
        return Select.fieldAccess(FieldAccessDescriptor.withFieldIds(ids));
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized Fields<T> fieldNames(String ... names) {
        return Select.fieldAccess(FieldAccessDescriptor.withFieldNames(names));
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized Fields<T> fieldAccess(@UnknownKeyFor @NonNull @Initialized FieldAccessDescriptor fieldAccessDescriptor) {
        return new AutoValue_Select_Fields.Builder().setFieldAccessDescriptor(fieldAccessDescriptor).build();
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized Flattened<T> flattenedSchema() {
        return new AutoValue_Select_Flattened.Builder().setNameFn(SelectHelpers.CONCAT_FIELD_NAMES).setNameOverrides(Collections.emptyMap()).build();
    }

    private static @UnknownKeyFor @NonNull @Initialized Schema uniquifyNames(@UnknownKeyFor @NonNull @Initialized Schema schema) {
        Schema.Builder builder = new Schema.Builder();
        for (Schema.Field field : schema.getFields()) {
            builder.addField(UUID.randomUUID().toString(), Select.uniquifyNames(field.getType()));
        }
        return builder.build();
    }

    private static @UnknownKeyFor @NonNull @Initialized Schema.FieldType uniquifyNames(@UnknownKeyFor @NonNull @Initialized Schema.FieldType fieldType) {
        switch (fieldType.getTypeName()) {
            case ROW: {
                return Schema.FieldType.row(Select.uniquifyNames(fieldType.getRowSchema())).withNullable(fieldType.getNullable()).withMetadata(fieldType.getAllMetadata());
            }
            case ARRAY: {
                return Schema.FieldType.array(Select.uniquifyNames(fieldType.getCollectionElementType())).withNullable(fieldType.getNullable());
            }
            case ITERABLE: {
                return Schema.FieldType.iterable(Select.uniquifyNames(fieldType.getCollectionElementType())).withNullable(fieldType.getNullable());
            }
            case MAP: {
                return Schema.FieldType.map(Select.uniquifyNames(fieldType.getMapKeyType()), Select.uniquifyNames(fieldType.getMapValueType())).withNullable(fieldType.getNullable());
            }
        }
        return fieldType;
    }

    @AutoValue
    public static abstract class Flattened<@UnknownKeyFor T>
    extends PTransform<PCollection<T>, PCollection<Row>> {
        abstract @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String>, @UnknownKeyFor @NonNull @Initialized String> getNameFn();

        abstract @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> getNameOverrides();

        abstract @Nullable @UnknownKeyFor @Initialized Schema getOutputSchema();

        abstract @UnknownKeyFor @NonNull @Initialized Builder<T> toBuilder();

        public @UnknownKeyFor @NonNull @Initialized Flattened<T> concatFieldNames() {
            return this.toBuilder().setNameFn(SelectHelpers.CONCAT_FIELD_NAMES).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Flattened<T> keepMostNestedFieldName() {
            return this.toBuilder().setNameFn(SelectHelpers.KEEP_NESTED_NAME).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Flattened<T> withFieldNameAs(@UnknownKeyFor @NonNull @Initialized String fieldName, @UnknownKeyFor @NonNull @Initialized String fieldRename) {
            ImmutableMap overrides = ImmutableMap.builder().putAll(this.getNameOverrides()).put((Object)fieldName, (Object)fieldRename).build();
            return this.toBuilder().setNameOverrides((Map<String, String>)overrides).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Flattened<T> withOutputSchema(@UnknownKeyFor @NonNull @Initialized Schema schema) {
            return this.toBuilder().setOutputSchema(schema).build();
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> expand(@UnknownKeyFor @NonNull @Initialized PCollection<T> input) {
            Schema inputSchema = input.getSchema();
            FieldAccessDescriptor fieldAccessDescriptor = SelectHelpers.allLeavesDescriptor(inputSchema, n -> (String)MoreObjects.firstNonNull((Object)this.getNameOverrides().get(String.join((CharSequence)".", n)), (Object)this.getNameFn().apply((List<String>)n)));
            Schema inferredOutputSchema = SelectHelpers.getOutputSchema(inputSchema, fieldAccessDescriptor);
            Schema outputSchema = this.getOutputSchema();
            if (outputSchema != null) {
                Preconditions.checkArgument((boolean)outputSchema.typesEqual(inferredOutputSchema));
            } else {
                outputSchema = inferredOutputSchema;
            }
            return ((PCollection)input.apply(ParDo.of(new SelectDoFn(fieldAccessDescriptor, inputSchema, outputSchema)))).setRowSchema(outputSchema);
        }

        @AutoValue.Builder
        static abstract class Builder<@UnknownKeyFor T> {
            Builder() {
            }

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setNameFn(@UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String>, @UnknownKeyFor @NonNull @Initialized String> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setNameOverrides(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setOutputSchema(@Nullable @UnknownKeyFor @Initialized Schema var1);

            abstract @UnknownKeyFor @NonNull @Initialized Flattened<T> build();
        }
    }

    @AutoValue
    public static abstract class Fields<@UnknownKeyFor T>
    extends PTransform<PCollection<T>, PCollection<Row>> {
        abstract @UnknownKeyFor @NonNull @Initialized FieldAccessDescriptor getFieldAccessDescriptor();

        abstract @Nullable @UnknownKeyFor @Initialized Schema getOutputSchema();

        abstract @UnknownKeyFor @NonNull @Initialized Builder<T> toBuilder();

        public @UnknownKeyFor @NonNull @Initialized Fields<T> withFieldNameAs(@UnknownKeyFor @NonNull @Initialized String fieldName, @UnknownKeyFor @NonNull @Initialized String fieldRename) {
            return this.toBuilder().setFieldAccessDescriptor(this.getFieldAccessDescriptor().withFieldNameAs(fieldName, fieldRename)).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Fields<T> withOutputSchema(@UnknownKeyFor @NonNull @Initialized Schema schema) {
            return this.toBuilder().setOutputSchema(schema).build();
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> expand(@UnknownKeyFor @NonNull @Initialized PCollection<T> input) {
            Schema inputSchema = input.getSchema();
            FieldAccessDescriptor resolved = this.getFieldAccessDescriptor().resolve(inputSchema);
            Schema outputSchema = this.getOutputSchema();
            if (outputSchema == null) {
                outputSchema = SelectHelpers.getOutputSchema(inputSchema, resolved);
            } else {
                inputSchema = Select.uniquifyNames(inputSchema);
                Schema inferredSchema = SelectHelpers.getOutputSchema(inputSchema, resolved);
                Preconditions.checkArgument((boolean)outputSchema.typesEqual(inferredSchema), (Object)("Types not equal. provided output schema: " + outputSchema + " Schema inferred from select: " + inferredSchema + " from input type: " + input.getSchema()));
            }
            return ((PCollection)input.apply(ParDo.of(new SelectDoFn(resolved, inputSchema, outputSchema)))).setRowSchema(outputSchema);
        }

        @AutoValue.Builder
        static abstract class Builder<@UnknownKeyFor T> {
            Builder() {
            }

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setFieldAccessDescriptor(@UnknownKeyFor @NonNull @Initialized FieldAccessDescriptor var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setOutputSchema(@UnknownKeyFor @NonNull @Initialized Schema var1);

            abstract @UnknownKeyFor @NonNull @Initialized Fields<T> build();
        }
    }

    private static class SelectDoFn<@UnknownKeyFor T>
    extends DoFn<T, Row> {
        @UnknownKeyFor @NonNull @Initialized RowSelector rowSelector;
        @DoFn.FieldAccess(value="selectFields")
        final @UnknownKeyFor @NonNull @Initialized FieldAccessDescriptor fieldAccess = FieldAccessDescriptor.withAllFields();

        public SelectDoFn(@UnknownKeyFor @NonNull @Initialized FieldAccessDescriptor fieldAccessDescriptor, @UnknownKeyFor @NonNull @Initialized Schema inputSchema, @UnknownKeyFor @NonNull @Initialized Schema outputSchema) {
            this.rowSelector = new SelectHelpers.RowSelectorContainer(inputSchema, fieldAccessDescriptor, true);
        }

        @DoFn.ProcessElement
        public void process(@DoFn.FieldAccess(value="selectFields") @DoFn.Element @UnknownKeyFor @NonNull @Initialized Row row, @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized Row> r) {
            r.output(this.rowSelector.select(row));
        }
    }
}

