/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms;

import java.io.Serializable;
import org.apache.beam.sdk.transforms.ProcessFunction;
import org.apache.beam.sdk.transforms.Requirements;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.MoreObjects;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;

public final class Contextful<@UnknownKeyFor ClosureT>
implements Serializable {
    private final ClosureT closure;
    private final @UnknownKeyFor @NonNull @Initialized Requirements requirements;

    private Contextful(ClosureT closure, @UnknownKeyFor @NonNull @Initialized Requirements requirements) {
        this.closure = closure;
        this.requirements = requirements;
    }

    public ClosureT getClosure() {
        return this.closure;
    }

    public @UnknownKeyFor @NonNull @Initialized Requirements getRequirements() {
        return this.requirements;
    }

    public static <ClosureT> @UnknownKeyFor @NonNull @Initialized Contextful<ClosureT> of(ClosureT closure, @UnknownKeyFor @NonNull @Initialized Requirements requirements) {
        return new Contextful<ClosureT>(closure, requirements);
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return MoreObjects.toStringHelper((Object)this).add("closure", this.closure).add("requirements", (Object)this.requirements).toString();
    }

    public static <InputT, OutputT> @UnknownKeyFor @NonNull @Initialized Contextful<@UnknownKeyFor @NonNull @Initialized Fn<InputT, OutputT>> fn(@UnknownKeyFor @NonNull @Initialized ProcessFunction<InputT, OutputT> fn) {
        return new Contextful<Fn<InputT, OutputT>>((element, c) -> fn.apply(element), Requirements.empty());
    }

    public static <InputT, OutputT> @UnknownKeyFor @NonNull @Initialized Contextful<@UnknownKeyFor @NonNull @Initialized Fn<InputT, OutputT>> fn(@UnknownKeyFor @NonNull @Initialized SerializableFunction<InputT, OutputT> fn) {
        return Contextful.fn(fn);
    }

    public static <InputT, OutputT> @UnknownKeyFor @NonNull @Initialized Contextful<@UnknownKeyFor @NonNull @Initialized Fn<InputT, OutputT>> fn(@UnknownKeyFor @NonNull @Initialized Fn<InputT, OutputT> fn, @UnknownKeyFor @NonNull @Initialized Requirements requirements) {
        return Contextful.of(fn, requirements);
    }

    public static interface Fn<@UnknownKeyFor InputT, @UnknownKeyFor OutputT>
    extends Serializable {
        public OutputT apply(InputT var1, @UnknownKeyFor @NonNull @Initialized Context var2) throws @UnknownKeyFor @NonNull @Initialized Exception;

        public static abstract class Context {
            public <T> T sideInput(@UnknownKeyFor @NonNull @Initialized PCollectionView<T> view) {
                throw new UnsupportedOperationException();
            }

            public static <InputT> @UnknownKeyFor @NonNull @Initialized Context wrapProcessContext(/*
             * Issues handling annotations - annotations may be inaccurate
             */
             @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) {
                return new ContextFromProcessContext(c);
            }

            private static class ContextFromProcessContext<@UnknownKeyFor InputT>
            extends Context {
                private final /*
                 * Issues handling annotations - annotations may be inaccurate
                 */
                 @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c;

                ContextFromProcessContext(/*
                 * Issues handling annotations - annotations may be inaccurate
                 */
                 @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) {
                    this.c = c;
                }

                @Override
                public <T> T sideInput(@UnknownKeyFor @NonNull @Initialized PCollectionView<T> view) {
                    return this.c.sideInput(view);
                }
            }
        }
    }
}

