/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms;

import java.util.concurrent.ThreadLocalRandom;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.GroupByKey;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.Reify;
import org.apache.beam.sdk.transforms.ReifyTimestamps;
import org.apache.beam.sdk.transforms.Values;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.ReshuffleTrigger;
import org.apache.beam.sdk.transforms.windowing.TimestampCombiner;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.util.IdentityWindowFn;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.TimestampedValue;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.primitives.UnsignedInteger;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;

@Deprecated
@Internal
public class Reshuffle<@UnknownKeyFor K, @UnknownKeyFor V>
extends PTransform<PCollection<KV<K, V>>, PCollection<KV<K, V>>> {
    private Reshuffle() {
    }

    public static <K, V> @UnknownKeyFor @NonNull @Initialized Reshuffle<K, V> of() {
        return new Reshuffle<K, V>();
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized ViaRandomKey<T> viaRandomKey() {
        return new ViaRandomKey();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, V>> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, V>> input) {
        WindowingStrategy<?, ?> originalStrategy = input.getWindowingStrategy();
        Window rewindow = Window.into(new IdentityWindowFn(originalStrategy.getWindowFn().windowCoder())).triggering(new ReshuffleTrigger()).discardingFiredPanes().withTimestampCombiner(TimestampCombiner.EARLIEST).withAllowedLateness(Duration.millis((long)BoundedWindow.TIMESTAMP_MAX_VALUE.getMillis()));
        return ((PCollection)((PCollection)((PCollection)input.apply(rewindow)).apply("ReifyOriginalTimestamps", Reify.timestampsInValue()).apply(GroupByKey.create())).setWindowingStrategyInternal(originalStrategy).apply("ExpandIterable", ParDo.of(new DoFn<KV<K, Iterable<TimestampedValue<V>>>, KV<K, TimestampedValue<V>>>(){

            @DoFn.ProcessElement
            public void processElement(@DoFn.Element @UnknownKeyFor @NonNull @Initialized KV<K, @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized TimestampedValue<V>>> element, @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized KV<K, @UnknownKeyFor @NonNull @Initialized TimestampedValue<V>>> r) {
                Object key = element.getKey();
                for (TimestampedValue value : element.getValue()) {
                    r.output(KV.of(key, value));
                }
            }
        }))).apply("RestoreOriginalTimestamps", ReifyTimestamps.extractFromValues());
    }

    public static class AssignShardFn<@UnknownKeyFor T>
    extends DoFn<T, KV<Integer, T>> {
        private @UnknownKeyFor @NonNull @Initialized int shard;
        private @Nullable @UnknownKeyFor @Initialized Integer numBuckets;

        public AssignShardFn(@Nullable @UnknownKeyFor @Initialized Integer numBuckets) {
            this.numBuckets = numBuckets;
        }

        @DoFn.Setup
        public void setup() {
            this.shard = ThreadLocalRandom.current().nextInt();
        }

        @DoFn.ProcessElement
        public void processElement(@DoFn.Element T element, @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Integer, T>> r) {
            ++this.shard;
            int hashOfShard = 461845907 * Integer.rotateLeft(this.shard * -862048943, 15);
            if (this.numBuckets != null) {
                UnsignedInteger unsignedNumBuckets = UnsignedInteger.fromIntBits((int)this.numBuckets);
                hashOfShard = UnsignedInteger.fromIntBits((int)hashOfShard).mod(unsignedNumBuckets).intValue();
            }
            r.output(KV.of(hashOfShard, element));
        }
    }

    public static class ViaRandomKey<@UnknownKeyFor T>
    extends PTransform<PCollection<T>, PCollection<T>> {
        private @Nullable @UnknownKeyFor @Initialized Integer numBuckets;

        private ViaRandomKey() {
        }

        private ViaRandomKey(@Nullable @UnknownKeyFor @Initialized Integer numBuckets) {
            this.numBuckets = numBuckets;
        }

        public @UnknownKeyFor @NonNull @Initialized ViaRandomKey<T> withNumBuckets(@Nullable @UnknownKeyFor @Initialized Integer numBuckets) {
            return new ViaRandomKey<T>(numBuckets);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollection<T> expand(@UnknownKeyFor @NonNull @Initialized PCollection<T> input) {
            return (PCollection)((PCollection)((PCollection)input.apply("Pair with random key", ParDo.of(new AssignShardFn(this.numBuckets)))).apply(Reshuffle.of())).apply(Values.create());
        }
    }
}

