/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.util.RowJson;
import org.apache.beam.sdk.util.RowJsonUtils;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.Row;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class ToJson<@UnknownKeyFor T>
extends PTransform<PCollection<T>, PCollection<String>> {
    private volatile transient @Nullable @UnknownKeyFor @Initialized ObjectMapper objectMapper;

    private ToJson() {
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized ToJson<T> of() {
        return new ToJson<T>();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized String> expand(@UnknownKeyFor @NonNull @Initialized PCollection<T> rows) {
        final Schema inputSchema = rows.getSchema();
        RowJson.verifySchemaSupported(inputSchema);
        final SerializableFunction<T, Row> toRow = rows.getToRowFunction();
        return (PCollection)rows.apply(ParDo.of(new DoFn<T, String>(){

            @DoFn.ProcessElement
            public void processElement(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext context) {
                context.output(RowJsonUtils.rowToJson(ToJson.this.objectMapper(inputSchema), (Row)toRow.apply(context.element())));
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private @UnknownKeyFor @NonNull @Initialized ObjectMapper objectMapper(@UnknownKeyFor @NonNull @Initialized Schema schema) {
        if (this.objectMapper == null) {
            ToJson toJson = this;
            synchronized (toJson) {
                if (this.objectMapper == null) {
                    this.objectMapper = RowJsonUtils.newObjectMapperWith(RowJson.RowJsonSerializer.forSchema(schema));
                }
            }
        }
        return this.objectMapper;
    }
}

