/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.values;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.beam.sdk.transforms.Contextful;
import org.apache.beam.sdk.transforms.ProcessFunction;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeParameter;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class TypeDescriptors {
    public static @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @NonNull @Initialized Boolean> booleans() {
        return new TypeDescriptor<Boolean>(){};
    }

    public static @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @NonNull @Initialized Double> doubles() {
        return new TypeDescriptor<Double>(){};
    }

    public static @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @NonNull @Initialized Float> floats() {
        return new TypeDescriptor<Float>(){};
    }

    public static @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @NonNull @Initialized Integer> integers() {
        return new TypeDescriptor<Integer>(){};
    }

    public static @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @NonNull @Initialized Long> longs() {
        return new TypeDescriptor<Long>(){};
    }

    public static @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @NonNull @Initialized Short> shorts() {
        return new TypeDescriptor<Short>(){};
    }

    public static @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @NonNull @Initialized BigDecimal> bigdecimals() {
        return new TypeDescriptor<BigDecimal>(){};
    }

    public static @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @NonNull @Initialized BigInteger> bigintegers() {
        return new TypeDescriptor<BigInteger>(){};
    }

    public static @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @NonNull @Initialized Row> rows() {
        return new TypeDescriptor<Row>(){};
    }

    public static @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @NonNull @Initialized String> strings() {
        return new TypeDescriptor<String>(){};
    }

    public static @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @NonNull @Initialized Character> characters() {
        return new TypeDescriptor<Character>(){};
    }

    public static @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @NonNull @Initialized Byte> bytes() {
        return new TypeDescriptor<Byte>(){};
    }

    public static @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @Nullable @Initialized Void> nulls() {
        return new TypeDescriptor<Void>(){};
    }

    public static <K, V> @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @NonNull @Initialized KV<K, V>> kvs(@UnknownKeyFor @NonNull @Initialized TypeDescriptor<K> key, @UnknownKeyFor @NonNull @Initialized TypeDescriptor<V> value) {
        return new TypeDescriptor<KV<K, V>>(){}.where(new TypeParameter<K>(){}, key).where(new TypeParameter<V>(){}, value);
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @NonNull @Initialized Set<T>> sets(@UnknownKeyFor @NonNull @Initialized TypeDescriptor<T> element) {
        return new TypeDescriptor<Set<T>>(){}.where(new TypeParameter<T>(){}, element);
    }

    public static <K, V> @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @NonNull @Initialized Map<K, V>> maps(@UnknownKeyFor @NonNull @Initialized TypeDescriptor<K> keyType, @UnknownKeyFor @NonNull @Initialized TypeDescriptor<V> valueType) {
        return new TypeDescriptor<Map<K, V>>(){}.where(new TypeParameter<K>(){}, keyType).where(new TypeParameter<V>(){}, valueType);
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @NonNull @Initialized List<T>> lists(@UnknownKeyFor @NonNull @Initialized TypeDescriptor<T> element) {
        return new TypeDescriptor<List<T>>(){}.where(new TypeParameter<T>(){}, element);
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @NonNull @Initialized Iterable<T>> iterables(@UnknownKeyFor @NonNull @Initialized TypeDescriptor<T> iterable) {
        return new TypeDescriptor<Iterable<T>>(){}.where(new TypeParameter<T>(){}, iterable);
    }

    public static @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @Nullable @Initialized Void> voids() {
        return new TypeDescriptor<Void>(){};
    }

    public static <T, V> @UnknownKeyFor @NonNull @Initialized TypeDescriptor<V> extractFromTypeParameters(@NonNull T instance, @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @Nullable @Initialized ? super T> supertype, @UnknownKeyFor @NonNull @Initialized TypeVariableExtractor<T, V> extractor) {
        return TypeDescriptors.extractFromTypeParameters(TypeDescriptor.of(instance.getClass()), supertype, extractor);
    }

    public static <T, V> @UnknownKeyFor @NonNull @Initialized TypeDescriptor<V> extractFromTypeParameters(@UnknownKeyFor @NonNull @Initialized TypeDescriptor<T> type, @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @Nullable @Initialized ? super T> supertype, @UnknownKeyFor @NonNull @Initialized TypeVariableExtractor<T, V> extractor) {
        TypeDescriptor<TypeVariableExtractor> extractorSupertype = TypeDescriptor.of(extractor.getClass()).getSupertype(TypeVariableExtractor.class);
        Type inputT = ((ParameterizedType)extractorSupertype.getType()).getActualTypeArguments()[0];
        TypeDescriptor<T> supertypeDescriptor = type.getSupertype(supertype);
        TypeDescriptor<TypeVariableExtractor> extractorT = extractorSupertype.where(inputT, supertypeDescriptor.getType());
        Type outputT = ((ParameterizedType)extractorT.getType()).getActualTypeArguments()[1];
        return TypeDescriptor.of(outputT);
    }

    public static <InputT, OutputT> @UnknownKeyFor @NonNull @Initialized TypeDescriptor<InputT> inputOf(@UnknownKeyFor @NonNull @Initialized ProcessFunction<InputT, OutputT> fn) {
        return TypeDescriptors.extractFromTypeParameters(fn, ProcessFunction.class, new TypeVariableExtractor<ProcessFunction<InputT, OutputT>, InputT>(){});
    }

    public static <InputT, OutputT> @UnknownKeyFor @NonNull @Initialized TypeDescriptor<InputT> inputOf(@UnknownKeyFor @NonNull @Initialized SerializableFunction<InputT, OutputT> fn) {
        return TypeDescriptors.inputOf(fn);
    }

    public static <InputT, OutputT> @UnknownKeyFor @NonNull @Initialized TypeDescriptor<OutputT> outputOf(@UnknownKeyFor @NonNull @Initialized ProcessFunction<InputT, OutputT> fn) {
        return TypeDescriptors.extractFromTypeParameters(fn, ProcessFunction.class, new TypeVariableExtractor<ProcessFunction<InputT, OutputT>, OutputT>(){});
    }

    public static <InputT, OutputT> @UnknownKeyFor @NonNull @Initialized TypeDescriptor<OutputT> outputOf(@UnknownKeyFor @NonNull @Initialized SerializableFunction<InputT, OutputT> fn) {
        return TypeDescriptors.outputOf(fn);
    }

    public static <InputT, OutputT> @UnknownKeyFor @NonNull @Initialized TypeDescriptor<InputT> inputOf(@UnknownKeyFor @NonNull @Initialized Contextful.Fn<InputT, OutputT> fn) {
        return TypeDescriptors.extractFromTypeParameters(fn, Contextful.Fn.class, new TypeVariableExtractor<Contextful.Fn<InputT, OutputT>, InputT>(){});
    }

    public static <InputT, OutputT> @UnknownKeyFor @NonNull @Initialized TypeDescriptor<OutputT> outputOf(@UnknownKeyFor @NonNull @Initialized Contextful.Fn<InputT, OutputT> fn) {
        return TypeDescriptors.extractFromTypeParameters(fn, Contextful.Fn.class, new TypeVariableExtractor<Contextful.Fn<InputT, OutputT>, OutputT>(){});
    }

    public static interface TypeVariableExtractor<@UnknownKeyFor InputT, @UnknownKeyFor OutputT> {
    }
}

