/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark;

import java.util.UUID;
import org.apache.beam.runners.core.construction.PipelineOptionsTranslation;
import org.apache.beam.runners.fnexecution.provisioning.JobInfo;
import org.apache.beam.runners.jobsubmission.JobInvocation;
import org.apache.beam.runners.jobsubmission.JobInvoker;
import org.apache.beam.runners.jobsubmission.PortablePipelineJarCreator;
import org.apache.beam.runners.jobsubmission.PortablePipelineRunner;
import org.apache.beam.runners.spark.SparkJobServerDriver;
import org.apache.beam.runners.spark.SparkPipelineOptions;
import org.apache.beam.runners.spark.SparkPipelineRunner;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PortablePipelineOptions;
import org.apache.beam.vendor.grpc.v1p54p0.com.google.protobuf.Struct;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Strings;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.util.concurrent.ListeningExecutorService;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkJobInvoker
extends JobInvoker {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(SparkJobInvoker.class);
    private @UnknownKeyFor @NonNull @Initialized SparkJobServerDriver.SparkServerConfiguration configuration;

    public static @UnknownKeyFor @NonNull @Initialized SparkJobInvoker create(@UnknownKeyFor @NonNull @Initialized SparkJobServerDriver.SparkServerConfiguration configuration) {
        return new SparkJobInvoker(configuration);
    }

    private SparkJobInvoker(@UnknownKeyFor @NonNull @Initialized SparkJobServerDriver.SparkServerConfiguration configuration) {
        super("spark-runner-job-invoker-%d");
        this.configuration = configuration;
    }

    protected @UnknownKeyFor @NonNull @Initialized JobInvocation invokeWithExecutor(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Pipeline pipeline, @UnknownKeyFor @NonNull @Initialized Struct options, @Nullable @UnknownKeyFor @Initialized String retrievalToken, @UnknownKeyFor @NonNull @Initialized ListeningExecutorService executorService) {
        LOG.trace("Parsing pipeline options");
        SparkPipelineOptions sparkOptions = (SparkPipelineOptions)PipelineOptionsTranslation.fromProto((Struct)options).as(SparkPipelineOptions.class);
        String invocationId = String.format("%s_%s", sparkOptions.getJobName(), UUID.randomUUID().toString());
        LOG.info("Invoking job {}", (Object)invocationId);
        if (sparkOptions.getSparkMaster().equals("local[4]")) {
            sparkOptions.setSparkMaster(this.configuration.getSparkMasterUrl());
        }
        sparkOptions.setRunner(null);
        if (sparkOptions.getAppName() == null) {
            LOG.debug("App name was null. Using invocationId {}", (Object)invocationId);
            sparkOptions.setAppName(invocationId);
        }
        return SparkJobInvoker.createJobInvocation(invocationId, retrievalToken, executorService, pipeline, sparkOptions);
    }

    static @UnknownKeyFor @NonNull @Initialized JobInvocation createJobInvocation(@UnknownKeyFor @NonNull @Initialized String invocationId, @UnknownKeyFor @NonNull @Initialized String retrievalToken, @UnknownKeyFor @NonNull @Initialized ListeningExecutorService executorService, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Pipeline pipeline, @UnknownKeyFor @NonNull @Initialized SparkPipelineOptions sparkOptions) {
        JobInfo jobInfo = JobInfo.create((String)invocationId, (String)sparkOptions.getJobName(), (String)retrievalToken, (Struct)PipelineOptionsTranslation.toProto((PipelineOptions)sparkOptions));
        SparkPipelineRunner pipelineRunner = Strings.isNullOrEmpty((String)((PortablePipelineOptions)sparkOptions.as(PortablePipelineOptions.class)).getOutputExecutablePath()) ? new SparkPipelineRunner(sparkOptions) : new PortablePipelineJarCreator(SparkPipelineRunner.class);
        return new JobInvocation(jobInfo, executorService, pipeline, (PortablePipelineRunner)pipelineRunner);
    }
}

