/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.querybuilder.schema;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.querybuilder.schema.CreateAggregateEnd;
import com.datastax.oss.driver.api.querybuilder.schema.CreateAggregateStart;
import com.datastax.oss.driver.api.querybuilder.schema.CreateAggregateStateFunc;
import com.datastax.oss.driver.api.querybuilder.term.Term;
import com.datastax.oss.driver.internal.querybuilder.CqlHelper;
import com.datastax.oss.driver.internal.querybuilder.ImmutableCollections;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import net.jcip.annotations.Immutable;

@Immutable
public class DefaultCreateAggregate
implements CreateAggregateStart,
CreateAggregateStateFunc,
CreateAggregateEnd {
    private final CqlIdentifier keyspace;
    private final CqlIdentifier functionName;
    private boolean orReplace;
    private boolean ifNotExists;
    private final ImmutableList<DataType> parameters;
    private final CqlIdentifier sFunc;
    private final DataType sType;
    private final CqlIdentifier finalFunc;
    private final Term term;

    public DefaultCreateAggregate(@NonNull CqlIdentifier functionName) {
        this(null, functionName);
    }

    public DefaultCreateAggregate(@Nullable CqlIdentifier keyspace, @NonNull CqlIdentifier functionName) {
        this(keyspace, functionName, false, false, (ImmutableList<DataType>)ImmutableList.of(), null, null, null, null);
    }

    public DefaultCreateAggregate(@Nullable CqlIdentifier keyspace, @NonNull CqlIdentifier functionName, boolean orReplace, boolean ifNotExists, @NonNull ImmutableList<DataType> parameters, @Nullable CqlIdentifier sFunc, @Nullable DataType sType, @Nullable CqlIdentifier finalFunc, @Nullable Term term) {
        this.keyspace = keyspace;
        this.functionName = functionName;
        this.orReplace = orReplace;
        this.ifNotExists = ifNotExists;
        this.parameters = parameters;
        this.sFunc = sFunc;
        this.sType = sType;
        this.finalFunc = finalFunc;
        this.term = term;
    }

    @Override
    @NonNull
    public String asCql() {
        StringBuilder builder = new StringBuilder();
        builder.append("CREATE ");
        if (this.orReplace) {
            builder.append("OR REPLACE ");
        }
        builder.append("AGGREGATE ");
        if (this.ifNotExists) {
            builder.append("IF NOT EXISTS ");
        }
        CqlHelper.qualify(this.keyspace, this.functionName, builder);
        builder.append(" (");
        boolean first = true;
        for (DataType param : this.parameters) {
            if (first) {
                first = false;
            } else {
                builder.append(',');
            }
            builder.append(param.asCql(false, true));
        }
        builder.append(')');
        if (this.sFunc != null) {
            builder.append(" SFUNC ");
            builder.append(this.sFunc.asCql(true));
        }
        if (this.sType != null) {
            builder.append(" STYPE ");
            builder.append(this.sType.asCql(false, true));
        }
        if (this.finalFunc != null) {
            builder.append(" FINALFUNC ");
            builder.append(this.finalFunc.asCql(true));
        }
        if (this.term != null) {
            builder.append(" INITCOND ");
            this.term.appendTo(builder);
        }
        return builder.toString();
    }

    @Override
    @NonNull
    public CreateAggregateEnd withInitCond(@NonNull Term term) {
        return new DefaultCreateAggregate(this.keyspace, this.functionName, this.orReplace, this.ifNotExists, this.parameters, this.sFunc, this.sType, this.finalFunc, term);
    }

    @Override
    @NonNull
    public CreateAggregateStart ifNotExists() {
        return new DefaultCreateAggregate(this.keyspace, this.functionName, this.orReplace, true, this.parameters, this.sFunc, this.sType, this.finalFunc, this.term);
    }

    @Override
    @NonNull
    public CreateAggregateStart orReplace() {
        return new DefaultCreateAggregate(this.keyspace, this.functionName, true, this.ifNotExists, this.parameters, this.sFunc, this.sType, this.finalFunc, this.term);
    }

    @Override
    @NonNull
    public CreateAggregateStart withParameter(@NonNull DataType paramType) {
        return new DefaultCreateAggregate(this.keyspace, this.functionName, this.orReplace, this.ifNotExists, ImmutableCollections.append(this.parameters, paramType), this.sFunc, this.sType, this.finalFunc, this.term);
    }

    @Override
    @NonNull
    public CreateAggregateStateFunc withSFunc(@NonNull CqlIdentifier sFunc) {
        return new DefaultCreateAggregate(this.keyspace, this.functionName, this.orReplace, this.ifNotExists, this.parameters, sFunc, this.sType, this.finalFunc, this.term);
    }

    @Override
    @NonNull
    public CreateAggregateEnd withSType(@NonNull DataType sType) {
        return new DefaultCreateAggregate(this.keyspace, this.functionName, this.orReplace, this.ifNotExists, this.parameters, this.sFunc, sType, this.finalFunc, this.term);
    }

    @Override
    @NonNull
    public CreateAggregateEnd withFinalFunc(@NonNull CqlIdentifier finalFunc) {
        return new DefaultCreateAggregate(this.keyspace, this.functionName, this.orReplace, this.ifNotExists, this.parameters, this.sFunc, this.sType, finalFunc, this.term);
    }

    public String toString() {
        return this.asCql();
    }

    @Nullable
    public CqlIdentifier getKeyspace() {
        return this.keyspace;
    }

    @NonNull
    public CqlIdentifier getFunctionName() {
        return this.functionName;
    }

    public boolean isOrReplace() {
        return this.orReplace;
    }

    public boolean isIfNotExists() {
        return this.ifNotExists;
    }

    @NonNull
    public ImmutableList<DataType> getParameters() {
        return this.parameters;
    }

    @Nullable
    public CqlIdentifier getsFunc() {
        return this.sFunc;
    }

    @Nullable
    public DataType getsType() {
        return this.sType;
    }

    @Nullable
    public CqlIdentifier getFinalFunc() {
        return this.finalFunc;
    }

    @Nullable
    public Term getTerm() {
        return this.term;
    }
}

