/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.plugin;

import com.amazon.redshift.plugin.JwtCredentialsProvider;
import java.io.IOException;

public class BasicJwtCredentialsProvider
extends JwtCredentialsProvider {
    private static final String KEY_WEB_IDENTITY_TOKEN = "webIdentityToken";
    private String m_jwt;

    public BasicJwtCredentialsProvider() {
        this.m_disableCache = true;
    }

    private void checkRequiredParameters() throws IOException {
        if (this.isNullOrEmpty(this.m_jwt)) {
            throw new IOException("Missing required property: webIdentityToken");
        }
    }

    @Override
    public String getPluginSpecificCacheKey() {
        return this.m_jwt;
    }

    @Override
    public void addParameter(String key, String value) {
        super.addParameter(key, value);
        if (KEY_WEB_IDENTITY_TOKEN.equalsIgnoreCase(key)) {
            this.m_jwt = value;
        }
    }

    @Override
    protected String getJwtAssertion() throws IOException {
        this.checkRequiredParameters();
        return this.m_jwt;
    }
}

