/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.stream;

import com.clickhouse.client.ClickHouseByteBuffer;
import com.clickhouse.client.ClickHouseDataUpdater;
import com.clickhouse.client.ClickHouseFile;
import com.clickhouse.client.ClickHouseInputStream;
import com.clickhouse.client.ClickHouseOutputStream;
import com.clickhouse.client.ClickHouseUtils;
import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.LinkedList;

public abstract class AbstractByteBufferInputStream
extends ClickHouseInputStream {
    protected ByteBuffer buffer = null;

    protected AbstractByteBufferInputStream(ClickHouseFile file, OutputStream copyTo, Runnable postCloseAction) {
        super(file, copyTo, postCloseAction);
    }

    @Override
    protected void ensureOpen() throws IOException {
        super.ensureOpen();
        if (this.buffer == null || this.buffer != ClickHouseByteBuffer.EMPTY_BUFFER && !this.buffer.hasRemaining()) {
            this.updateBuffer();
        }
    }

    protected abstract int updateBuffer() throws IOException;

    @Override
    public int available() throws IOException {
        if (this.closed || this.buffer == ClickHouseByteBuffer.EMPTY_BUFFER) {
            return 0;
        }
        return this.buffer != null && this.buffer.hasRemaining() ? this.buffer.remaining() : this.updateBuffer();
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.buffer = null;
        super.close();
    }

    @Override
    public int peek() throws IOException {
        this.ensureOpen();
        if (this.buffer == ClickHouseByteBuffer.EMPTY_BUFFER) {
            return -1;
        }
        int b = 0xFF & this.buffer.get();
        ((Buffer)this.buffer).position(this.buffer.position() - 1);
        return b;
    }

    @Override
    public long pipe(ClickHouseOutputStream output) throws IOException {
        long count = 0L;
        if (output == null || output.isClosed()) {
            return count;
        }
        this.ensureOpen();
        ByteBuffer b = this.buffer;
        int remain = b.remaining();
        while (b != ClickHouseByteBuffer.EMPTY_BUFFER) {
            if (remain > 0) {
                if (b.hasArray()) {
                    output.transferBytes(b.array(), b.position(), remain);
                    ((Buffer)b).limit(b.position());
                } else {
                    byte[] bytes = new byte[remain];
                    this.buffer.get(bytes);
                    output.transferBytes(bytes, 0, remain);
                }
                count += (long)remain;
            }
            remain = this.updateBuffer();
            b = this.buffer;
        }
        this.close();
        return count;
    }

    @Override
    public int read() throws IOException {
        this.ensureOpen();
        return this.buffer == ClickHouseByteBuffer.EMPTY_BUFFER ? -1 : 0xFF & this.buffer.get();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException("Non-null byte array is required");
        }
        if (this.buffer != null && this.buffer.hasArray() && this.buffer.array() == b) {
            throw new IllegalArgumentException("Please pass a different byte array instead of the same internal buffer for reading");
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        this.ensureOpen();
        int offset = off;
        while (len > 0) {
            if (this.buffer == ClickHouseByteBuffer.EMPTY_BUFFER) {
                return off > offset ? off - offset : -1;
            }
            int remain = this.buffer.remaining();
            if (remain >= len) {
                this.buffer.get(b, off, len);
                off += len;
                break;
            }
            this.buffer.get(b, off, remain);
            off += remain;
            len -= remain;
            this.updateBuffer();
        }
        return off - offset;
    }

    @Override
    public ClickHouseByteBuffer readBuffer(int length) throws IOException {
        if (length < 1) {
            return this.byteBuffer.reset();
        }
        this.ensureOpen();
        if (this.buffer == ClickHouseByteBuffer.EMPTY_BUFFER) {
            this.closeQuietly();
            throw new EOFException();
        }
        if (this.buffer.remaining() >= length && this.buffer.hasArray()) {
            int position = this.buffer.position();
            this.byteBuffer.update(this.buffer.array(), position, length);
            ((Buffer)this.buffer).position(position + length);
        } else {
            this.byteBuffer.update(this.readBytes(length));
        }
        return this.byteBuffer;
    }

    @Override
    public ClickHouseByteBuffer readCustom(ClickHouseDataUpdater reader) throws IOException {
        if (reader == null) {
            return this.byteBuffer.reset();
        }
        this.ensureOpen();
        LinkedList<byte[]> list = new LinkedList<byte[]>();
        int offset = 0;
        int length = 0;
        boolean more = true;
        while (more) {
            int read;
            byte[] bytes;
            int limit;
            int position;
            int remain = this.buffer.remaining();
            if (remain < 1) {
                this.closeQuietly();
                more = false;
                continue;
            }
            int startPos = position = this.buffer.position();
            int endPos = limit = this.buffer.limit();
            if (this.buffer.hasArray() && this.buffer.capacity() == this.buffer.limit()) {
                bytes = this.buffer.array();
                if (bytes.length > remain) {
                    byte[] newBytes = new byte[remain];
                    System.arraycopy(bytes, position, newBytes, 0, remain);
                    bytes = newBytes;
                    startPos = 0;
                    endPos = remain;
                }
            } else {
                bytes = new byte[remain];
                this.buffer.get(bytes);
                ((Buffer)this.buffer).position(position);
                startPos = 0;
                endPos = remain;
            }
            if ((read = reader.update(bytes, startPos, endPos)) == -1) {
                length += remain;
                ((Buffer)this.buffer).position(limit);
                if (this.updateBuffer() < 1) {
                    this.closeQuietly();
                    more = false;
                }
            } else {
                if (read > 0) {
                    length += read;
                    ((Buffer)this.buffer).position(position + read);
                }
                more = false;
            }
            list.add(bytes);
        }
        return this.byteBuffer.update(list, offset, length);
    }

    @Override
    public byte readByte() throws IOException {
        this.ensureOpen();
        if (this.buffer == ClickHouseByteBuffer.EMPTY_BUFFER) {
            this.closeQuietly();
            throw new EOFException();
        }
        return this.buffer.get();
    }

    @Override
    public byte[] readBytes(int length) throws IOException {
        if (length < 1) {
            return ClickHouseByteBuffer.EMPTY_BYTES;
        }
        this.ensureOpen();
        byte[] bytes = new byte[length];
        int offset = 0;
        ByteBuffer b = this.buffer;
        int remain = b.remaining();
        while (length > 0) {
            if (b == ClickHouseByteBuffer.EMPTY_BUFFER) {
                this.closeQuietly();
                throw offset == 0 ? new EOFException() : new IOException(ClickHouseUtils.format("Reached end of input stream after reading %d of %d bytes", offset, bytes.length));
            }
            if (remain >= length) {
                b.get(bytes, offset, length);
                offset += length;
                length = 0;
                continue;
            }
            b.get(bytes, offset, remain);
            offset += remain;
            length -= remain;
            remain = this.updateBuffer();
            b = this.buffer;
        }
        return bytes;
    }

    @Override
    public long skip(long n) throws IOException {
        this.ensureOpen();
        if (n == Long.MAX_VALUE) {
            long counter = this.buffer.remaining();
            while (this.buffer != ClickHouseByteBuffer.EMPTY_BUFFER) {
                counter += (long)this.updateBuffer();
            }
            return counter;
        }
        return super.skip(n);
    }
}

