/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws.sns;

import com.amazonaws.regions.Regions;
import com.amazonaws.services.sns.AmazonSNS;
import com.amazonaws.services.sns.model.GetTopicAttributesResult;
import com.amazonaws.services.sns.model.InternalErrorException;
import com.amazonaws.services.sns.model.PublishRequest;
import com.amazonaws.services.sns.model.PublishResult;
import com.google.auto.value.AutoValue;
import java.io.IOException;
import java.io.Serializable;
import java.util.function.Predicate;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.io.aws.sns.AutoValue_SnsIO_RetryConfiguration;
import org.apache.beam.sdk.io.aws.sns.AutoValue_SnsIO_Write;
import org.apache.beam.sdk.io.aws.sns.AwsClientsProvider;
import org.apache.beam.sdk.io.aws.sns.BasicSnsProvider;
import org.apache.beam.sdk.io.aws.sns.PublishResultCoders;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.Metrics;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.util.BackOff;
import org.apache.beam.sdk.util.BackOffUtils;
import org.apache.beam.sdk.util.FluentBackoff;
import org.apache.beam.sdk.util.Sleeper;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TupleTagList;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableSet;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public final class SnsIO {
    public static @UnknownKeyFor @NonNull @Initialized Write write() {
        return new AutoValue_SnsIO_Write.Builder().build();
    }

    @AutoValue
    @AutoValue.CopyAnnotations
    public static abstract class Write
    extends PTransform<PCollection<PublishRequest>, PCollectionTuple> {
        abstract @Nullable @UnknownKeyFor @Initialized String getTopicName();

        abstract @Nullable @UnknownKeyFor @Initialized AwsClientsProvider getAWSClientsProvider();

        abstract @Nullable @UnknownKeyFor @Initialized RetryConfiguration getRetryConfiguration();

        abstract @Nullable @UnknownKeyFor @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized PublishResult> getResultOutputTag();

        abstract @Nullable @UnknownKeyFor @Initialized Coder<@UnknownKeyFor @NonNull @Initialized PublishResult> getCoder();

        abstract @UnknownKeyFor @NonNull @Initialized Builder builder();

        public @UnknownKeyFor @NonNull @Initialized Write withTopicName(@UnknownKeyFor @NonNull @Initialized String topicName) {
            return this.builder().setTopicName(topicName).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write withAWSClientsProvider(@UnknownKeyFor @NonNull @Initialized AwsClientsProvider awsClientsProvider) {
            return this.builder().setAWSClientsProvider(awsClientsProvider).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write withAWSClientsProvider(@UnknownKeyFor @NonNull @Initialized String awsAccessKey, @UnknownKeyFor @NonNull @Initialized String awsSecretKey, @UnknownKeyFor @NonNull @Initialized Regions region) {
            return this.withAWSClientsProvider(awsAccessKey, awsSecretKey, region, null);
        }

        public @UnknownKeyFor @NonNull @Initialized Write withAWSClientsProvider(@UnknownKeyFor @NonNull @Initialized String awsAccessKey, @UnknownKeyFor @NonNull @Initialized String awsSecretKey, @UnknownKeyFor @NonNull @Initialized Regions region, @UnknownKeyFor @NonNull @Initialized String serviceEndpoint) {
            return this.withAWSClientsProvider(new BasicSnsProvider(awsAccessKey, awsSecretKey, region, serviceEndpoint));
        }

        public @UnknownKeyFor @NonNull @Initialized Write withRetryConfiguration(@UnknownKeyFor @NonNull @Initialized RetryConfiguration retryConfiguration) {
            Preconditions.checkArgument((retryConfiguration != null ? 1 : 0) != 0, (Object)"retryConfiguration is required");
            return this.builder().setRetryConfiguration(retryConfiguration).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write withResultOutputTag(@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized PublishResult> results) {
            return this.builder().setResultOutputTag(results).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write withFullPublishResult() {
            return this.withCoder(PublishResultCoders.fullPublishResult());
        }

        public @UnknownKeyFor @NonNull @Initialized Write withFullPublishResultWithoutHeaders() {
            return this.withCoder(PublishResultCoders.fullPublishResultWithoutHeaders());
        }

        public @UnknownKeyFor @NonNull @Initialized Write withCoder(@UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized PublishResult> coder) {
            return this.builder().setCoder(coder).build();
        }

        public @UnknownKeyFor @NonNull @Initialized PCollectionTuple expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized PublishRequest> input) {
            LoggerFactory.getLogger(SnsIO.class).warn("You are using a deprecated IO for Sns. Please migrate to module 'org.apache.beam:beam-sdks-java-io-amazon-web-services2'.");
            Preconditions.checkArgument((this.getTopicName() != null ? 1 : 0) != 0, (Object)"withTopicName() is required");
            PCollectionTuple result = (PCollectionTuple)input.apply((PTransform)ParDo.of((DoFn)new SnsWriterFn(this)).withOutputTags(this.getResultOutputTag(), TupleTagList.empty()));
            if (this.getCoder() != null) {
                result.get(this.getResultOutputTag()).setCoder(this.getCoder());
            }
            return result;
        }

        static class SnsWriterFn
        extends DoFn<PublishRequest, PublishResult> {
            @VisibleForTesting
            static final @UnknownKeyFor @NonNull @Initialized String RETRY_ATTEMPT_LOG = "Error writing to SNS. Retry attempt[{}]";
            private transient @UnknownKeyFor @NonNull @Initialized FluentBackoff retryBackoff;
            private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(SnsWriterFn.class);
            private static final @UnknownKeyFor @NonNull @Initialized Counter SNS_WRITE_FAILURES = Metrics.counter(SnsWriterFn.class, (String)"SNS_Write_Failures");
            private final @UnknownKeyFor @NonNull @Initialized Write spec;
            private transient @UnknownKeyFor @NonNull @Initialized AmazonSNS producer;

            SnsWriterFn(@UnknownKeyFor @NonNull @Initialized Write spec) {
                this.spec = spec;
            }

            @DoFn.Setup
            public void setup() throws @UnknownKeyFor @NonNull @Initialized Exception {
                this.producer = this.spec.getAWSClientsProvider().createSnsPublisher();
                Preconditions.checkArgument((boolean)SnsWriterFn.topicExists(this.producer, this.spec.getTopicName()), (String)"Topic %s does not exist", (Object)this.spec.getTopicName());
                this.retryBackoff = FluentBackoff.DEFAULT.withMaxRetries(0);
                if (this.spec.getRetryConfiguration() != null) {
                    this.retryBackoff = this.retryBackoff.withMaxRetries(this.spec.getRetryConfiguration().getMaxAttempts() - 1).withInitialBackoff(this.spec.getRetryConfiguration().getInitialDuration()).withMaxCumulativeBackoff(this.spec.getRetryConfiguration().getMaxDuration());
                }
            }

            @DoFn.ProcessElement
            public void processElement(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext context) throws @UnknownKeyFor @NonNull @Initialized Exception {
                PublishRequest request = (PublishRequest)context.element();
                Sleeper sleeper = Sleeper.DEFAULT;
                BackOff backoff = this.retryBackoff.backoff();
                int attempt = 0;
                while (true) {
                    ++attempt;
                    try {
                        PublishResult pr = this.producer.publish(request);
                        context.output((Object)pr);
                    }
                    catch (Exception ex) {
                        if (this.spec.getRetryConfiguration() == null || !this.spec.getRetryConfiguration().getRetryPredicate().test(ex)) {
                            SNS_WRITE_FAILURES.inc();
                            LOG.info("Unable to publish message {}.", (Object)request.getMessage(), (Object)ex);
                            throw new IOException("Error writing to SNS (no attempt made to retry)", ex);
                        }
                        if (!BackOffUtils.next((Sleeper)sleeper, (BackOff)backoff)) {
                            throw new IOException(String.format("Error writing to SNS after %d attempt(s). No more attempts allowed", attempt), ex);
                        }
                        LOG.warn(RETRY_ATTEMPT_LOG, (Object)attempt, (Object)ex);
                        continue;
                    }
                    break;
                }
            }

            @DoFn.Teardown
            public void tearDown() {
                if (this.producer != null) {
                    this.producer.shutdown();
                    this.producer = null;
                }
            }

            private static @UnknownKeyFor @NonNull @Initialized boolean topicExists(@UnknownKeyFor @NonNull @Initialized AmazonSNS client, @UnknownKeyFor @NonNull @Initialized String topicName) {
                try {
                    GetTopicAttributesResult topicAttributesResult = client.getTopicAttributes(topicName);
                    return topicAttributesResult != null && topicAttributesResult.getSdkHttpMetadata().getHttpStatusCode() == 200;
                }
                catch (Exception e) {
                    LOG.warn("Error checking whether topic {} exists.", (Object)topicName, (Object)e);
                    throw e;
                }
            }
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract @UnknownKeyFor @NonNull @Initialized Builder setTopicName(@UnknownKeyFor @NonNull @Initialized String var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setAWSClientsProvider(@UnknownKeyFor @NonNull @Initialized AwsClientsProvider var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setRetryConfiguration(@UnknownKeyFor @NonNull @Initialized RetryConfiguration var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setResultOutputTag(@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized PublishResult> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setCoder(@UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized PublishResult> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Write build();
        }
    }

    @AutoValue
    @AutoValue.CopyAnnotations
    public static abstract class RetryConfiguration
    implements Serializable {
        private static final @UnknownKeyFor @NonNull @Initialized Duration DEFAULT_INITIAL_DURATION = Duration.standardSeconds((long)5L);
        @VisibleForTesting
        static final @UnknownKeyFor @NonNull @Initialized RetryPredicate DEFAULT_RETRY_PREDICATE = new DefaultRetryPredicate();

        abstract @UnknownKeyFor @NonNull @Initialized int getMaxAttempts();

        abstract @UnknownKeyFor @NonNull @Initialized Duration getMaxDuration();

        abstract @UnknownKeyFor @NonNull @Initialized Duration getInitialDuration();

        abstract @UnknownKeyFor @NonNull @Initialized RetryPredicate getRetryPredicate();

        abstract @UnknownKeyFor @NonNull @Initialized Builder builder();

        public static @UnknownKeyFor @NonNull @Initialized RetryConfiguration create(@UnknownKeyFor @NonNull @Initialized int maxAttempts, @UnknownKeyFor @NonNull @Initialized Duration maxDuration) {
            return RetryConfiguration.create(maxAttempts, maxDuration, DEFAULT_INITIAL_DURATION);
        }

        @VisibleForTesting
        static @UnknownKeyFor @NonNull @Initialized RetryConfiguration create(@UnknownKeyFor @NonNull @Initialized int maxAttempts, @UnknownKeyFor @NonNull @Initialized Duration maxDuration, @UnknownKeyFor @NonNull @Initialized Duration initialDuration) {
            Preconditions.checkArgument((maxAttempts > 0 ? 1 : 0) != 0, (Object)"maxAttempts should be greater than 0");
            Preconditions.checkArgument((maxDuration != null && maxDuration.isLongerThan((ReadableDuration)Duration.ZERO) ? 1 : 0) != 0, (Object)"maxDuration should be greater than 0");
            Preconditions.checkArgument((initialDuration != null && initialDuration.isLongerThan((ReadableDuration)Duration.ZERO) ? 1 : 0) != 0, (Object)"initialDuration should be greater than 0");
            return new AutoValue_SnsIO_RetryConfiguration.Builder().setMaxAttempts(maxAttempts).setMaxDuration(maxDuration).setInitialDuration(initialDuration).setRetryPredicate(DEFAULT_RETRY_PREDICATE).build();
        }

        private static class DefaultRetryPredicate
        implements RetryPredicate {
            private static final @UnknownKeyFor @NonNull @Initialized ImmutableSet<@UnknownKeyFor @NonNull @Initialized Integer> ELIGIBLE_CODES = ImmutableSet.of((Object)503);

            private DefaultRetryPredicate() {
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized boolean test(@UnknownKeyFor @NonNull @Initialized Throwable throwable) {
                return throwable instanceof IOException || throwable instanceof InternalErrorException || throwable instanceof InternalErrorException && ELIGIBLE_CODES.contains((Object)((InternalErrorException)throwable).getStatusCode());
            }
        }

        @FunctionalInterface
        static interface RetryPredicate
        extends Predicate<Throwable>,
        Serializable {
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract @UnknownKeyFor @NonNull @Initialized Builder setMaxAttempts(@UnknownKeyFor @NonNull @Initialized int var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setMaxDuration(@UnknownKeyFor @NonNull @Initialized Duration var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setInitialDuration(@UnknownKeyFor @NonNull @Initialized Duration var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setRetryPredicate(@UnknownKeyFor @NonNull @Initialized RetryPredicate var1);

            abstract @UnknownKeyFor @NonNull @Initialized RetryConfiguration build();
        }
    }
}

