/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.hash;

import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.RowMeta;

public class ByteArrayHashIndex {
    private static final int STANDARD_INDEX_SIZE = 512;
    private static final float STANDARD_LOAD_FACTOR = 0.78f;
    private IRowMeta keyRowMeta;
    private ByteArrayHashIndexEntry[] index;
    private int size;
    private int resizeThresHold;

    public ByteArrayHashIndex(IRowMeta keyRowMeta, int size) {
        int factor2Size;
        this.keyRowMeta = keyRowMeta;
        for (factor2Size = 1; factor2Size < size; factor2Size <<= 1) {
        }
        this.size = factor2Size;
        this.resizeThresHold = (int)((float)factor2Size * 0.78f);
        this.index = new ByteArrayHashIndexEntry[factor2Size];
    }

    public ByteArrayHashIndex(IRowMeta keyRowMeta) {
        this(keyRowMeta, 512);
    }

    public int getSize() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public byte[] get(byte[] key) throws HopValueException {
        int hashCode = ByteArrayHashIndex.generateHashCode(key, this.keyRowMeta);
        int indexPointer = hashCode & this.index.length - 1;
        ByteArrayHashIndexEntry check = this.index[indexPointer];
        while (check != null) {
            if (check.hashCode == hashCode && check.equalsKey(key)) {
                return check.value;
            }
            check = check.nextEntry;
        }
        return null;
    }

    public void put(byte[] key, byte[] value) throws HopValueException {
        int hashCode = ByteArrayHashIndex.generateHashCode(key, this.keyRowMeta);
        int indexPointer = hashCode & this.index.length - 1;
        boolean searchEmptySpot = false;
        ByteArrayHashIndexEntry check = this.index[indexPointer];
        ByteArrayHashIndexEntry previousCheck = null;
        while (check != null) {
            searchEmptySpot = true;
            if (check.hashCode == hashCode && check.equalsKey(key)) {
                check.value = value;
                return;
            }
            previousCheck = check;
            check = check.nextEntry;
        }
        while (searchEmptySpot) {
            if (++indexPointer >= this.size) {
                indexPointer = 0;
            }
            if (this.index[indexPointer] != null) continue;
            searchEmptySpot = false;
        }
        this.index[indexPointer] = new ByteArrayHashIndexEntry(hashCode, key, value, this.index[indexPointer]);
        if (previousCheck != null) {
            previousCheck.nextEntry = this.index[indexPointer];
        }
        this.resize();
    }

    private final void resize() {
        ++this.size;
        if (this.size >= this.resizeThresHold) {
            ByteArrayHashIndexEntry[] oldIndex = this.index;
            int newSize = 2 * this.index.length;
            ByteArrayHashIndexEntry[] newIndex = new ByteArrayHashIndexEntry[newSize];
            for (int i = 0; i < oldIndex.length; ++i) {
                ByteArrayHashIndexEntry entry = oldIndex[i];
                if (entry == null) continue;
                oldIndex[i] = null;
                entry.nextEntry = null;
                int newIndexPointer = entry.hashCode & newSize - 1;
                ByteArrayHashIndexEntry check = newIndex[newIndexPointer];
                if (check == null) {
                    newIndex[newIndexPointer] = check;
                } else {
                    ByteArrayHashIndexEntry previousCheck = null;
                    while (check != null) {
                        previousCheck = check;
                        check = check.nextEntry;
                    }
                    while (newIndex[newIndexPointer] != null) {
                        if (++newIndexPointer < newSize) continue;
                        newIndexPointer = 0;
                    }
                    previousCheck.nextEntry = entry;
                    newIndex[newIndexPointer] = entry;
                }
                newIndex[newIndexPointer] = entry;
            }
            this.index = newIndex;
            this.resizeThresHold = (int)((float)newSize * 0.78f);
        }
    }

    public static int generateHashCode(byte[] key, IRowMeta rowMeta) throws HopValueException {
        Object[] rowData = RowMeta.getRow(rowMeta, key);
        return rowMeta.hashCode(rowData);
    }

    private static final class ByteArrayHashIndexEntry {
        private int hashCode;
        private byte[] key;
        private byte[] value;
        private ByteArrayHashIndexEntry nextEntry;

        public ByteArrayHashIndexEntry(int hashCode, byte[] key, byte[] value, ByteArrayHashIndexEntry nextEntry) {
            this.hashCode = hashCode;
            this.key = key;
            this.value = value;
            this.nextEntry = nextEntry;
        }

        public boolean equalsKey(byte[] cmpKey) {
            return ByteArrayHashIndexEntry.equalsByteArray(this.key, cmpKey);
        }

        public boolean equals(Object obj) {
            ByteArrayHashIndexEntry e = (ByteArrayHashIndexEntry)obj;
            return this.equalsValue(e.value);
        }

        public boolean equalsValue(byte[] cmpValue) {
            return ByteArrayHashIndexEntry.equalsByteArray(this.value, cmpValue);
        }

        public static final boolean equalsByteArray(byte[] value, byte[] cmpValue) {
            if (value.length != cmpValue.length) {
                return false;
            }
            for (int i = value.length - 1; i >= 0; --i) {
                if (value[i] == cmpValue[i]) continue;
                return false;
            }
            return true;
        }
    }
}

