/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.laf;

import java.util.HashSet;
import java.util.Iterator;
import org.apache.hop.laf.IHandler;
import org.apache.hop.laf.ILafChangeListener;

public class LafDelegate<E extends IHandler> {
    E handler;
    Class<E> handlerClass = null;
    Class<E> defaultHandlerClass = null;
    private HashSet<ILafChangeListener<E>> registry = new HashSet();

    public LafDelegate(Class<E> handler, Class<E> defaultHandler) {
        this.handlerClass = handler;
        this.defaultHandlerClass = defaultHandler;
        this.init();
    }

    private void init() {
        this.handler = this.handler != null ? this.loadHandler(this.handlerClass) : this.loadHandler(this.defaultHandlerClass);
    }

    public E newHandlerInstance(String classname) throws ClassNotFoundException {
        E h = null;
        Class<?> c = null;
        c = Class.forName(classname);
        h = (E)this.loadHandler(c);
        return h;
    }

    private E loadHandler(Class<E> c) {
        IHandler h = null;
        try {
            if (this.handlerClass.isAssignableFrom(c)) {
                h = (IHandler)c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (h != null) {
            this.changeHandler(h);
        }
        return (E)h;
    }

    public E registerChangeListener(ILafChangeListener<E> listener) {
        this.registry.add(listener);
        return this.handler;
    }

    public void unregisterChangeListener(ILafChangeListener<E> listener) {
        this.registry.remove(listener);
    }

    public HashSet<ILafChangeListener<E>> getListeners() {
        return this.registry;
    }

    public void loadListeners(HashSet<ILafChangeListener<E>> listeners) {
        this.registry = listeners;
    }

    public void changeHandler(E handler) {
        this.handler = handler;
        this.notifyListeners();
    }

    protected void notifyListeners() {
        Iterator<ILafChangeListener<E>> iterator = this.registry.iterator();
        while (iterator.hasNext()) {
            iterator.next().notify(this.handler);
        }
    }

    public E getHandler() {
        return this.handler;
    }
}

