/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.tableinput;

import java.util.List;
import org.apache.hop.core.Const;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.PipelinePreviewFactory;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformDialog;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.tableinput.TableInputMeta;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.database.dialog.DatabaseExplorerDialog;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.EnterNumberDialog;
import org.apache.hop.ui.core.dialog.EnterTextDialog;
import org.apache.hop.ui.core.dialog.MessageBox;
import org.apache.hop.ui.core.dialog.PreviewRowsDialog;
import org.apache.hop.ui.core.widget.MetaSelectionLine;
import org.apache.hop.ui.core.widget.StyledTextComp;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.dialog.PipelinePreviewProgressDialog;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class TableInputDialog
extends BaseTransformDialog
implements ITransformDialog {
    private static final Class<?> PKG = TableInputMeta.class;
    private MetaSelectionLine<DatabaseMeta> wConnection;
    private StyledTextComp wSql;
    private CCombo wDataFrom;
    private TextVar wLimit;
    private Label wlEachRow;
    private Button wEachRow;
    private Button wVariables;
    private final TableInputMeta input;
    private Label wlPosition;

    public TableInputDialog(Shell parent, IVariables variables, Object in, PipelineMeta pipelineMeta, String sname) {
        super(parent, variables, (BaseTransformMeta)in, pipelineMeta, sname);
        this.input = (TableInputMeta)((Object)in);
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        ModifyListener lsMod = e -> this.input.setChanged();
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"TableInputDialog.TableInput", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        TableInputDialog tableInputDialog = this;
        int margin = tableInputDialog.props.getMargin();
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"TableInputDialog.TransformName", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        PropsUi.setLook((Widget)this.wTransformName);
        this.wTransformName.addModifyListener(lsMod);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment(0, margin);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        this.wConnection = this.addConnectionLine((Composite)this.shell, (Control)this.wTransformName, this.input.getConnection(), lsMod);
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wPreview = new Button((Composite)this.shell, 8);
        this.wPreview.setText(BaseMessages.getString(PKG, (String)"System.Button.Preview", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOk, this.wPreview, this.wCancel}, margin, null);
        Label wlLimit = new Label((Composite)this.shell, 131072);
        wlLimit.setText(BaseMessages.getString(PKG, (String)"TableInputDialog.LimitSize", (String[])new String[0]));
        PropsUi.setLook((Widget)wlLimit);
        FormData fdlLimit = new FormData();
        fdlLimit.left = new FormAttachment(0, 0);
        fdlLimit.right = new FormAttachment(middle, -margin);
        fdlLimit.bottom = new FormAttachment((Control)this.wOk, -2 * margin);
        wlLimit.setLayoutData((Object)fdlLimit);
        this.wLimit = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wLimit);
        this.wLimit.addModifyListener(lsMod);
        FormData fdLimit = new FormData();
        fdLimit.left = new FormAttachment(middle, 0);
        fdLimit.right = new FormAttachment(100, 0);
        fdLimit.bottom = new FormAttachment((Control)wlLimit, 0, 0x1000000);
        this.wLimit.setLayoutData((Object)fdLimit);
        this.wlEachRow = new Label((Composite)this.shell, 131072);
        this.wlEachRow.setText(BaseMessages.getString(PKG, (String)"TableInputDialog.ExecuteForEachRow", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlEachRow);
        FormData fdlEachRow = new FormData();
        fdlEachRow.left = new FormAttachment(0, 0);
        fdlEachRow.right = new FormAttachment(middle, -margin);
        fdlEachRow.bottom = new FormAttachment((Control)wlLimit, -margin);
        this.wlEachRow.setLayoutData((Object)fdlEachRow);
        this.wEachRow = new Button((Composite)this.shell, 32);
        PropsUi.setLook((Widget)this.wEachRow);
        FormData fdEachRow = new FormData();
        fdEachRow.left = new FormAttachment(middle, 0);
        fdEachRow.right = new FormAttachment(100, 0);
        fdEachRow.bottom = new FormAttachment((Control)this.wlEachRow, 0, 0x1000000);
        this.wEachRow.setLayoutData((Object)fdEachRow);
        SelectionAdapter lsSelMod = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                TableInputDialog.this.input.setChanged();
            }
        };
        this.wEachRow.addSelectionListener((SelectionListener)lsSelMod);
        Label wlDatefrom = new Label((Composite)this.shell, 131072);
        wlDatefrom.setText(BaseMessages.getString(PKG, (String)"TableInputDialog.InsertDataFromTransform", (String[])new String[0]));
        PropsUi.setLook((Widget)wlDatefrom);
        FormData fdlDatefrom = new FormData();
        fdlDatefrom.left = new FormAttachment(0, 0);
        fdlDatefrom.right = new FormAttachment(middle, -margin);
        fdlDatefrom.bottom = new FormAttachment((Control)this.wlEachRow, -margin);
        wlDatefrom.setLayoutData((Object)fdlDatefrom);
        this.wDataFrom = new CCombo((Composite)this.shell, 2048);
        PropsUi.setLook((Widget)this.wDataFrom);
        List previousTransforms = this.pipelineMeta.findPreviousTransforms(this.pipelineMeta.findTransform(this.transformName));
        for (TransformMeta transformMeta : previousTransforms) {
            this.wDataFrom.add(transformMeta.getName());
        }
        this.wDataFrom.addModifyListener(lsMod);
        FormData fdDatefrom = new FormData();
        fdDatefrom.left = new FormAttachment(middle, 0);
        fdDatefrom.right = new FormAttachment(100, 0);
        fdDatefrom.bottom = new FormAttachment((Control)wlDatefrom, 0, 0x1000000);
        this.wDataFrom.setLayoutData((Object)fdDatefrom);
        Label wlVariables = new Label((Composite)this.shell, 131072);
        wlVariables.setText(BaseMessages.getString(PKG, (String)"TableInputDialog.ReplaceVariables", (String[])new String[0]));
        PropsUi.setLook((Widget)wlVariables);
        FormData fdlVariables = new FormData();
        fdlVariables.left = new FormAttachment(0, 0);
        fdlVariables.right = new FormAttachment(middle, -margin);
        fdlVariables.bottom = new FormAttachment((Control)wlDatefrom, -margin);
        wlVariables.setLayoutData((Object)fdlVariables);
        this.wVariables = new Button((Composite)this.shell, 32);
        PropsUi.setLook((Widget)this.wVariables);
        FormData fdVariables = new FormData();
        fdVariables.left = new FormAttachment(middle, 0);
        fdVariables.right = new FormAttachment(100, 0);
        fdVariables.bottom = new FormAttachment((Control)wlVariables, 0, 0x1000000);
        this.wVariables.setLayoutData((Object)fdVariables);
        this.wVariables.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                TableInputDialog.this.input.setChanged();
                TableInputDialog.this.setSqlToolTip();
            }
        });
        this.wlPosition = new Label((Composite)this.shell, 0);
        PropsUi.setLook((Widget)this.wlPosition);
        FormData fdlPosition = new FormData();
        fdlPosition.left = new FormAttachment(0, 0);
        fdlPosition.right = new FormAttachment(100, 0);
        fdlPosition.bottom = new FormAttachment((Control)wlVariables, -2 * margin);
        this.wlPosition.setLayoutData((Object)fdlPosition);
        Label wlSql = new Label((Composite)this.shell, 0);
        wlSql.setText(BaseMessages.getString(PKG, (String)"TableInputDialog.SQL", (String[])new String[0]));
        PropsUi.setLook((Widget)wlSql);
        FormData fdlSql = new FormData();
        fdlSql.left = new FormAttachment(0, 0);
        fdlSql.top = new FormAttachment(this.wConnection, margin * 2);
        wlSql.setLayoutData((Object)fdlSql);
        Button wbTable = new Button((Composite)this.shell, 0x1000008);
        PropsUi.setLook((Widget)wbTable);
        wbTable.setText(BaseMessages.getString(PKG, (String)"TableInputDialog.GetSQLAndSelectStatement", (String[])new String[0]));
        FormData fdbTable = new FormData();
        fdbTable.right = new FormAttachment(100, 0);
        fdbTable.top = new FormAttachment(this.wConnection, margin * 2);
        wbTable.setLayoutData((Object)fdbTable);
        this.wSql = new StyledTextComp(this.variables, (Composite)this.shell, 19202);
        PropsUi.setLook((Widget)this.wSql, (int)1);
        this.wSql.addModifyListener(lsMod);
        FormData fdSql = new FormData();
        fdSql.left = new FormAttachment(0, 0);
        fdSql.top = new FormAttachment((Control)wbTable, margin);
        fdSql.right = new FormAttachment(100, -2 * margin);
        fdSql.bottom = new FormAttachment((Control)this.wlPosition, -margin);
        this.wSql.setLayoutData((Object)fdSql);
        this.wSql.addModifyListener(arg0 -> {
            this.setSqlToolTip();
            this.setPosition();
        });
        this.wSql.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                TableInputDialog.this.setPosition();
            }

            public void keyReleased(KeyEvent e) {
                TableInputDialog.this.setPosition();
            }
        });
        this.wSql.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                TableInputDialog.this.setPosition();
            }

            public void focusLost(FocusEvent e) {
                TableInputDialog.this.setPosition();
            }
        });
        this.wSql.addMouseListener(new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                TableInputDialog.this.setPosition();
            }

            public void mouseDown(MouseEvent e) {
                TableInputDialog.this.setPosition();
            }

            public void mouseUp(MouseEvent e) {
                TableInputDialog.this.setPosition();
            }
        });
        this.wCancel.addListener(13, e -> this.cancel());
        this.wPreview.addListener(13, e -> this.preview());
        this.wOk.addListener(13, e -> this.ok());
        wbTable.addListener(13, e -> this.getSql());
        this.wDataFrom.addListener(13, e -> this.setFlags());
        this.wDataFrom.addListener(16, e -> this.setFlags());
        this.getData();
        this.input.setChanged(this.changed);
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    public void setPosition() {
        int lineNumber = this.wSql.getLineNumber();
        int columnNumber = this.wSql.getColumnNumber();
        this.wlPosition.setText(BaseMessages.getString(PKG, (String)"TableInputDialog.Position.Label", (String[])new String[]{"" + lineNumber, "" + columnNumber}));
    }

    protected void setSqlToolTip() {
        if (this.wVariables.getSelection()) {
            this.wSql.setToolTipText(this.variables.resolve(this.wSql.getText()));
        }
    }

    public void getData() {
        if (this.input.getSql() != null) {
            this.wSql.setText(this.input.getSql());
        }
        if (this.input.getConnection() != null) {
            this.wConnection.setText(this.input.getConnection());
        }
        this.wLimit.setText(Const.NVL((String)this.input.getRowLimit(), (String)""));
        this.wDataFrom.setText(Const.NVL((String)this.input.getLookup(), (String)""));
        this.wEachRow.setSelection(this.input.isExecuteEachInputRow());
        this.wVariables.setSelection(this.input.isVariableReplacementActive());
        this.setSqlToolTip();
        this.setFlags();
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void getInfo(TableInputMeta meta, boolean preview) {
        meta.setConnection(this.wConnection.getText());
        meta.setSql(preview && !Utils.isEmpty((CharSequence)this.wSql.getSelectionText()) ? this.wSql.getSelectionText() : this.wSql.getText());
        meta.setRowLimit(this.wLimit.getText());
        meta.setExecuteEachInputRow(this.wEachRow.getSelection());
        meta.setVariableReplacementActive(this.wVariables.getSelection());
        meta.setLookup(this.wDataFrom.getText());
        meta.resetTransformIoMeta();
        meta.searchInfoAndTargetTransforms(this.pipelineMeta.getTransforms());
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        this.transformName = this.wTransformName.getText();
        if (Utils.isEmpty((CharSequence)this.wConnection.getText())) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"TableInputDialog.SelectValidConnection", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"TableInputDialog.DialogCaptionError", (String[])new String[0]));
            mb.open();
            return;
        }
        this.getInfo(this.input, false);
        this.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void getSql() {
        DatabaseMeta databaseMeta = this.pipelineMeta.findDatabase(this.wConnection.getText(), this.variables);
        if (databaseMeta != null) {
            DatabaseExplorerDialog std = new DatabaseExplorerDialog(this.shell, 0, this.variables, databaseMeta, this.pipelineMeta.getDatabases(), false, true);
            if (!std.open()) return;
            String sql = "SELECT *" + Const.CR + "FROM " + databaseMeta.getQuotedSchemaTableCombination(this.variables, std.getSchemaName(), std.getTableName()) + Const.CR;
            this.wSql.setText(sql);
            MessageBox yn = new MessageBox(this.shell, 452);
            yn.setMessage(BaseMessages.getString(PKG, (String)"TableInputDialog.IncludeFieldNamesInSQL", (String[])new String[0]));
            yn.setText(BaseMessages.getString(PKG, (String)"TableInputDialog.DialogCaptionQuestion", (String[])new String[0]));
            int id = yn.open();
            switch (id) {
                case 256: {
                    return;
                }
                case 128: {
                    this.wSql.setText(sql);
                    return;
                }
                case 64: {
                    Database db = new Database(loggingObject, this.variables, databaseMeta);
                    try {
                        db.connect();
                        IRowMeta fields = db.getQueryFields(sql, false);
                        if (fields != null) {
                            sql = "SELECT" + Const.CR;
                            for (int i = 0; i < fields.size(); ++i) {
                                IValueMeta field = fields.getValueMeta(i);
                                sql = i == 0 ? sql + "  " : sql + ", ";
                                sql = sql + databaseMeta.quoteField(field.getName()) + Const.CR;
                            }
                            sql = sql + "FROM " + databaseMeta.getQuotedSchemaTableCombination(this.variables, std.getSchemaName(), std.getTableName()) + Const.CR;
                            this.wSql.setText(sql);
                            return;
                        } else {
                            MessageBox mb = new MessageBox(this.shell, 33);
                            mb.setMessage(BaseMessages.getString(PKG, (String)"TableInputDialog.ERROR_CouldNotRetrieveFields", (String[])new String[0]) + Const.CR + BaseMessages.getString(PKG, (String)"TableInputDialog.PerhapsNoPermissions", (String[])new String[0]));
                            mb.setText(BaseMessages.getString(PKG, (String)"TableInputDialog.DialogCaptionError2", (String[])new String[0]));
                            mb.open();
                        }
                        return;
                    }
                    catch (HopException e) {
                        MessageBox mb = new MessageBox(this.shell, 33);
                        mb.setText(BaseMessages.getString(PKG, (String)"TableInputDialog.DialogCaptionError3", (String[])new String[0]));
                        mb.setMessage(BaseMessages.getString(PKG, (String)"TableInputDialog.AnErrorOccurred", (String[])new String[0]) + Const.CR + e.getMessage());
                        mb.open();
                        return;
                    }
                    finally {
                        db.disconnect();
                    }
                }
            }
            return;
        }
        MessageBox mb = new MessageBox(this.shell, 33);
        mb.setMessage(BaseMessages.getString(PKG, (String)"TableInputDialog.ConnectionNoLongerAvailable", (String[])new String[0]));
        mb.setText(BaseMessages.getString(PKG, (String)"TableInputDialog.DialogCaptionError4", (String[])new String[0]));
        mb.open();
    }

    private void setFlags() {
        if (!Utils.isEmpty((CharSequence)this.wDataFrom.getText())) {
            this.wEachRow.setEnabled(true);
            this.wlEachRow.setEnabled(true);
            this.wPreview.setEnabled(false);
        } else {
            this.wEachRow.setEnabled(false);
            this.wEachRow.setSelection(false);
            this.wlEachRow.setEnabled(false);
            this.wPreview.setEnabled(true);
        }
    }

    private void preview() {
        TableInputMeta oneMeta = new TableInputMeta();
        this.getInfo(oneMeta, true);
        PipelineMeta previewMeta = PipelinePreviewFactory.generatePreviewPipeline((IHopMetadataProvider)this.pipelineMeta.getMetadataProvider(), (ITransformMeta)oneMeta, (String)this.wTransformName.getText());
        EnterNumberDialog numberDialog = new EnterNumberDialog(this.shell, this.props.getDefaultPreviewSize(), BaseMessages.getString(PKG, (String)"TableInputDialog.EnterPreviewSize", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TableInputDialog.NumberOfRowsToPreview", (String[])new String[0]));
        int previewSize = numberDialog.open();
        if (previewSize > 0) {
            PipelinePreviewProgressDialog progressDialog = new PipelinePreviewProgressDialog(this.shell, this.variables, previewMeta, new String[]{this.wTransformName.getText()}, new int[]{previewSize});
            progressDialog.open();
            Pipeline pipeline = progressDialog.getPipeline();
            String loggingText = progressDialog.getLoggingText();
            if (!progressDialog.isCancelled()) {
                if (pipeline.getResult() != null && pipeline.getResult().getNrErrors() > 0L) {
                    EnterTextDialog etd = new EnterTextDialog(this.shell, BaseMessages.getString(PKG, (String)"System.Dialog.PreviewError.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Dialog.PreviewError.Message", (String[])new String[0]), loggingText, true);
                    etd.setReadOnly();
                    etd.open();
                } else {
                    PreviewRowsDialog prd = new PreviewRowsDialog(this.shell, this.variables, 0, this.wTransformName.getText(), progressDialog.getPreviewRowsMeta(this.wTransformName.getText()), progressDialog.getPreviewRows(this.wTransformName.getText()), loggingText);
                    prd.open();
                }
            }
        }
    }
}

