/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.cloud.storage;

import java.io.File;
import java.io.InputStream;
import java.util.Map;
import net.snowflake.client.core.HttpClientSettingsKey;
import net.snowflake.client.core.SFSession;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.FileBackedOutputStream;
import net.snowflake.client.jdbc.MatDesc;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.client.jdbc.SnowflakeSQLLoggedException;
import net.snowflake.client.jdbc.cloud.storage.StorageObjectMetadata;
import net.snowflake.client.jdbc.cloud.storage.StorageObjectSummaryCollection;
import net.snowflake.client.jdbc.cloud.storage.StorageProviderException;

public interface SnowflakeStorageClient {
    public int getMaxRetries();

    public int getRetryBackoffMaxExponent();

    public int getRetryBackoffMin();

    public boolean isEncrypting();

    public int getEncryptionKeySize();

    default public boolean requirePresignedUrl() {
        return false;
    }

    public void renew(Map<?, ?> var1) throws SnowflakeSQLException;

    public void shutdown();

    public StorageObjectSummaryCollection listObjects(String var1, String var2) throws StorageProviderException;

    public StorageObjectMetadata getObjectMetadata(String var1, String var2) throws StorageProviderException;

    public void download(SFSession var1, String var2, String var3, String var4, int var5, String var6, String var7, String var8, String var9) throws SnowflakeSQLException;

    public InputStream downloadToStream(SFSession var1, String var2, int var3, String var4, String var5, String var6, String var7) throws SnowflakeSQLException;

    public void upload(SFSession var1, String var2, int var3, boolean var4, String var5, File var6, String var7, InputStream var8, FileBackedOutputStream var9, StorageObjectMetadata var10, String var11, String var12) throws SnowflakeSQLException;

    default public void uploadWithPresignedUrlWithoutConnection(int networkTimeoutInMilli, HttpClientSettingsKey ocspModeAndProxyKey, int parallelism, boolean uploadFromStream, String remoteStorageLocation, File srcFile, String destFileName, InputStream inputStream, FileBackedOutputStream fileBackedOutputStream, StorageObjectMetadata meta, String stageRegion, String presignedUrl) throws SnowflakeSQLException {
        if (!this.requirePresignedUrl()) {
            throw new SnowflakeSQLLoggedException(null, (int)ErrorCode.INTERNAL_ERROR.getMessageCode(), "XX000", "uploadWithPresignedUrlWithoutConnection only works for pre-signed URL.");
        }
    }

    public void handleStorageException(Exception var1, int var2, String var3, SFSession var4, String var5) throws SnowflakeSQLException;

    public String getMatdescKey();

    public void addEncryptionMetadata(StorageObjectMetadata var1, MatDesc var2, byte[] var3, byte[] var4, long var5);

    public void addDigestMetadata(StorageObjectMetadata var1, String var2);

    public String getDigestMetadata(StorageObjectMetadata var1);

    public void addStreamingIngestMetadata(StorageObjectMetadata var1, String var2, String var3);

    public String getStreamingIngestClientName(StorageObjectMetadata var1);

    public String getStreamingIngestClientKey(StorageObjectMetadata var1);
}

