/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.threeten.bp.chrono;

import java.util.Locale;
import net.snowflake.client.jdbc.internal.threeten.bp.DateTimeException;
import net.snowflake.client.jdbc.internal.threeten.bp.chrono.Era;
import net.snowflake.client.jdbc.internal.threeten.bp.format.DateTimeFormatterBuilder;
import net.snowflake.client.jdbc.internal.threeten.bp.format.TextStyle;
import net.snowflake.client.jdbc.internal.threeten.bp.temporal.ChronoField;
import net.snowflake.client.jdbc.internal.threeten.bp.temporal.ChronoUnit;
import net.snowflake.client.jdbc.internal.threeten.bp.temporal.Temporal;
import net.snowflake.client.jdbc.internal.threeten.bp.temporal.TemporalField;
import net.snowflake.client.jdbc.internal.threeten.bp.temporal.TemporalQueries;
import net.snowflake.client.jdbc.internal.threeten.bp.temporal.TemporalQuery;
import net.snowflake.client.jdbc.internal.threeten.bp.temporal.UnsupportedTemporalTypeException;
import net.snowflake.client.jdbc.internal.threeten.bp.temporal.ValueRange;

public enum IsoEra implements Era
{
    BCE,
    CE;


    public static IsoEra of(int era) {
        switch (era) {
            case 0: {
                return BCE;
            }
            case 1: {
                return CE;
            }
        }
        throw new DateTimeException("Invalid era: " + era);
    }

    @Override
    public int getValue() {
        return this.ordinal();
    }

    @Override
    public boolean isSupported(TemporalField field) {
        if (field instanceof ChronoField) {
            return field == ChronoField.ERA;
        }
        return field != null && field.isSupportedBy(this);
    }

    @Override
    public ValueRange range(TemporalField field) {
        if (field == ChronoField.ERA) {
            return field.range();
        }
        if (field instanceof ChronoField) {
            throw new UnsupportedTemporalTypeException("Unsupported field: " + field);
        }
        return field.rangeRefinedBy(this);
    }

    @Override
    public int get(TemporalField field) {
        if (field == ChronoField.ERA) {
            return this.getValue();
        }
        return this.range(field).checkValidIntValue(this.getLong(field), field);
    }

    @Override
    public long getLong(TemporalField field) {
        if (field == ChronoField.ERA) {
            return this.getValue();
        }
        if (field instanceof ChronoField) {
            throw new UnsupportedTemporalTypeException("Unsupported field: " + field);
        }
        return field.getFrom(this);
    }

    @Override
    public Temporal adjustInto(Temporal temporal) {
        return temporal.with(ChronoField.ERA, this.getValue());
    }

    @Override
    public <R> R query(TemporalQuery<R> query) {
        if (query == TemporalQueries.precision()) {
            return (R)ChronoUnit.ERAS;
        }
        if (query == TemporalQueries.chronology() || query == TemporalQueries.zone() || query == TemporalQueries.zoneId() || query == TemporalQueries.offset() || query == TemporalQueries.localDate() || query == TemporalQueries.localTime()) {
            return null;
        }
        return query.queryFrom(this);
    }

    @Override
    public String getDisplayName(TextStyle style, Locale locale) {
        return new DateTimeFormatterBuilder().appendText((TemporalField)ChronoField.ERA, style).toFormatter(locale).format(this);
    }
}

