/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.async.connection;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.List;
import org.neo4j.driver.internal.DomainNameResolver;
import org.neo4j.driver.internal.shaded.io.netty.resolver.InetNameResolver;
import org.neo4j.driver.internal.shaded.io.netty.util.concurrent.EventExecutor;
import org.neo4j.driver.internal.shaded.io.netty.util.concurrent.Promise;

public class NettyDomainNameResolver
extends InetNameResolver {
    private final DomainNameResolver domainNameResolver;

    public NettyDomainNameResolver(EventExecutor executor, DomainNameResolver domainNameResolver) {
        super(executor);
        this.domainNameResolver = domainNameResolver;
    }

    @Override
    protected void doResolve(String inetHost, Promise<InetAddress> promise) {
        try {
            promise.setSuccess(this.domainNameResolver.resolve(inetHost)[0]);
        }
        catch (UnknownHostException e) {
            promise.setFailure(e);
        }
    }

    @Override
    protected void doResolveAll(String inetHost, Promise<List<InetAddress>> promise) {
        try {
            promise.setSuccess(Arrays.asList(this.domainNameResolver.resolve(inetHost)));
        }
        catch (UnknownHostException e) {
            promise.setFailure(e);
        }
    }
}

