/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.security;

import java.io.Serializable;
import java.util.Hashtable;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.security.UsmTimeEntry;
import org.snmp4j.smi.OctetString;

public class UsmTimeTable
implements Serializable {
    private static final long serialVersionUID = -1538321547688349797L;
    private static final LogAdapter logger = LogFactory.getLogger(UsmTimeTable.class);
    private Hashtable table = new Hashtable(10);
    private long lastLocalTimeChange = System.currentTimeMillis();
    private UsmTimeEntry localTime;

    public UsmTimeTable(OctetString octetString, int n) {
        this.setLocalTime(new UsmTimeEntry(octetString, n, 0));
    }

    public void addEntry(UsmTimeEntry usmTimeEntry) {
        this.table.put(usmTimeEntry.getEngineID(), usmTimeEntry);
    }

    public UsmTimeEntry getEntry(OctetString octetString) {
        return (UsmTimeEntry)this.table.get(octetString);
    }

    public UsmTimeEntry getLocalTime() {
        UsmTimeEntry usmTimeEntry = new UsmTimeEntry(this.localTime.getEngineID(), this.localTime.getEngineBoots(), this.getEngineTime());
        usmTimeEntry.setTimeDiff(usmTimeEntry.getTimeDiff() * -1 + this.localTime.getTimeDiff());
        return usmTimeEntry;
    }

    private void setLocalTime(UsmTimeEntry usmTimeEntry) {
        this.localTime = usmTimeEntry;
        this.lastLocalTimeChange = System.currentTimeMillis();
    }

    public void setEngineBoots(int n) {
        this.localTime.setEngineBoots(n);
    }

    public int getEngineTime() {
        return (int)((System.currentTimeMillis() - this.lastLocalTimeChange) / 1000L % 0x80000000L);
    }

    public int getEngineBoots() {
        return this.localTime.getEngineBoots();
    }

    public synchronized UsmTimeEntry getTime(OctetString octetString) {
        if (this.localTime.getEngineID().equals(octetString)) {
            return this.getLocalTime();
        }
        UsmTimeEntry usmTimeEntry = (UsmTimeEntry)this.table.get(octetString);
        if (usmTimeEntry == null) {
            return null;
        }
        return new UsmTimeEntry(octetString, usmTimeEntry.getEngineBoots(), usmTimeEntry.getTimeDiff() + (int)(System.currentTimeMillis() / 1000L));
    }

    public void removeEntry(OctetString octetString) {
        this.table.remove(octetString);
    }

    public synchronized int checkEngineID(OctetString octetString, boolean bl) {
        if (this.table.get(octetString) != null) {
            return 0;
        }
        if (bl) {
            this.addEntry(new UsmTimeEntry(octetString, 0, 0));
            return 0;
        }
        return 1410;
    }

    public synchronized int checkTime(UsmTimeEntry usmTimeEntry) {
        int n = (int)(System.currentTimeMillis() / 1000L);
        if (this.localTime.getEngineID().equals(usmTimeEntry.getEngineID())) {
            if (this.localTime.getEngineBoots() == Integer.MAX_VALUE || this.localTime.getEngineBoots() != usmTimeEntry.getEngineBoots() || Math.abs(n + this.localTime.getTimeDiff() - usmTimeEntry.getLatestReceivedTime()) > 150) {
                if (logger.isDebugEnabled()) {
                    logger.debug("CheckTime: received message outside time window (authorative):" + (this.localTime.getEngineBoots() != usmTimeEntry.getEngineBoots() ? "engineBoots differ" : "" + Math.abs(n + this.localTime.getTimeDiff() - usmTimeEntry.getLatestReceivedTime()) + " > 150"));
                }
                return 1411;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("CheckTime: time ok (authorative)");
            }
            return 0;
        }
        UsmTimeEntry usmTimeEntry2 = (UsmTimeEntry)this.table.get(usmTimeEntry.getEngineID());
        if (usmTimeEntry2 == null) {
            return 1410;
        }
        if (usmTimeEntry.getEngineBoots() < usmTimeEntry2.getEngineBoots() || usmTimeEntry.getEngineBoots() == usmTimeEntry2.getEngineBoots() && usmTimeEntry2.getTimeDiff() + n > usmTimeEntry.getLatestReceivedTime() + 150 || usmTimeEntry2.getEngineBoots() == Integer.MAX_VALUE) {
            if (logger.isDebugEnabled()) {
                logger.debug("CheckTime: received message outside time window (non authorative)");
            }
            return 1411;
        }
        if (usmTimeEntry.getEngineBoots() > usmTimeEntry2.getEngineBoots() || usmTimeEntry.getEngineBoots() == usmTimeEntry2.getEngineBoots() && usmTimeEntry.getLatestReceivedTime() > usmTimeEntry2.getLatestReceivedTime()) {
            usmTimeEntry2.setEngineBoots(usmTimeEntry.getEngineBoots());
            usmTimeEntry2.setLatestReceivedTime(usmTimeEntry.getLatestReceivedTime());
            usmTimeEntry2.setTimeDiff(usmTimeEntry.getLatestReceivedTime() - n);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("CheckTime: time ok (non authorative)");
        }
        return 0;
    }
}

