/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400CertificateAttribute;
import com.ibm.as400.access.AS400CertificateUtil;
import com.ibm.as400.access.AS400CertificateUtilImpl;
import com.ibm.as400.access.AS400CertificateVldlUtilImpl;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.Converter;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIOException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.Trace;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.Serializable;

public class AS400CertificateVldlUtil
extends AS400CertificateUtil
implements Serializable {
    private static final String CLASSNAME = "com.ibm.as400.access.AS400CertificateVldlUtil";
    static final long serialVersionUID = 4L;
    transient AS400CertificateVldlUtilImpl vldlImpl_ = null;

    public AS400CertificateVldlUtil() {
    }

    public AS400CertificateVldlUtil(AS400 aS400, String string) {
        super(aS400, string);
        if (!this.objectType_.equalsIgnoreCase("VLDL") || this.objectName_.length() > 10) {
            throw new ExtendedIllegalArgumentException("path (" + string + ")", 3);
        }
    }

    void connect() throws IOException {
        if (this.system_ == null) {
            Trace.log(2, "Parameter 'system' is null at connect.");
            throw new ExtendedIllegalStateException("system", 4);
        }
        if (this.ifsPathName_ == null) {
            Trace.log(2, "Parameter 'path' is null.");
            throw new ExtendedIllegalStateException("ifsPathName", 4);
        }
        this.vldlImpl_ = (AS400CertificateVldlUtilImpl)this.system_.loadImpl("com.ibm.as400.access.AS400CertificateVldlUtilImplNative", "com.ibm.as400.access.AS400CertificateVldlUtilImplRemote");
        this.impl_ = (AS400CertificateUtilImpl)this.system_.loadImpl("com.ibm.as400.access.AS400CertificateUtilImplNative", "com.ibm.as400.access.AS400CertificateUtilImplRemote");
        this.vldlImpl_.system_ = this.system_;
        this.impl_.system_ = this.system_;
        Converter converter = new Converter(this.system_.getCcsid(), this.system_);
        this.vldlImpl_.setConverter(converter);
        this.impl_.setConverter(converter);
        this.connected_ = true;
    }

    public void addCertificate(byte[] byArray) throws AS400SecurityException, ErrorCompletingRequestException, ExtendedIOException, InterruptedException, IOException, ObjectDoesNotExistException {
        int n;
        if (null == byArray) {
            Trace.log(2, "Parameter 'certificate' is null.");
            throw new NullPointerException("certificate");
        }
        if (!this.isConnected()) {
            this.connect();
        }
        if ((n = this.vldlImpl_.calladdCertificate(byArray, byArray.length, this.ifsPathName_, this.ifsPathName_.length())) != 0) {
            this.throwException(this.vldlImpl_.cpfError_, this.ifsPathName_, n);
        }
        this.fireAdd();
    }

    public boolean checkCertificate(byte[] byArray) throws AS400SecurityException, ErrorCompletingRequestException, ExtendedIOException, InterruptedException, IOException, ObjectDoesNotExistException {
        int n;
        if (null == byArray) {
            Trace.log(2, "Parameter 'certificate' is null.");
            throw new NullPointerException("certificate");
        }
        if (!this.isConnected()) {
            this.connect();
        }
        if ((n = this.vldlImpl_.callcheckCertificate(byArray, byArray.length, this.ifsPathName_, this.ifsPathName_.length(), 1)) != 0) {
            this.throwException(this.vldlImpl_.cpfError_, this.ifsPathName_, n);
        }
        return this.vldlImpl_.present_ == 1;
    }

    public boolean checkCertificateByHandle(byte[] byArray) throws AS400SecurityException, ErrorCompletingRequestException, ExtendedIOException, InterruptedException, IOException, ObjectDoesNotExistException {
        int n;
        if (null == byArray) {
            Trace.log(2, "Parameter 'certificateHandle' is null.");
            throw new NullPointerException("certificateHandle");
        }
        if (!this.isConnected()) {
            this.connect();
        }
        if ((n = this.vldlImpl_.callcheckCertificate(byArray, byArray.length, this.ifsPathName_, this.ifsPathName_.length(), 2)) != 0) {
            this.throwException(this.vldlImpl_.cpfError_, this.ifsPathName_, n);
        }
        return this.vldlImpl_.present_ == 1;
    }

    public void deleteCertificate(byte[] byArray) throws AS400SecurityException, ErrorCompletingRequestException, ExtendedIOException, InterruptedException, IOException, ObjectDoesNotExistException {
        int n;
        if (null == byArray) {
            Trace.log(2, "Parameter 'certificate' is null.");
            throw new NullPointerException("certificate");
        }
        if (!this.isConnected()) {
            this.connect();
        }
        if ((n = this.vldlImpl_.calldeleteCertificate(byArray, byArray.length, this.ifsPathName_, this.ifsPathName_.length(), 1)) != 0) {
            this.throwException(this.vldlImpl_.cpfError_, this.ifsPathName_, n);
        }
        this.fireDelete();
    }

    public void deleteCertificateByHandle(byte[] byArray) throws AS400SecurityException, ErrorCompletingRequestException, ExtendedIOException, InterruptedException, IOException, ObjectDoesNotExistException {
        int n;
        if (null == byArray) {
            Trace.log(2, "Parameter 'certificateHandle' is null.");
            throw new NullPointerException("certificateHandle");
        }
        if (!this.isConnected()) {
            this.connect();
        }
        if ((n = this.vldlImpl_.calldeleteCertificate(byArray, byArray.length, this.ifsPathName_, this.ifsPathName_.length(), 2)) != 0) {
            this.throwException(this.vldlImpl_.cpfError_, this.ifsPathName_, n);
        }
        this.fireDelete();
    }

    public int listCertificates(AS400CertificateAttribute[] aS400CertificateAttributeArray, String string) throws AS400SecurityException, ErrorCompletingRequestException, ExtendedIOException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.isConnected()) {
            this.connect();
        }
        boolean[] blArray = this.setSearchAttributes(aS400CertificateAttributeArray);
        String string2 = this.getAS400UserSpaceName(string);
        int n = this.vldlImpl_.calllistCertificates(this.ifsPathName_, this.ifsPathName_.length(), string2, blArray, this.as400AttrS_, this.as400AttrB_);
        if (n != 0) {
            this.throwException(this.vldlImpl_.cpfError_, this.ifsPathName_, n);
        }
        return this.vldlImpl_.numberCertificatesFound_;
    }

    public void setPath(String string) throws PropertyVetoException {
        if (string == null) {
            Trace.log(2, "Parameter 'path' is null.");
            throw new NullPointerException("path");
        }
        QSYSObjectPathName qSYSObjectPathName = new QSYSObjectPathName(string);
        String string2 = qSYSObjectPathName.getLibraryName();
        String string3 = qSYSObjectPathName.getObjectName();
        String string4 = qSYSObjectPathName.getObjectType();
        if (null == string2 || null == string3 || string3.length() > 10 || !string4.equalsIgnoreCase("VLDL")) {
            throw new ExtendedIllegalArgumentException("path", 3);
        }
        if (this.ifsPathName_ == null) {
            this.ifsPathName_ = string;
            this.libName_ = string2;
            this.objectName_ = string3;
            this.objectType_ = string4;
        } else {
            if (this.system_ != null && this.isConnected()) {
                Trace.log(2, "Parameter 'path' is not changed (Connected=true).");
                throw new ExtendedIllegalStateException("path", 5);
            }
            String string5 = this.ifsPathName_;
            this.vetos_.fireVetoableChange("path", string5, string);
            this.ifsPathName_ = string;
            this.libName_ = string2;
            this.objectName_ = string3;
            this.objectType_ = string4;
            this.changes_.firePropertyChange("path", string5, string);
        }
    }

    static {
        if (Trace.traceOn_) {
            Trace.logLoadPath(CLASSNAME);
        }
    }
}

