/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.ProxyImpl;
import com.ibm.as400.access.PxBooleanParm;
import com.ibm.as400.access.PxByteParm;
import com.ibm.as400.access.PxCharParm;
import com.ibm.as400.access.PxDS;
import com.ibm.as400.access.PxDSFactory;
import com.ibm.as400.access.PxDoubleParm;
import com.ibm.as400.access.PxFloatParm;
import com.ibm.as400.access.PxIntParm;
import com.ibm.as400.access.PxLongParm;
import com.ibm.as400.access.PxNullParm;
import com.ibm.as400.access.PxParm;
import com.ibm.as400.access.PxPxObjectParm;
import com.ibm.as400.access.PxSerializedObjectParm;
import com.ibm.as400.access.PxShortParm;
import com.ibm.as400.access.PxStringParm;
import com.ibm.as400.access.PxTable;
import com.ibm.as400.access.PxToolboxObjectParm;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Vector;

abstract class PxCompDS
extends PxDS {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private Vector parameters_ = new Vector();

    public PxCompDS(short s) {
        super(s);
    }

    public void addObjectParm(Object object) {
        this.addObjectParm(null, object);
    }

    public void addObjectParm(PxTable pxTable, Object object) {
        PxDS pxDS;
        if (object == null) {
            pxDS = new PxNullParm();
        } else if (object instanceof Byte) {
            pxDS = new PxByteParm((Byte)object);
        } else if (object instanceof Short) {
            pxDS = new PxShortParm((Short)object);
        } else if (object instanceof Integer) {
            pxDS = new PxIntParm((Integer)object);
        } else if (object instanceof Long) {
            pxDS = new PxLongParm((Long)object);
        } else if (object instanceof Float) {
            pxDS = new PxFloatParm((Float)object);
        } else if (object instanceof Double) {
            pxDS = new PxDoubleParm((Double)object);
        } else if (object instanceof Character) {
            pxDS = new PxCharParm((Character)object);
        } else if (object instanceof Boolean) {
            pxDS = new PxBooleanParm((Boolean)object);
        } else if (object instanceof String) {
            pxDS = new PxStringParm((String)object);
        } else {
            long l = -1L;
            if (object instanceof ProxyImpl) {
                l = ((ProxyImpl)object).getPxId();
            } else if (pxTable != null) {
                l = pxTable.get(object);
            }
            pxDS = l >= 0L ? new PxPxObjectParm(l) : (object.getClass().getName().startsWith("com.ibm.as400.access") ? new PxToolboxObjectParm(object) : new PxSerializedObjectParm(object));
        }
        this.addParm((PxParm)((Object)pxDS));
    }

    public void addParm(PxParm pxParm) {
        this.parameters_.addElement(pxParm);
    }

    public void clearParms() {
        this.parameters_.removeAllElements();
    }

    public Object clone() throws CloneNotSupportedException {
        PxCompDS pxCompDS = (PxCompDS)super.clone();
        pxCompDS.parameters_ = (Vector)this.parameters_.clone();
        return pxCompDS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(PrintWriter printWriter) {
        PrintWriter printWriter2 = printWriter;
        synchronized (printWriter2) {
            super.dump(printWriter);
            int n = this.parameters_.size();
            for (int i = 0; i < n; ++i) {
                printWriter.println("   " + this.parameters_.elementAt(i).toString());
            }
        }
    }

    public PxParm getParm(int n) {
        return (PxParm)this.parameters_.elementAt(n);
    }

    public int getParmCount() {
        return this.parameters_.size();
    }

    public void readFrom(InputStream inputStream, PxDSFactory pxDSFactory) throws IOException {
        super.readFrom(inputStream, pxDSFactory);
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        this.clearParms();
        int n = dataInputStream.readInt();
        for (int i = 0; i < n; ++i) {
            PxParm pxParm = (PxParm)pxDSFactory.getNextDS(inputStream);
            this.addParm(pxParm);
        }
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        super.writeTo(outputStream);
        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
        int n = this.getParmCount();
        dataOutputStream.writeInt(n);
        for (int i = 0; i < n; ++i) {
            this.getParm(i).writeTo(outputStream);
        }
    }
}

