/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.Trace;
import com.ibm.as400.vaccess.ErrorEvent;
import com.ibm.as400.vaccess.ErrorEventSupport;
import com.ibm.as400.vaccess.ErrorListener;
import com.ibm.as400.vaccess.PropertyChangeSupport;
import com.ibm.as400.vaccess.RecordListData;
import com.ibm.as400.vaccess.VetoableChangeSupport;
import com.ibm.as400.vaccess.WorkingEventSupport;
import com.ibm.as400.vaccess.WorkingListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;

public class RecordListTableModel
extends AbstractTableModel
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    public static final int KEY_EQ = 0;
    public static final int KEY_GT = 1;
    public static final int KEY_GE = 2;
    public static final int KEY_LT = 3;
    public static final int KEY_LE = 4;
    private RecordListData tableData_ = new RecordListData();
    private transient int numColumns_ = 0;
    private static final int READ_INCREMENT_ = 20;
    private transient int numRows_ = 0;
    private transient PropertyChangeSupport changeListeners_ = new PropertyChangeSupport(this);
    private transient VetoableChangeSupport vetoListeners_ = new VetoableChangeSupport(this);
    transient ErrorEventSupport errorListeners_ = new ErrorEventSupport(this);
    private transient WorkingEventSupport workListeners_ = new WorkingEventSupport(this);
    private transient ErrorListener_ errorListener_ = new ErrorListener_();
    transient boolean error_;

    public RecordListTableModel() {
        this.tableData_.addErrorListener(this.errorListener_);
        this.tableData_.addWorkingListener(this.workListeners_);
    }

    public RecordListTableModel(AS400 aS400, String string) {
        if (string == null) {
            throw new NullPointerException("fileName");
        }
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        this.tableData_.setFileName(string);
        this.tableData_.setSystem(aS400);
        this.tableData_.addErrorListener(this.errorListener_);
        this.tableData_.addWorkingListener(this.workListeners_);
    }

    public RecordListTableModel(AS400 aS400, String string, Object[] objectArray, int n) {
        if (string == null) {
            throw new NullPointerException("fileName");
        }
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        this.tableData_.setFileName(string);
        this.tableData_.setSystem(aS400);
        this.tableData_.setKeyed(true);
        this.tableData_.setKey(objectArray);
        this.tableData_.setSearchType(n);
        this.tableData_.addErrorListener(this.errorListener_);
        this.tableData_.addWorkingListener(this.workListeners_);
    }

    public void addErrorListener(ErrorListener errorListener) {
        this.errorListeners_.addErrorListener(errorListener);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeListeners_.addPropertyChangeListener(propertyChangeListener);
    }

    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        this.vetoListeners_.addVetoableChangeListener(vetoableChangeListener);
    }

    public void addWorkingListener(WorkingListener workingListener) {
        this.workListeners_.addWorkingListener(workingListener);
    }

    public void close() {
        this.tableData_.close();
    }

    public Class getColumnClass(int n) {
        if (n >= this.numColumns_) {
            Trace.log(4, "getColumnClass() error - index out of bounds.");
            return null;
        }
        Object object = null;
        for (int i = 0; i < this.getRowCount() && object == null; ++i) {
            object = this.getValueAt(i, n);
        }
        if (object != null) {
            return object.getClass();
        }
        try {
            return Class.forName("java.lang.Object");
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public int getColumnCount() {
        if (Trace.isTraceOn() && Trace.isTraceDiagnosticOn()) {
            Trace.log(1, "getColumnCount:", this.numColumns_);
        }
        return this.numColumns_;
    }

    public String getColumnID(int n) {
        if (n >= this.numColumns_) {
            Trace.log(4, "getColumnID() error - index out of bounds.");
            return null;
        }
        return this.tableData_.getColumnName(n);
    }

    public String getColumnName(int n) {
        if (n >= this.numColumns_) {
            Trace.log(4, "getColumnName() error - index out of bounds.");
            return null;
        }
        return this.tableData_.getColumnLabel(n);
    }

    public int getColumnWidth(int n) {
        if (n >= this.numColumns_) {
            Trace.log(4, "getColumnWidth() error - index out of bounds.");
            return 0;
        }
        return this.tableData_.getColumnDisplaySize(n);
    }

    public String getFileName() {
        String string = this.tableData_.getFileName();
        if (string == null) {
            return "";
        }
        return string;
    }

    public Object[] getKey() {
        return this.tableData_.getKey();
    }

    public boolean getKeyed() {
        return this.tableData_.getKeyed();
    }

    public int getRowCount() {
        if (Trace.isTraceOn() && Trace.isTraceDiagnosticOn()) {
            Trace.log(1, "getRowCount:", this.numRows_);
        }
        return this.numRows_;
    }

    public int getSearchType() {
        return this.tableData_.getSearchType();
    }

    public AS400 getSystem() {
        return this.tableData_.getSystem();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getValueAt(int n, int n2) {
        TableModelEvent tableModelEvent = null;
        this.error_ = false;
        RecordListTableModel recordListTableModel = this;
        synchronized (recordListTableModel) {
            Trace.log(1, "getValueAt[" + n + "][" + n2 + "]");
            if (this.tableData_ == null) {
                Trace.log(4, "getValueAt() error - no load done.");
                return null;
            }
            if (n2 >= this.numColumns_) {
                Trace.log(4, "getValueAt() error - column index out of range.");
                return null;
            }
            if (this.tableData_.getAllRecordsProcessed() && n >= this.tableData_.getNumberOfRows()) {
                Trace.log(4, "getValueAt() error - row out of range.");
                return null;
            }
            this.error_ = false;
            if (this.tableData_.getLastRecordProcessed() < n) {
                if (n - this.tableData_.getLastRecordProcessed() > 20) {
                    this.tableData_.readMoreRecords(n - this.tableData_.getLastRecordProcessed());
                } else {
                    this.tableData_.readMoreRecords(20);
                }
                int n3 = this.numRows_;
                if (this.tableData_.getAllRecordsProcessed()) {
                    this.numRows_ = this.tableData_.getLastRecordProcessed() + 1;
                    Trace.log(3, "All rows read, number of rows:", this.numRows_);
                    if (n >= this.tableData_.getNumberOfRows()) {
                        Trace.log(4, "getValueAt() error - row out of range(2).");
                        this.error_ = true;
                    }
                } else {
                    this.numRows_ = this.tableData_.getLastRecordProcessed() + 2;
                }
                tableModelEvent = new TableModelEvent(this, n3, this.numRows_ - 1, -1, 1);
            }
        }
        if (tableModelEvent != null) {
            this.fireTableChanged(tableModelEvent);
            Trace.log(3, "Changed number of rows to:", this.numRows_);
        }
        if (this.error_) {
            return null;
        }
        return this.tableData_.getValueAt(n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        Trace.log(1, "Doing model load.");
        TableModelEvent tableModelEvent = null;
        int n = 0;
        RecordListTableModel recordListTableModel = this;
        synchronized (recordListTableModel) {
            n = this.numRows_ - 1;
            if (this.numRows_ > 0) {
                this.numColumns_ = 0;
                this.numRows_ = 0;
                tableModelEvent = new TableModelEvent(this, 0, n, -1, -1);
            }
        }
        if (tableModelEvent != null) {
            this.fireTableChanged(tableModelEvent);
            Trace.log(3, "Starting load, changed number of rows to:", this.numRows_);
        }
        if (this.tableData_.getSystem() == null) {
            throw new IllegalStateException("system");
        }
        if (this.tableData_.getFileName() == null) {
            throw new IllegalStateException("fileName");
        }
        recordListTableModel = this;
        synchronized (recordListTableModel) {
            this.error_ = false;
            this.tableData_.load();
            if (this.error_) {
                return;
            }
            this.numColumns_ = this.tableData_.getNumberOfColumns();
            this.numRows_ = this.tableData_.getAllRecordsProcessed() ? this.tableData_.getNumberOfRows() : 1;
        }
        if (this.numRows_ > 0) {
            tableModelEvent = new TableModelEvent(this, 0, this.numRows_ - 1, -1, 1);
            this.fireTableChanged(tableModelEvent);
            Trace.log(3, "Did load, changed number of rows to:", this.numRows_);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.changeListeners_ = new PropertyChangeSupport(this);
        this.vetoListeners_ = new VetoableChangeSupport(this);
        this.errorListeners_ = new ErrorEventSupport(this);
        this.workListeners_ = new WorkingEventSupport(this);
        this.errorListener_ = new ErrorListener_();
        this.numRows_ = 0;
        this.numColumns_ = 0;
        this.tableData_.addErrorListener(this.errorListener_);
        this.tableData_.addWorkingListener(this.workListeners_);
    }

    public void removeErrorListener(ErrorListener errorListener) {
        this.errorListeners_.removeErrorListener(errorListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeListeners_.removePropertyChangeListener(propertyChangeListener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        this.vetoListeners_.removeVetoableChangeListener(vetoableChangeListener);
    }

    public void removeWorkingListener(WorkingListener workingListener) {
        this.workListeners_.removeWorkingListener(workingListener);
    }

    public void setFileName(String string) throws PropertyVetoException {
        if (string == null) {
            throw new NullPointerException("fileName");
        }
        String string2 = this.getFileName();
        this.vetoListeners_.fireVetoableChange("fileName", string2, string);
        this.tableData_.setFileName(string);
        this.changeListeners_.firePropertyChange("fileName", string2, string);
    }

    public void setKey(Object[] objectArray) throws PropertyVetoException {
        Object[] objectArray2 = this.getKey();
        this.vetoListeners_.fireVetoableChange("key", objectArray2, objectArray);
        this.tableData_.setKey(objectArray);
        this.changeListeners_.firePropertyChange("key", objectArray2, objectArray);
    }

    public void setKeyed(boolean bl) throws PropertyVetoException {
        Boolean bl2 = new Boolean(this.getKeyed());
        this.vetoListeners_.fireVetoableChange("keyed", bl2, new Boolean(bl));
        this.tableData_.setKeyed(bl);
        this.changeListeners_.firePropertyChange("keyed", bl2, new Boolean(bl));
    }

    public void setSearchType(int n) throws PropertyVetoException {
        int n2 = this.getSearchType();
        this.vetoListeners_.fireVetoableChange("searchType", new Integer(n2), new Integer(n));
        this.tableData_.setSearchType(n);
        this.changeListeners_.firePropertyChange("searchType", new Integer(n2), new Integer(n));
    }

    public void setSystem(AS400 aS400) throws PropertyVetoException {
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        AS400 aS4002 = this.getSystem();
        this.vetoListeners_.fireVetoableChange("system", aS4002, aS400);
        this.tableData_.setSystem(aS400);
        this.changeListeners_.firePropertyChange("system", aS4002, aS400);
    }

    private class ErrorListener_
    implements ErrorListener {
        private ErrorListener_() {
        }

        public void errorOccurred(ErrorEvent errorEvent) {
            RecordListTableModel.this.error_ = true;
            RecordListTableModel.this.errorListeners_.fireError(errorEvent.getException());
        }
    }
}

