/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.kafka.clients.admin.AbstractOptions;
import org.apache.kafka.clients.admin.TransactionState;
import org.apache.kafka.common.annotation.InterfaceStability;

@InterfaceStability.Evolving
public class ListTransactionsOptions
extends AbstractOptions<ListTransactionsOptions> {
    private Set<TransactionState> filteredStates = Collections.emptySet();
    private Set<Long> filteredProducerIds = Collections.emptySet();

    public ListTransactionsOptions filterStates(Collection<TransactionState> states) {
        this.filteredStates = new HashSet<TransactionState>(states);
        return this;
    }

    public ListTransactionsOptions filterProducerIds(Collection<Long> producerIdFilters) {
        this.filteredProducerIds = new HashSet<Long>(producerIdFilters);
        return this;
    }

    public Set<TransactionState> filteredStates() {
        return this.filteredStates;
    }

    public Set<Long> filteredProducerIds() {
        return this.filteredProducerIds;
    }

    public String toString() {
        return "ListTransactionsOptions(filteredStates=" + this.filteredStates + ", filteredProducerIds=" + this.filteredProducerIds + ", timeoutMs=" + this.timeoutMs + ')';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListTransactionsOptions that = (ListTransactionsOptions)o;
        return Objects.equals(this.filteredStates, that.filteredStates) && Objects.equals(this.filteredProducerIds, that.filteredProducerIds);
    }

    public int hashCode() {
        return Objects.hash(this.filteredStates, this.filteredProducerIds);
    }
}

