/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.admin.v2.models;

import com.google.api.core.InternalApi;
import com.google.bigtable.admin.v2.ChangeStreamConfig;
import com.google.bigtable.admin.v2.UpdateTableRequest;
import com.google.cloud.bigtable.admin.v2.internal.NameUtil;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.threeten.bp.Duration;

public class UpdateTableRequest {
    private final String tableId;
    private final UpdateTableRequest.Builder requestBuilder = com.google.bigtable.admin.v2.UpdateTableRequest.newBuilder();

    public static UpdateTableRequest of(String tableId) {
        return new UpdateTableRequest(tableId);
    }

    private UpdateTableRequest(String tableId) {
        this.tableId = tableId;
    }

    public UpdateTableRequest addChangeStreamRetention(Duration retention) {
        Preconditions.checkNotNull((Object)retention);
        if (!retention.isZero()) {
            this.requestBuilder.getTableBuilder().setChangeStreamConfig(ChangeStreamConfig.newBuilder().setRetentionPeriod(com.google.protobuf.Duration.newBuilder().setSeconds(retention.getSeconds()).setNanos(retention.getNano()).build()).build());
            this.requestBuilder.getUpdateMaskBuilder().addPaths("change_stream_config.retention_period");
        } else {
            this.requestBuilder.getTableBuilder().clearChangeStreamConfig();
            this.requestBuilder.getUpdateMaskBuilder().addPaths("change_stream_config");
        }
        return this;
    }

    public UpdateTableRequest disableChangeStreamRetention() {
        return this.addChangeStreamRetention(Duration.ZERO);
    }

    @InternalApi
    public com.google.bigtable.admin.v2.UpdateTableRequest toProto(String projectId, String instanceId) {
        this.requestBuilder.getTableBuilder().setName(NameUtil.formatTableName(projectId, instanceId, this.tableId));
        return this.requestBuilder.build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateTableRequest)) {
            return false;
        }
        UpdateTableRequest that = (UpdateTableRequest)o;
        return Objects.equals(this.requestBuilder, that.requestBuilder);
    }

    public int hashCode() {
        return Objects.hash(this.requestBuilder);
    }
}

