/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.vendor.grpc.v1p54p0.com.google.common.collect;

import java.io.Serializable;
import javax.annotation.CheckForNull;
import org.apache.beam.vendor.grpc.v1p54p0.com.google.common.annotations.GwtCompatible;
import org.apache.beam.vendor.grpc.v1p54p0.com.google.common.base.Preconditions;
import org.apache.beam.vendor.grpc.v1p54p0.com.google.common.collect.ElementTypesAreNonnullByDefault;
import org.apache.beam.vendor.grpc.v1p54p0.com.google.common.collect.Ordering;
import org.apache.beam.vendor.grpc.v1p54p0.com.google.common.collect.ReverseNaturalOrdering;
import org.checkerframework.checker.nullness.qual.Nullable;

@ElementTypesAreNonnullByDefault
@GwtCompatible(serializable=true)
final class NaturalOrdering
extends Ordering<Comparable<?>>
implements Serializable {
    static final NaturalOrdering INSTANCE = new NaturalOrdering();
    @CheckForNull
    private transient Ordering<@Nullable Comparable<?>> nullsFirst;
    @CheckForNull
    private transient Ordering<@Nullable Comparable<?>> nullsLast;
    private static final long serialVersionUID = 0L;

    @Override
    public int compare(Comparable<?> left, Comparable<?> right) {
        Preconditions.checkNotNull(left);
        Preconditions.checkNotNull(right);
        return left.compareTo(right);
    }

    @Override
    public <S extends Comparable<?>> Ordering<@Nullable S> nullsFirst() {
        Ordering<@Nullable Comparable<Object>> result = this.nullsFirst;
        if (result == null) {
            result = this.nullsFirst = super.nullsFirst();
        }
        return result;
    }

    @Override
    public <S extends Comparable<?>> Ordering<@Nullable S> nullsLast() {
        Ordering<@Nullable Comparable<Object>> result = this.nullsLast;
        if (result == null) {
            result = this.nullsLast = super.nullsLast();
        }
        return result;
    }

    @Override
    public <S extends Comparable<?>> Ordering<S> reverse() {
        return ReverseNaturalOrdering.INSTANCE;
    }

    private Object readResolve() {
        return INSTANCE;
    }

    public String toString() {
        return "Ordering.natural()";
    }

    private NaturalOrdering() {
    }
}

