/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.synthetic;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.apache.beam.sdk.io.synthetic.SyntheticOptions;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.commons.math3.distribution.ConstantRealDistribution;
import org.apache.commons.math3.distribution.RealDistribution;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;

public class SyntheticSourceOptions
extends SyntheticOptions {
    private static final @UnknownKeyFor @NonNull @Initialized long serialVersionUID = 0L;
    @JsonProperty
    public @UnknownKeyFor @NonNull @Initialized long numRecords;
    @JsonProperty
    public @UnknownKeyFor @NonNull @Initialized long splitPointFrequencyRecords = 1L;
    @JsonDeserialize(using=SyntheticOptions.SamplerDeserializer.class)
    public @UnknownKeyFor @NonNull @Initialized SyntheticOptions.Sampler bundleSizeDistribution = SyntheticSourceOptions.fromRealDistribution((RealDistribution)new ConstantRealDistribution(1.0));
    @JsonProperty
    public @UnknownKeyFor @NonNull @Initialized Integer forceNumInitialBundles;
    @JsonProperty
    public @UnknownKeyFor @NonNull @Initialized ProgressShape progressShape = ProgressShape.LINEAR;
    @JsonDeserialize(using=SyntheticOptions.SamplerDeserializer.class)
    final @UnknownKeyFor @NonNull @Initialized SyntheticOptions.Sampler initializeDelayDistribution = SyntheticSourceOptions.fromRealDistribution((RealDistribution)new ConstantRealDistribution(0.0));
    @JsonDeserialize(using=SyntheticOptions.SamplerDeserializer.class)
    @UnknownKeyFor @NonNull @Initialized SyntheticOptions.Sampler processingTimeDelayDistribution = SyntheticSourceOptions.fromRealDistribution((RealDistribution)new ConstantRealDistribution(0.0));
    @JsonProperty
    public @UnknownKeyFor @NonNull @Initialized Integer watermarkSearchInAdvanceCount = 100;
    @JsonProperty
    public @UnknownKeyFor @NonNull @Initialized Integer watermarkDriftMillis = 0;

    public @UnknownKeyFor @NonNull @Initialized Duration nextInitializeDelay(@UnknownKeyFor @NonNull @Initialized long seed) {
        return Duration.millis((long)((long)this.initializeDelayDistribution.sample(seed)));
    }

    public @UnknownKeyFor @NonNull @Initialized Duration nextProcessingTimeDelay(@UnknownKeyFor @NonNull @Initialized long seed) {
        return Duration.millis((long)((long)this.processingTimeDelayDistribution.sample(seed)));
    }

    @Override
    public void validate() {
        super.validate();
        Preconditions.checkArgument((this.numRecords >= 0L ? 1 : 0) != 0, (String)"numRecords should be a non-negative number, but found %s.", (long)this.numRecords);
        Preconditions.checkNotNull((Object)this.bundleSizeDistribution, (Object)"bundleSizeDistribution");
        Preconditions.checkArgument((this.forceNumInitialBundles == null || this.forceNumInitialBundles > 0 ? 1 : 0) != 0, (String)"forceNumInitialBundles, if specified, must be positive, but found %s", (Object)this.forceNumInitialBundles);
        Preconditions.checkArgument((this.splitPointFrequencyRecords >= 0L ? 1 : 0) != 0, (String)"splitPointFrequencyRecords must be non-negative, but found %s", (long)this.splitPointFrequencyRecords);
    }

    public @UnknownKeyFor @NonNull @Initialized Record genRecord(@UnknownKeyFor @NonNull @Initialized long position) {
        long hashCodeOfPosition = this.hashFunction().hashLong(position).asLong();
        return new Record(this.genKvPair(hashCodeOfPosition), this.nextDelay(hashCodeOfPosition));
    }

    public static enum ProgressShape {
        LINEAR,
        LINEAR_REGRESSING;

    }

    public static class Record {
        public final @UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [], @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> kv;
        public final @UnknownKeyFor @NonNull @Initialized Duration sleepMsec;

        Record(@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [], @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> kv, @UnknownKeyFor @NonNull @Initialized long sleepMsec) {
            this.kv = kv;
            this.sleepMsec = Duration.millis((long)sleepMsec);
        }
    }
}

