/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.flink.runtime.executiongraph.ArchivedExecution;

public class ExecutionHistory
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final BoundedLinkedHashMap<Integer, ArchivedExecution> historicalExecutions;
    private int maxAttemptNumber;

    public ExecutionHistory(int sizeLimit) {
        this.historicalExecutions = new BoundedLinkedHashMap(sizeLimit);
        this.maxAttemptNumber = -1;
    }

    ExecutionHistory(ExecutionHistory other) {
        this.historicalExecutions = new BoundedLinkedHashMap(other.historicalExecutions);
        this.maxAttemptNumber = other.maxAttemptNumber;
    }

    void add(ArchivedExecution execution) {
        if (execution.getAttemptNumber() > this.maxAttemptNumber) {
            this.maxAttemptNumber = execution.getAttemptNumber();
        }
        this.historicalExecutions.put(execution.getAttemptNumber(), execution);
    }

    public Optional<ArchivedExecution> getHistoricalExecution(int attemptNumber) {
        if (this.isValidAttemptNumber(attemptNumber)) {
            return Optional.ofNullable(this.historicalExecutions.get(attemptNumber));
        }
        throw new IllegalArgumentException("Invalid attempt number.");
    }

    public Collection<ArchivedExecution> getHistoricalExecutions() {
        return Collections.unmodifiableCollection(this.historicalExecutions.values());
    }

    public boolean isValidAttemptNumber(int attemptNumber) {
        return attemptNumber >= 0 && attemptNumber <= this.maxAttemptNumber;
    }

    private static class BoundedLinkedHashMap<K, V>
    extends LinkedHashMap<K, V> {
        private final int sizeLimit;

        private BoundedLinkedHashMap(int sizeLimit) {
            this.sizeLimit = sizeLimit;
        }

        private BoundedLinkedHashMap(BoundedLinkedHashMap<K, V> other) {
            super(other);
            this.sizeLimit = other.sizeLimit;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            return this.size() > this.sizeLimit;
        }
    }
}

