/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.leaderelection;

import org.apache.flink.runtime.leaderelection.LeaderElectionDriver;
import org.apache.flink.runtime.leaderelection.LeaderElectionEventHandler;
import org.apache.flink.runtime.leaderelection.LeaderInformation;
import org.apache.flink.runtime.leaderelection.MultipleComponentLeaderElectionService;
import org.apache.flink.util.Preconditions;

final class MultipleComponentLeaderElectionDriverAdapter
implements LeaderElectionDriver {
    private final String componentId;
    private final MultipleComponentLeaderElectionService multipleComponentLeaderElectionService;

    MultipleComponentLeaderElectionDriverAdapter(String componentId, MultipleComponentLeaderElectionService multipleComponentLeaderElectionService, LeaderElectionEventHandler leaderElectionEventHandler) {
        this.componentId = (String)Preconditions.checkNotNull((Object)componentId);
        this.multipleComponentLeaderElectionService = (MultipleComponentLeaderElectionService)Preconditions.checkNotNull((Object)multipleComponentLeaderElectionService);
        multipleComponentLeaderElectionService.registerLeaderElectionEventHandler(this.componentId, leaderElectionEventHandler);
    }

    @Override
    public void writeLeaderInformation(LeaderInformation leaderInformation) {
        this.multipleComponentLeaderElectionService.publishLeaderInformation(this.componentId, leaderInformation);
    }

    @Override
    public boolean hasLeadership() {
        return this.multipleComponentLeaderElectionService.hasLeadership(this.componentId);
    }

    @Override
    public void close() throws Exception {
        this.multipleComponentLeaderElectionService.unregisterLeaderElectionEventHandler(this.componentId);
    }
}

