/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigtable.changestreams.action;

import com.google.cloud.bigtable.data.v2.models.Range;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.beam.sdk.io.gcp.bigtable.changestreams.ChangeStreamMetrics;
import org.apache.beam.sdk.io.gcp.bigtable.changestreams.UniqueIdGenerator;
import org.apache.beam.sdk.io.gcp.bigtable.changestreams.action.ProcessNewPartitionsAction;
import org.apache.beam.sdk.io.gcp.bigtable.changestreams.dao.MetadataTableDao;
import org.apache.beam.sdk.io.gcp.bigtable.changestreams.model.NewPartition;
import org.apache.beam.sdk.io.gcp.bigtable.changestreams.model.PartitionRecord;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResumeFromPreviousPipelineAction {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(ResumeFromPreviousPipelineAction.class);
    private final @UnknownKeyFor @NonNull @Initialized ChangeStreamMetrics metrics;
    private final @UnknownKeyFor @NonNull @Initialized MetadataTableDao metadataTableDao;
    @Nullable
    private final @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Instant endTime;
    private final @UnknownKeyFor @NonNull @Initialized ProcessNewPartitionsAction processNewPartitionsAction;

    public ResumeFromPreviousPipelineAction(@UnknownKeyFor @NonNull @Initialized ChangeStreamMetrics metrics, @UnknownKeyFor @NonNull @Initialized MetadataTableDao metadataTableDao, @Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Instant endTime, @UnknownKeyFor @NonNull @Initialized ProcessNewPartitionsAction processNewPartitionsAction) {
        this.metrics = metrics;
        this.metadataTableDao = metadataTableDao;
        this.endTime = endTime;
        this.processNewPartitionsAction = processNewPartitionsAction;
    }

    public void run(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized PartitionRecord> receiver) throws @UnknownKeyFor @NonNull @Initialized InvalidProtocolBufferException {
        this.metadataTableDao.writeDetectNewPartitionMissingPartitions(new HashMap<Range.ByteStringRange, Instant>());
        List<PartitionRecord> partitions = this.metadataTableDao.readAllStreamPartitions();
        for (PartitionRecord partitionRecord : partitions) {
            if (partitionRecord.getUuid().isEmpty()) {
                partitionRecord.setUuid(UniqueIdGenerator.getNextId());
            }
            if (this.endTime != null) {
                partitionRecord.setEndTime(this.endTime);
            }
            LOG.info("DNP: Outputting existing partition: {}", (Object)partitionRecord);
            this.metrics.incListPartitionsCount();
            receiver.outputWithTimestamp((Object)partitionRecord, Instant.EPOCH);
        }
        List<NewPartition> newPartitions = this.metadataTableDao.readNewPartitionsIncludingDeleted();
        for (NewPartition newPartition : newPartitions) {
            this.processNewPartitionsAction.processNewPartition(newPartition, receiver);
        }
    }
}

