/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner.changestreams.encoder;

import com.google.cloud.Timestamp;
import java.io.IOException;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.reflect.CustomEncoding;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class TimestampEncoding
extends CustomEncoding<Timestamp> {
    public TimestampEncoding() {
        this.schema = (Schema)SchemaBuilder.builder().record("timestamp").fields().requiredLong("seconds").requiredInt("nanos").endRecord();
        this.schema.addProp("CustomEncoding", TimestampEncoding.class.getSimpleName());
    }

    protected void write(@UnknownKeyFor @NonNull @Initialized Object datum, @UnknownKeyFor @NonNull @Initialized Encoder out) throws @UnknownKeyFor @NonNull @Initialized IOException {
        Timestamp timestamp = (Timestamp)datum;
        if (timestamp == null) {
            out.writeLong(-1L);
            out.writeInt(-1);
        } else {
            out.writeLong(timestamp.getSeconds());
            out.writeInt(timestamp.getNanos());
        }
    }

    protected @UnknownKeyFor @NonNull @Initialized Timestamp read(@UnknownKeyFor @NonNull @Initialized Object reuse, @UnknownKeyFor @NonNull @Initialized Decoder in) throws @UnknownKeyFor @NonNull @Initialized IOException {
        long seconds = in.readLong();
        int nanos = in.readInt();
        if (seconds < 0L && nanos < 0) {
            return null;
        }
        return Timestamp.ofTimeSecondsAndNanos((long)seconds, (int)nanos);
    }
}

