/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.snmptrap;

import java.net.InetAddress;
import org.apache.hop.core.Const;
import org.apache.hop.core.Result;
import org.apache.hop.core.annotations.Action;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.util.Utils;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.workflow.action.ActionBase;
import org.apache.hop.workflow.action.IAction;
import org.snmp4j.CommunityTarget;
import org.snmp4j.PDU;
import org.snmp4j.PDUv1;
import org.snmp4j.ScopedPDU;
import org.snmp4j.Snmp;
import org.snmp4j.Target;
import org.snmp4j.TransportMapping;
import org.snmp4j.UserTarget;
import org.snmp4j.event.ResponseEvent;
import org.snmp4j.mp.MPv3;
import org.snmp4j.security.AuthMD5;
import org.snmp4j.security.PrivDES;
import org.snmp4j.security.SecurityProtocols;
import org.snmp4j.security.USM;
import org.snmp4j.security.UsmUser;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.UdpAddress;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.transport.DefaultUdpTransportMapping;

@Action(id="SNMP_TRAP", name="i18n::ActionSNMPTrap.Name", description="i18n::ActionSNMPTrap.Description", image="SNMP.svg", categoryDescription="i18n:org.apache.hop.workflow:ActionCategory.Category.Utility", keywords={"i18n::ActionSNMPTrap.keyword"}, documentationUrl="/workflow/actions/snmptrap.html")
public class ActionSNMPTrap
extends ActionBase
implements Cloneable,
IAction {
    private static final Class<?> PKG = ActionSNMPTrap.class;
    @HopMetadataProperty(key="servername")
    private String serverName = null;
    @HopMetadataProperty(key="port")
    private String port = "162";
    @HopMetadataProperty(key="timeout")
    private String timeout = "5000";
    @HopMetadataProperty(key="nrretry")
    private String nrretry = "1";
    @HopMetadataProperty(key="comstring")
    private String comString = "public";
    @HopMetadataProperty(key="message")
    private String message = null;
    @HopMetadataProperty(key="oid")
    private String oid = null;
    @HopMetadataProperty(key="targettype")
    private String targettype = targetTypeCode[0];
    @HopMetadataProperty(key="user")
    private String user = null;
    @HopMetadataProperty(key="passphrase")
    private String passphrase = null;
    @HopMetadataProperty(key="engineid")
    private String engineid = null;
    private static final int DEFAULT_RETRIES = 1;
    private static final int DEFAULT_TIME_OUT = 5000;
    public static final int DEFAULT_PORT = 162;
    protected static final String[] targetTypeDesc = new String[]{BaseMessages.getString(PKG, (String)"ActionSNMPTrap.TargetType.Community", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionSNMPTrap.TargetType.User", (String[])new String[0])};
    protected static final String[] targetTypeCode = new String[]{"community", "user"};

    public ActionSNMPTrap(String n) {
        super(n, "");
    }

    public ActionSNMPTrap() {
        this("");
    }

    public String getTargetTypeDesc(String tt) {
        if (Utils.isEmpty((CharSequence)tt)) {
            return targetTypeDesc[0];
        }
        if (tt.equalsIgnoreCase(targetTypeCode[1])) {
            return targetTypeDesc[1];
        }
        return targetTypeDesc[0];
    }

    public String getTargetTypeCode(String tt) {
        if (tt == null) {
            return targetTypeCode[0];
        }
        if (tt.equals(targetTypeDesc[1])) {
            return targetTypeCode[1];
        }
        return targetTypeCode[0];
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public String getOid() {
        return this.oid;
    }

    public void setOid(String oid) {
        this.oid = oid;
    }

    public String getComString() {
        return this.comString;
    }

    public void setComString(String comString) {
        this.comString = comString;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getUser() {
        return this.user;
    }

    public void setPassphrase(String passphrase) {
        this.passphrase = passphrase;
    }

    public String getPassphrase() {
        return this.passphrase;
    }

    public void setEngineid(String engineid) {
        this.engineid = engineid;
    }

    public String getEngineid() {
        return this.engineid;
    }

    public String getTargettype() {
        return this.targettype;
    }

    public void setTargettype(String targettypein) {
        this.targettype = this.getTargetTypeCode(targettypein);
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getMessage() {
        return this.message;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public void setTimeout(String timeout) {
        this.timeout = timeout;
    }

    public String getTimeout() {
        return this.timeout;
    }

    public void setNrretry(String nrretry) {
        this.nrretry = nrretry;
    }

    public String getNrretry() {
        return this.nrretry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result execute(Result previousResult, int nr) {
        Result result = previousResult;
        result.setNrErrors(1L);
        result.setResult(false);
        String servername = this.resolve(this.serverName);
        int nrPort = Const.toInt((String)this.resolve(this.port), (int)162);
        String resolvedOid = this.resolve(this.oid);
        int timeOut = Const.toInt((String)this.resolve(this.timeout), (int)5000);
        int retry = Const.toInt((String)this.resolve(this.nrretry), (int)1);
        String messageString = this.resolve(this.message);
        Snmp snmp = null;
        try {
            DefaultUdpTransportMapping transMap = new DefaultUdpTransportMapping();
            snmp = new Snmp((TransportMapping)transMap);
            UdpAddress udpAddress = new UdpAddress(InetAddress.getByName(servername), nrPort);
            ResponseEvent response = null;
            if (this.targettype.equals(targetTypeCode[0])) {
                String community = this.resolve(this.comString);
                CommunityTarget target = new CommunityTarget();
                PDUv1 pdu1 = new PDUv1();
                transMap.listen();
                target.setCommunity(new OctetString(community));
                target.setVersion(0);
                target.setAddress((Address)udpAddress);
                if (target.getAddress().isValid()) {
                    if (this.log.isDebug()) {
                        this.logDebug("Valid IP address");
                    }
                } else {
                    throw new HopException("Invalid IP address");
                }
                target.setRetries(retry);
                target.setTimeout((long)timeOut);
                pdu1.setGenericTrap(6);
                pdu1.setSpecificTrap(6);
                pdu1.setEnterprise(new OID(resolvedOid));
                pdu1.add(new VariableBinding(new OID(resolvedOid), (Variable)new OctetString(messageString)));
                response = snmp.send((PDU)pdu1, (Target)target);
            } else {
                String userName = this.resolve(this.user);
                String passPhrase = this.resolve(this.passphrase);
                String engineID = this.resolve(this.engineid);
                UserTarget usertarget = new UserTarget();
                transMap.listen();
                usertarget.setAddress((Address)udpAddress);
                if (usertarget.getAddress().isValid()) {
                    if (this.log.isDebug()) {
                        this.logDebug("Valid IP address");
                    }
                } else {
                    throw new HopException("Invalid IP address");
                }
                usertarget.setRetries(retry);
                usertarget.setTimeout((long)timeOut);
                usertarget.setVersion(3);
                usertarget.setSecurityLevel(3);
                usertarget.setSecurityName(new OctetString("MD5DES"));
                UsmUser uu = new UsmUser(new OctetString(userName), AuthMD5.ID, new OctetString(passPhrase), PrivDES.ID, new OctetString(passPhrase));
                USM usm = snmp.getUSM();
                if (usm == null) {
                    throw new HopException("Null Usm");
                }
                usm = new USM(SecurityProtocols.getInstance(), new OctetString(MPv3.createLocalEngineID()), 0);
                usm.addUser(new OctetString(userName), uu);
                if (this.log.isDebug()) {
                    this.logDebug("Valid Usm");
                }
                ScopedPDU pdu = new ScopedPDU();
                pdu.add(new VariableBinding(new OID(resolvedOid), (Variable)new OctetString(messageString)));
                pdu.setType(-89);
                if (!Utils.isEmpty((CharSequence)engineID)) {
                    pdu.setContextEngineID(new OctetString(engineID));
                }
                response = snmp.send((PDU)pdu, (Target)usertarget);
            }
            if (response != null && this.log.isDebug()) {
                this.logDebug("Received response from: " + response.getPeerAddress() + response.toString());
            }
            result.setNrErrors(0L);
            result.setResult(true);
        }
        catch (Exception e) {
            this.logError(BaseMessages.getString(PKG, (String)"ActionSNMPTrap.ErrorGetting", (String[])new String[0]), e);
        }
        finally {
            try {
                if (snmp != null) {
                    snmp.close();
                }
            }
            catch (Exception exception) {}
        }
        return result;
    }

    public boolean isEvaluation() {
        return true;
    }
}

