/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.kinesis;

import java.io.Serializable;
import org.apache.beam.sdk.io.kinesis.KinesisRecord;
import org.apache.beam.sdk.io.kinesis.WatermarkParameters;
import org.apache.beam.sdk.io.kinesis.WatermarkPolicy;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Ordering;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;

public interface WatermarkPolicyFactory
extends Serializable {
    public @UnknownKeyFor @NonNull @Initialized WatermarkPolicy createWatermarkPolicy();

    public static @UnknownKeyFor @NonNull @Initialized WatermarkPolicyFactory withArrivalTimePolicy() {
        return ArrivalTimeWatermarkPolicy::new;
    }

    public static @UnknownKeyFor @NonNull @Initialized WatermarkPolicyFactory withArrivalTimePolicy(@UnknownKeyFor @NonNull @Initialized Duration watermarkIdleDurationThreshold) {
        return () -> new ArrivalTimeWatermarkPolicy(watermarkIdleDurationThreshold);
    }

    public static @UnknownKeyFor @NonNull @Initialized WatermarkPolicyFactory withProcessingTimePolicy() {
        return ProcessingTimeWatermarkPolicy::new;
    }

    public static @UnknownKeyFor @NonNull @Initialized WatermarkPolicyFactory withCustomWatermarkPolicy(@UnknownKeyFor @NonNull @Initialized WatermarkParameters watermarkParameters) {
        return () -> new CustomWatermarkPolicy(watermarkParameters);
    }

    public static class ProcessingTimeWatermarkPolicy
    implements WatermarkPolicy {
        @Override
        public @UnknownKeyFor @NonNull @Initialized Instant getWatermark() {
            return Instant.now();
        }

        @Override
        public void update(@UnknownKeyFor @NonNull @Initialized KinesisRecord record) {
        }
    }

    public static class CustomWatermarkPolicy
    implements WatermarkPolicy {
        private @UnknownKeyFor @NonNull @Initialized WatermarkParameters watermarkParameters;

        CustomWatermarkPolicy(@UnknownKeyFor @NonNull @Initialized WatermarkParameters watermarkParameters) {
            this.watermarkParameters = watermarkParameters;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Instant getWatermark() {
            Instant newWatermark;
            Instant now = Instant.now();
            Instant watermarkIdleThreshold = now.minus((ReadableDuration)this.watermarkParameters.getWatermarkIdleDurationThreshold());
            Instant instant = newWatermark = this.watermarkParameters.getLastUpdateTime().isBefore((ReadableInstant)watermarkIdleThreshold) ? watermarkIdleThreshold : this.watermarkParameters.getEventTime();
            if (newWatermark.isAfter((ReadableInstant)this.watermarkParameters.getCurrentWatermark())) {
                this.watermarkParameters = this.watermarkParameters.toBuilder().setCurrentWatermark(newWatermark).build();
            }
            return this.watermarkParameters.getCurrentWatermark();
        }

        @Override
        public void update(@UnknownKeyFor @NonNull @Initialized KinesisRecord record) {
            this.watermarkParameters = this.watermarkParameters.toBuilder().setEventTime((Instant)Ordering.natural().max((Object)this.watermarkParameters.getEventTime(), (Object)((Instant)this.watermarkParameters.getTimestampFn().apply((Object)record)))).setLastUpdateTime(Instant.now()).build();
        }
    }

    public static class ArrivalTimeWatermarkPolicy
    implements WatermarkPolicy {
        private final @UnknownKeyFor @NonNull @Initialized CustomWatermarkPolicy watermarkPolicy;

        ArrivalTimeWatermarkPolicy() {
            this.watermarkPolicy = new CustomWatermarkPolicy(WatermarkParameters.create().withTimestampFn((SerializableFunction<KinesisRecord, Instant>)((SerializableFunction & Serializable)KinesisRecord::getApproximateArrivalTimestamp)));
        }

        ArrivalTimeWatermarkPolicy(@UnknownKeyFor @NonNull @Initialized Duration idleDurationThreshold) {
            WatermarkParameters watermarkParameters = WatermarkParameters.create().withTimestampFn((SerializableFunction<KinesisRecord, Instant>)((SerializableFunction & Serializable)KinesisRecord::getApproximateArrivalTimestamp)).withWatermarkIdleDurationThreshold(idleDurationThreshold);
            this.watermarkPolicy = new CustomWatermarkPolicy(watermarkParameters);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Instant getWatermark() {
            return this.watermarkPolicy.getWatermark();
        }

        @Override
        public void update(@UnknownKeyFor @NonNull @Initialized KinesisRecord record) {
            this.watermarkPolicy.update(record);
        }
    }
}

