/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io;

import java.io.IOException;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.apache.beam.sdk.coders.AvroCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.DefaultCoder;
import org.apache.beam.sdk.coders.VarLongCoder;
import org.apache.beam.sdk.io.BoundedSource;
import org.apache.beam.sdk.io.OffsetBasedSource;
import org.apache.beam.sdk.io.UnboundedSource;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.SourceMetrics;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.joda.time.Duration;
import org.joda.time.Instant;

public class CountingSource {
    @Deprecated
    public static @UnknownKeyFor @NonNull @Initialized BoundedSource<@UnknownKeyFor @NonNull @Initialized Long> upTo(@UnknownKeyFor @NonNull @Initialized long numElements) {
        Preconditions.checkArgument((numElements >= 0L ? 1 : 0) != 0, (String)"numElements (%s) must be greater than or equal to 0", (long)numElements);
        return new BoundedCountingSource(0L, numElements);
    }

    static @UnknownKeyFor @NonNull @Initialized BoundedSource<@UnknownKeyFor @NonNull @Initialized Long> createSourceForSubrange(@UnknownKeyFor @NonNull @Initialized long startIndex, @UnknownKeyFor @NonNull @Initialized long endIndex) {
        Preconditions.checkArgument((endIndex >= startIndex ? 1 : 0) != 0, (String)"endIndex (%s) must be greater than or equal to startIndex (%s)", (long)endIndex, (long)startIndex);
        return new BoundedCountingSource(startIndex, endIndex);
    }

    static @UnknownKeyFor @NonNull @Initialized UnboundedCountingSource createUnboundedFrom(@UnknownKeyFor @NonNull @Initialized long start) {
        return new UnboundedCountingSource(start, 1L, 1L, Duration.ZERO, new NowTimestampFn());
    }

    @Deprecated
    public static @UnknownKeyFor @NonNull @Initialized UnboundedSource<@UnknownKeyFor @NonNull @Initialized Long, @UnknownKeyFor @NonNull @Initialized CounterMark> unbounded() {
        return CountingSource.unboundedWithTimestampFn(new NowTimestampFn());
    }

    @Deprecated
    public static @UnknownKeyFor @NonNull @Initialized UnboundedSource<@UnknownKeyFor @NonNull @Initialized Long, @UnknownKeyFor @NonNull @Initialized CounterMark> unboundedWithTimestampFn(@UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Long, @UnknownKeyFor @NonNull @Initialized Instant> timestampFn) {
        return new UnboundedCountingSource(0L, 1L, 1L, Duration.ZERO, timestampFn);
    }

    private CountingSource() {
    }

    @DefaultCoder(value=AvroCoder.class)
    public static class CounterMark
    implements UnboundedSource.CheckpointMark {
        private final @UnknownKeyFor @NonNull @Initialized long lastEmitted;
        private final @UnknownKeyFor @NonNull @Initialized Instant startTime;

        public CounterMark(@UnknownKeyFor @NonNull @Initialized long lastEmitted, @UnknownKeyFor @NonNull @Initialized Instant startTime) {
            this.lastEmitted = lastEmitted;
            this.startTime = startTime;
        }

        public @UnknownKeyFor @NonNull @Initialized long getLastEmitted() {
            return this.lastEmitted;
        }

        public @UnknownKeyFor @NonNull @Initialized Instant getStartTime() {
            return this.startTime;
        }

        private CounterMark() {
            this.lastEmitted = 0L;
            this.startTime = Instant.now();
        }

        @Override
        public void finalizeCheckpoint() throws @UnknownKeyFor @NonNull @Initialized IOException {
        }
    }

    private static class UnboundedCountingReader
    extends UnboundedSource.UnboundedReader<Long> {
        private @UnknownKeyFor @NonNull @Initialized UnboundedCountingSource source;
        private @UnknownKeyFor @NonNull @Initialized long current;
        private @Nullable @UnknownKeyFor @Initialized Instant currentTimestamp;
        private @Nullable @UnknownKeyFor @Initialized Instant firstStarted;
        private final @UnknownKeyFor @NonNull @Initialized Counter elementsRead = SourceMetrics.elementsRead();

        public UnboundedCountingReader(@UnknownKeyFor @NonNull @Initialized UnboundedCountingSource source, @UnknownKeyFor @NonNull @Initialized CounterMark mark) {
            this.source = source;
            if (mark == null) {
                this.current = source.start - source.stride;
            } else {
                this.current = mark.getLastEmitted();
                this.firstStarted = mark.getStartTime();
            }
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized boolean start() throws @UnknownKeyFor @NonNull @Initialized IOException {
            if (this.firstStarted == null) {
                this.firstStarted = Instant.now();
            }
            return this.advance();
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized boolean advance() throws @UnknownKeyFor @NonNull @Initialized IOException {
            if (Long.MAX_VALUE - this.source.stride < this.current) {
                return false;
            }
            long nextValue = this.current + this.source.stride;
            if (this.expectedValue() < nextValue) {
                return false;
            }
            this.elementsRead.inc();
            this.current = nextValue;
            this.currentTimestamp = (Instant)this.source.timestampFn.apply(this.current);
            return true;
        }

        private @UnknownKeyFor @NonNull @Initialized long expectedValue() {
            if (this.source.period.getMillis() == 0L || this.firstStarted == null) {
                return Long.MAX_VALUE;
            }
            double periodsElapsed = (double)(Instant.now().getMillis() - this.firstStarted.getMillis()) / (double)this.source.period.getMillis();
            return (long)((double)this.source.elementsPerPeriod * periodsElapsed);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Instant getWatermark() {
            return (Instant)this.source.timestampFn.apply(this.current);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized CounterMark getCheckpointMark() {
            return new CounterMark(this.current, this.firstStarted);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized UnboundedSource<@UnknownKeyFor @NonNull @Initialized Long, @UnknownKeyFor @NonNull @Initialized CounterMark> getCurrentSource() {
            return this.source;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Long getCurrent() throws @UnknownKeyFor @NonNull @Initialized NoSuchElementException {
            return this.current;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Instant getCurrentTimestamp() throws @UnknownKeyFor @NonNull @Initialized NoSuchElementException {
            return this.currentTimestamp;
        }

        @Override
        public void close() throws @UnknownKeyFor @NonNull @Initialized IOException {
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized long getSplitBacklogBytes() {
            long expected = this.expectedValue();
            long backlogElements = (expected - this.current) / this.source.stride;
            return Math.max(0L, 8L * backlogElements);
        }
    }

    static class UnboundedCountingSource
    extends UnboundedSource<Long, CounterMark> {
        private final @UnknownKeyFor @NonNull @Initialized long start;
        private final @UnknownKeyFor @NonNull @Initialized long stride;
        private final @UnknownKeyFor @NonNull @Initialized long elementsPerPeriod;
        private final @UnknownKeyFor @NonNull @Initialized Duration period;
        private final @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Long, @UnknownKeyFor @NonNull @Initialized Instant> timestampFn;

        private UnboundedCountingSource(@UnknownKeyFor @NonNull @Initialized long start, @UnknownKeyFor @NonNull @Initialized long stride, @UnknownKeyFor @NonNull @Initialized long elementsPerPeriod, @UnknownKeyFor @NonNull @Initialized Duration period, @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Long, @UnknownKeyFor @NonNull @Initialized Instant> timestampFn) {
            this.start = start;
            this.stride = stride;
            Preconditions.checkArgument((elementsPerPeriod > 0L ? 1 : 0) != 0, (String)"Must produce at least one element per period, got %s", (long)elementsPerPeriod);
            this.elementsPerPeriod = elementsPerPeriod;
            Preconditions.checkArgument((period.getMillis() >= 0L ? 1 : 0) != 0, (String)"Must have a non-negative period length, got %s", (Object)period);
            this.period = period;
            this.timestampFn = timestampFn;
        }

        public @UnknownKeyFor @NonNull @Initialized UnboundedCountingSource withRate(@UnknownKeyFor @NonNull @Initialized long elementsPerPeriod, @UnknownKeyFor @NonNull @Initialized Duration period) {
            return new UnboundedCountingSource(this.start, this.stride, elementsPerPeriod, period, this.timestampFn);
        }

        public @UnknownKeyFor @NonNull @Initialized UnboundedCountingSource withTimestampFn(@UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Long, @UnknownKeyFor @NonNull @Initialized Instant> timestampFn) {
            Preconditions.checkNotNull(timestampFn);
            return new UnboundedCountingSource(this.start, this.stride, this.elementsPerPeriod, this.period, timestampFn);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized List<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized UnboundedSource<@UnknownKeyFor @NonNull @Initialized Long, @UnknownKeyFor @NonNull @Initialized CounterMark>> split(@UnknownKeyFor @NonNull @Initialized int desiredNumSplits, @UnknownKeyFor @NonNull @Initialized PipelineOptions options) throws @UnknownKeyFor @NonNull @Initialized Exception {
            long newStride = this.stride * (long)desiredNumSplits;
            ImmutableList.Builder splits = ImmutableList.builder();
            for (int i = 0; i < desiredNumSplits; ++i) {
                splits.add((Object)new UnboundedCountingSource(this.start + (long)i * this.stride, newStride, this.elementsPerPeriod, this.period, this.timestampFn));
            }
            return splits.build();
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized UnboundedSource.UnboundedReader<@UnknownKeyFor @NonNull @Initialized Long> createReader(@UnknownKeyFor @NonNull @Initialized PipelineOptions options, @UnknownKeyFor @NonNull @Initialized CounterMark checkpointMark) {
            return new UnboundedCountingReader(this, checkpointMark);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized CounterMark> getCheckpointMarkCoder() {
            return AvroCoder.of(CounterMark.class);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized Long> getOutputCoder() {
            return VarLongCoder.of();
        }

        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object other) {
            if (!(other instanceof UnboundedCountingSource)) {
                return false;
            }
            UnboundedCountingSource that = (UnboundedCountingSource)other;
            return this.start == that.start && this.stride == that.stride && this.elementsPerPeriod == that.elementsPerPeriod && Objects.equals(this.period, that.period) && Objects.equals(this.timestampFn, that.timestampFn);
        }

        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            return Objects.hash(this.start, this.stride, this.elementsPerPeriod, this.period, this.timestampFn);
        }
    }

    private static class BoundedCountingReader
    extends OffsetBasedSource.OffsetBasedReader<Long> {
        private @UnknownKeyFor @NonNull @Initialized long current;
        private final @UnknownKeyFor @NonNull @Initialized Counter elementsRead = SourceMetrics.elementsRead();

        public BoundedCountingReader(@UnknownKeyFor @NonNull @Initialized OffsetBasedSource<@UnknownKeyFor @NonNull @Initialized Long> source) {
            super(source);
        }

        @Override
        protected @UnknownKeyFor @NonNull @Initialized long getCurrentOffset() throws @UnknownKeyFor @NonNull @Initialized NoSuchElementException {
            return this.current;
        }

        @Override
        public synchronized @UnknownKeyFor @NonNull @Initialized long getSplitPointsRemaining() {
            return Math.max(0L, this.getCurrentSource().getEndOffset() - this.current);
        }

        @Override
        public synchronized @UnknownKeyFor @NonNull @Initialized BoundedCountingSource getCurrentSource() {
            return (BoundedCountingSource)super.getCurrentSource();
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Long getCurrent() throws @UnknownKeyFor @NonNull @Initialized NoSuchElementException {
            return this.current;
        }

        @Override
        protected @UnknownKeyFor @NonNull @Initialized boolean startImpl() throws @UnknownKeyFor @NonNull @Initialized IOException {
            this.current = this.getCurrentSource().getStartOffset();
            return true;
        }

        @Override
        protected @UnknownKeyFor @NonNull @Initialized boolean advanceImpl() throws @UnknownKeyFor @NonNull @Initialized IOException {
            this.elementsRead.inc();
            ++this.current;
            return true;
        }

        @Override
        public void close() throws @UnknownKeyFor @NonNull @Initialized IOException {
        }
    }

    private static class BoundedCountingSource
    extends OffsetBasedSource<Long> {
        public BoundedCountingSource(@UnknownKeyFor @NonNull @Initialized long start, @UnknownKeyFor @NonNull @Initialized long end) {
            super(start, end, 1L);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized long getBytesPerOffset() {
            return 8L;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized long getMaxEndOffset(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) throws @UnknownKeyFor @NonNull @Initialized Exception {
            return this.getEndOffset();
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized OffsetBasedSource<@UnknownKeyFor @NonNull @Initialized Long> createSourceForSubrange(@UnknownKeyFor @NonNull @Initialized long start, @UnknownKeyFor @NonNull @Initialized long end) {
            return new BoundedCountingSource(start, end);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized BoundedSource.BoundedReader<@UnknownKeyFor @NonNull @Initialized Long> createReader(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) throws @UnknownKeyFor @NonNull @Initialized IOException {
            return new BoundedCountingReader(this);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized Long> getOutputCoder() {
            return VarLongCoder.of();
        }

        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object other) {
            if (!(other instanceof BoundedCountingSource)) {
                return false;
            }
            BoundedCountingSource that = (BoundedCountingSource)other;
            return this.getStartOffset() == that.getStartOffset() && this.getEndOffset() == that.getEndOffset();
        }

        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            return Objects.hash(this.getStartOffset(), (int)this.getEndOffset());
        }
    }

    static class NowTimestampFn
    implements SerializableFunction<Long, Instant> {
        NowTimestampFn() {
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Instant apply(@UnknownKeyFor @NonNull @Initialized Long input) {
            return Instant.now();
        }

        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object other) {
            return other instanceof NowTimestampFn;
        }

        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            return this.getClass().hashCode();
        }
    }
}

