/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms.windowing;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.transforms.windowing.IntervalWindow;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;

@Internal
public class MergeOverlappingIntervalWindows {
    public static void mergeWindows(/*
     * Issues handling annotations - annotations may be inaccurate
     */
     @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @Nullable @Initialized @NonNull @Initialized @NonNull @Initialized WindowFn. @UnknownKeyFor @NonNull @Initialized MergeContext c) throws @UnknownKeyFor @NonNull @Initialized Exception {
        ArrayList<IntervalWindow> sortedWindows = new ArrayList<IntervalWindow>();
        for (IntervalWindow window : c.windows()) {
            sortedWindows.add(window);
        }
        Collections.sort(sortedWindows);
        ArrayList<MergeCandidate> merges = new ArrayList<MergeCandidate>();
        MergeCandidate current = new MergeCandidate();
        for (IntervalWindow window : sortedWindows) {
            if (current.intersects(window)) {
                current.add(window);
                continue;
            }
            merges.add(current);
            current = new MergeCandidate(window);
        }
        merges.add(current);
        for (MergeCandidate merge : merges) {
            merge.apply(c);
        }
    }

    private static class MergeCandidate {
        private @Nullable @UnknownKeyFor @Initialized IntervalWindow union;
        private final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized IntervalWindow> parts;

        public MergeCandidate() {
            this.union = null;
            this.parts = new ArrayList<IntervalWindow>();
        }

        public MergeCandidate(@UnknownKeyFor @NonNull @Initialized IntervalWindow window) {
            this.union = window;
            this.parts = new ArrayList<IntervalWindow>(Arrays.asList(window));
        }

        public @UnknownKeyFor @NonNull @Initialized boolean intersects(@UnknownKeyFor @NonNull @Initialized IntervalWindow window) {
            return this.union == null || this.union.intersects(window);
        }

        public void add(@UnknownKeyFor @NonNull @Initialized IntervalWindow window) {
            this.union = this.union == null ? window : this.union.span(window);
            this.parts.add(window);
        }

        public void apply(/*
         * Issues handling annotations - annotations may be inaccurate
         */
         @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @Nullable @Initialized @NonNull @Initialized @NonNull @Initialized WindowFn. @UnknownKeyFor @NonNull @Initialized MergeContext c) throws @UnknownKeyFor @NonNull @Initialized Exception {
            if (this.parts.size() > 1) {
                c.merge(this.parts, this.union);
            }
        }

        @SideEffectFree
        public @UnknownKeyFor @NonNull @Initialized String toString() {
            return "MergeCandidate[union=" + this.union + ", parts=" + this.parts + "]";
        }
    }
}

