/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.veneer.repackaged.io.opencensus.contrib.resource.util;

import com.google.bigtable.veneer.repackaged.io.opencensus.contrib.resource.util.AwsIdentityDocUtils;
import com.google.bigtable.veneer.repackaged.io.opencensus.contrib.resource.util.GcpMetadataConfig;
import com.google.bigtable.veneer.repackaged.io.opencensus.contrib.resource.util.ResourceUtils;
import com.google.bigtable.veneer.repackaged.io.opencensus.resource.Resource;
import com.google.common.base.Preconditions;
import java.util.LinkedHashMap;

public final class HostResource {
    public static final String TYPE = "host";
    public static final String HOSTNAME_KEY = "host.hostname";
    public static final String NAME_KEY = "host.name";
    public static final String ID_KEY = "host.id";
    public static final String TYPE_KEY = "host.type";

    public static Resource create(String hostname, String name, String id, String type) {
        LinkedHashMap<String, String> labels = new LinkedHashMap<String, String>();
        labels.put(HOSTNAME_KEY, (String)Preconditions.checkNotNull((Object)hostname, (Object)"hostname"));
        labels.put(NAME_KEY, (String)Preconditions.checkNotNull((Object)name, (Object)"name"));
        labels.put(ID_KEY, (String)Preconditions.checkNotNull((Object)id, (Object)"id"));
        labels.put(TYPE_KEY, (String)Preconditions.checkNotNull((Object)type, (Object)"type"));
        return Resource.create(TYPE, labels);
    }

    static Resource detect() {
        if (AwsIdentityDocUtils.isRunningOnAws()) {
            return HostResource.create("", "", AwsIdentityDocUtils.getInstanceId(), AwsIdentityDocUtils.getMachineType());
        }
        if (GcpMetadataConfig.isRunningOnGcp()) {
            return HostResource.create(GcpMetadataConfig.getInstanceHostname(), GcpMetadataConfig.getInstanceName(), GcpMetadataConfig.getInstanceId(), GcpMetadataConfig.getMachineType());
        }
        return ResourceUtils.EMPTY_RESOURCE;
    }

    private HostResource() {
    }
}

