/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.ipc.stats;

import org.apache.avro.ipc.stats.Histogram;

class FloatHistogram<B>
extends Histogram<B, Float> {
    private float runningSum;
    private float runningSumOfSquares;

    public FloatHistogram(Histogram.Segmenter<B, Float> segmenter) {
        super(segmenter);
    }

    @Override
    public void add(Float value) {
        super.add(value);
        this.runningSum += value.floatValue();
        this.runningSumOfSquares += value.floatValue() * value.floatValue();
    }

    public float getMean() {
        if (this.totalCount == 0) {
            return Float.NaN;
        }
        return this.runningSum / (float)this.totalCount;
    }

    public float getUnbiasedStdDev() {
        if (this.totalCount <= 1) {
            return Float.NaN;
        }
        float mean = this.getMean();
        return (float)Math.sqrt((this.runningSumOfSquares - (float)this.totalCount * mean * mean) / (float)(this.totalCount - 1));
    }
}

