/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.core.data;

import com.datastax.oss.driver.api.core.data.AccessibleByIndex;
import com.datastax.oss.driver.api.core.data.CqlDuration;
import com.datastax.oss.driver.api.core.data.CqlVector;
import com.datastax.oss.driver.api.core.data.TupleValue;
import com.datastax.oss.driver.api.core.data.UdtValue;
import com.datastax.oss.driver.api.core.metadata.token.Token;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.codec.PrimitiveBooleanCodec;
import com.datastax.oss.driver.api.core.type.codec.PrimitiveByteCodec;
import com.datastax.oss.driver.api.core.type.codec.PrimitiveDoubleCodec;
import com.datastax.oss.driver.api.core.type.codec.PrimitiveFloatCodec;
import com.datastax.oss.driver.api.core.type.codec.PrimitiveIntCodec;
import com.datastax.oss.driver.api.core.type.codec.PrimitiveLongCodec;
import com.datastax.oss.driver.api.core.type.codec.PrimitiveShortCodec;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.driver.internal.core.metadata.token.ByteOrderedToken;
import com.datastax.oss.driver.internal.core.metadata.token.Murmur3Token;
import com.datastax.oss.driver.internal.core.metadata.token.RandomToken;
import edu.umd.cs.findbugs.annotations.CheckReturnValue;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public interface SettableByIndex<SelfT extends SettableByIndex<SelfT>>
extends AccessibleByIndex {
    @NonNull
    @CheckReturnValue
    public SelfT setBytesUnsafe(int var1, @Nullable ByteBuffer var2);

    @NonNull
    @CheckReturnValue
    default public SelfT setToNull(int i) {
        return this.setBytesUnsafe(i, null);
    }

    @NonNull
    @CheckReturnValue
    default public <ValueT> SelfT set(int i, @Nullable ValueT v, @NonNull TypeCodec<ValueT> codec) {
        return this.setBytesUnsafe(i, codec.encode(v, this.protocolVersion()));
    }

    @NonNull
    @CheckReturnValue
    default public <ValueT> SelfT set(int i, @Nullable ValueT v, @NonNull GenericType<ValueT> targetType) {
        DataType cqlType = this.getType(i);
        TypeCodec<GenericType<ValueT>> codec = this.codecRegistry().codecFor(cqlType, targetType);
        return this.set(i, v, codec);
    }

    @NonNull
    @CheckReturnValue
    default public <ValueT> SelfT set(int i, @Nullable ValueT v, @NonNull Class<ValueT> targetClass) {
        DataType cqlType = this.getType(i);
        TypeCodec<Class<ValueT>> codec = this.codecRegistry().codecFor(cqlType, targetClass);
        return this.set(i, v, codec);
    }

    @NonNull
    @CheckReturnValue
    default public SelfT setBoolean(int i, boolean v) {
        DataType cqlType = this.getType(i);
        TypeCodec<Class<Boolean>> codec = this.codecRegistry().codecFor(cqlType, Boolean.class);
        return codec instanceof PrimitiveBooleanCodec ? this.setBytesUnsafe(i, ((PrimitiveBooleanCodec)codec).encodePrimitive(v, this.protocolVersion())) : this.set(i, Boolean.valueOf(v), codec);
    }

    @Deprecated
    @NonNull
    @CheckReturnValue
    default public SelfT setBool(int i, boolean v) {
        return this.setBoolean(i, v);
    }

    @NonNull
    @CheckReturnValue
    default public SelfT setByte(int i, byte v) {
        DataType cqlType = this.getType(i);
        TypeCodec<Class<Byte>> codec = this.codecRegistry().codecFor(cqlType, Byte.class);
        return codec instanceof PrimitiveByteCodec ? this.setBytesUnsafe(i, ((PrimitiveByteCodec)codec).encodePrimitive(v, this.protocolVersion())) : this.set(i, Byte.valueOf(v), codec);
    }

    @NonNull
    @CheckReturnValue
    default public SelfT setDouble(int i, double v) {
        DataType cqlType = this.getType(i);
        TypeCodec<Class<Double>> codec = this.codecRegistry().codecFor(cqlType, Double.class);
        return codec instanceof PrimitiveDoubleCodec ? this.setBytesUnsafe(i, ((PrimitiveDoubleCodec)codec).encodePrimitive(v, this.protocolVersion())) : this.set(i, Double.valueOf(v), codec);
    }

    @NonNull
    @CheckReturnValue
    default public SelfT setFloat(int i, float v) {
        DataType cqlType = this.getType(i);
        TypeCodec<Class<Float>> codec = this.codecRegistry().codecFor(cqlType, Float.class);
        return codec instanceof PrimitiveFloatCodec ? this.setBytesUnsafe(i, ((PrimitiveFloatCodec)codec).encodePrimitive(v, this.protocolVersion())) : this.set(i, Float.valueOf(v), codec);
    }

    @NonNull
    @CheckReturnValue
    default public SelfT setInt(int i, int v) {
        DataType cqlType = this.getType(i);
        TypeCodec<Class<Integer>> codec = this.codecRegistry().codecFor(cqlType, Integer.class);
        return codec instanceof PrimitiveIntCodec ? this.setBytesUnsafe(i, ((PrimitiveIntCodec)codec).encodePrimitive(v, this.protocolVersion())) : this.set(i, Integer.valueOf(v), codec);
    }

    @NonNull
    @CheckReturnValue
    default public SelfT setLong(int i, long v) {
        DataType cqlType = this.getType(i);
        TypeCodec<Class<Long>> codec = this.codecRegistry().codecFor(cqlType, Long.class);
        return codec instanceof PrimitiveLongCodec ? this.setBytesUnsafe(i, ((PrimitiveLongCodec)codec).encodePrimitive(v, this.protocolVersion())) : this.set(i, Long.valueOf(v), codec);
    }

    @NonNull
    @CheckReturnValue
    default public SelfT setShort(int i, short v) {
        DataType cqlType = this.getType(i);
        TypeCodec<Class<Short>> codec = this.codecRegistry().codecFor(cqlType, Short.class);
        return codec instanceof PrimitiveShortCodec ? this.setBytesUnsafe(i, ((PrimitiveShortCodec)codec).encodePrimitive(v, this.protocolVersion())) : this.set(i, Short.valueOf(v), codec);
    }

    @NonNull
    @CheckReturnValue
    default public SelfT setInstant(int i, @Nullable Instant v) {
        return this.set(i, v, Instant.class);
    }

    @NonNull
    @CheckReturnValue
    default public SelfT setLocalDate(int i, @Nullable LocalDate v) {
        return this.set(i, v, LocalDate.class);
    }

    @NonNull
    @CheckReturnValue
    default public SelfT setLocalTime(int i, @Nullable LocalTime v) {
        return this.set(i, v, LocalTime.class);
    }

    @NonNull
    @CheckReturnValue
    default public SelfT setByteBuffer(int i, @Nullable ByteBuffer v) {
        return this.set(i, v, ByteBuffer.class);
    }

    @NonNull
    @CheckReturnValue
    default public SelfT setString(int i, @Nullable String v) {
        return this.set(i, v, String.class);
    }

    @NonNull
    @CheckReturnValue
    default public SelfT setBigInteger(int i, @Nullable BigInteger v) {
        return this.set(i, v, BigInteger.class);
    }

    @NonNull
    @CheckReturnValue
    default public SelfT setBigDecimal(int i, @Nullable BigDecimal v) {
        return this.set(i, v, BigDecimal.class);
    }

    @NonNull
    @CheckReturnValue
    default public SelfT setUuid(int i, @Nullable UUID v) {
        return this.set(i, v, UUID.class);
    }

    @NonNull
    @CheckReturnValue
    default public SelfT setInetAddress(int i, @Nullable InetAddress v) {
        return this.set(i, v, InetAddress.class);
    }

    @NonNull
    @CheckReturnValue
    default public SelfT setCqlDuration(int i, @Nullable CqlDuration v) {
        return this.set(i, v, CqlDuration.class);
    }

    @NonNull
    @CheckReturnValue
    default public SelfT setCqlVector(int i, @Nullable CqlVector<?> v) {
        return this.set(i, v, CqlVector.class);
    }

    @NonNull
    @CheckReturnValue
    default public SelfT setToken(int i, @NonNull Token v) {
        if (v instanceof Murmur3Token) {
            return this.setLong(i, ((Murmur3Token)v).getValue());
        }
        if (v instanceof ByteOrderedToken) {
            return this.setByteBuffer(i, ((ByteOrderedToken)v).getValue());
        }
        if (v instanceof RandomToken) {
            return this.setBigInteger(i, ((RandomToken)v).getValue());
        }
        throw new IllegalArgumentException("Unsupported token type " + v.getClass());
    }

    @NonNull
    @CheckReturnValue
    default public <ElementT> SelfT setList(int i, @Nullable List<ElementT> v, @NonNull Class<ElementT> elementsClass) {
        return this.set(i, v, GenericType.listOf(elementsClass));
    }

    @NonNull
    @CheckReturnValue
    default public <ElementT> SelfT setSet(int i, @Nullable Set<ElementT> v, @NonNull Class<ElementT> elementsClass) {
        return this.set(i, v, GenericType.setOf(elementsClass));
    }

    @NonNull
    @CheckReturnValue
    default public <KeyT, ValueT> SelfT setMap(int i, @Nullable Map<KeyT, ValueT> v, @NonNull Class<KeyT> keyClass, @NonNull Class<ValueT> valueClass) {
        return this.set(i, v, GenericType.mapOf(keyClass, valueClass));
    }

    @NonNull
    @CheckReturnValue
    default public SelfT setUdtValue(int i, @Nullable UdtValue v) {
        return this.set(i, v, UdtValue.class);
    }

    @NonNull
    @CheckReturnValue
    default public SelfT setTupleValue(int i, @Nullable TupleValue v) {
        return this.set(i, v, TupleValue.class);
    }
}

