/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.file;

import com.google.common.base.Preconditions;
import java.util.List;
import org.apache.hop.core.fileinput.FileInputList;
import org.apache.hop.core.injection.InjectionDeep;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.file.BaseFileErrorHandling;
import org.apache.hop.pipeline.transforms.file.BaseFileField;
import org.apache.hop.pipeline.transforms.file.BaseFileInputAdditionalField;
import org.apache.hop.pipeline.transforms.file.BaseFileInputFiles;
import org.apache.hop.resource.ResourceReference;

public abstract class BaseFileInputMeta<Main extends ITransform, Data extends ITransformData, A extends BaseFileInputAdditionalField, I extends BaseFileInputFiles, F extends BaseFileField>
extends BaseTransformMeta<Main, Data> {
    private static final Class<?> PKG = BaseFileInputMeta.class;
    public static final String[] RequiredFilesCode = new String[]{"N", "Y"};
    public static final String NO = "N";
    public static final String YES = "Y";
    public static final String[] RequiredFilesDesc = new String[]{BaseMessages.getString(PKG, (String)"System.Combo.No", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0])};
    @InjectionDeep
    public I inputFiles;
    @InjectionDeep
    public F[] inputFields;
    @InjectionDeep
    public BaseFileErrorHandling errorHandling = new BaseFileErrorHandling();
    @InjectionDeep
    public A additionalOutputFields;

    public F[] getInputFields() {
        return this.inputFields;
    }

    @Override
    public Object clone() {
        BaseFileInputMeta retval = (BaseFileInputMeta)super.clone();
        retval.inputFiles = (BaseFileInputFiles)((BaseFileInputFiles)this.inputFiles).clone();
        retval.errorHandling = (BaseFileErrorHandling)this.errorHandling.clone();
        retval.additionalOutputFields = (BaseFileInputAdditionalField)((BaseFileInputAdditionalField)this.additionalOutputFields).clone();
        return retval;
    }

    public void inputFiles_fileRequired(String[] fileRequiredin) {
        for (int i = 0; i < fileRequiredin.length; ++i) {
            ((BaseFileInputFiles)this.inputFiles).fileRequired[i] = BaseFileInputMeta.getRequiredFilesCode(fileRequiredin[i]);
        }
    }

    public String[] inputFiles_includeSubFolders() {
        return ((BaseFileInputFiles)this.inputFiles).includeSubFolders;
    }

    public void inputFiles_includeSubFolders(String[] includeSubFoldersin) {
        for (int i = 0; i < includeSubFoldersin.length; ++i) {
            ((BaseFileInputFiles)this.inputFiles).includeSubFolders[i] = BaseFileInputMeta.getRequiredFilesCode(includeSubFoldersin[i]);
        }
    }

    public static String getRequiredFilesCode(String tt) {
        if (tt == null) {
            return RequiredFilesCode[0];
        }
        if (tt.equals(RequiredFilesDesc[1])) {
            return RequiredFilesCode[1];
        }
        return RequiredFilesCode[0];
    }

    public FileInputList getFileInputList(IVariables variables) {
        ((BaseFileInputFiles)this.inputFiles).normalizeAllocation(((BaseFileInputFiles)this.inputFiles).fileName.length);
        return FileInputList.createFileList((IVariables)variables, (String[])((BaseFileInputFiles)this.inputFiles).fileName, (String[])((BaseFileInputFiles)this.inputFiles).fileMask, (String[])((BaseFileInputFiles)this.inputFiles).excludeFileMask, (String[])((BaseFileInputFiles)this.inputFiles).fileRequired, (boolean[])((BaseFileInputFiles)this.inputFiles).includeSubFolderBoolean());
    }

    @Override
    public List<ResourceReference> getResourceDependencies(IVariables variables, TransformMeta transformMeta) {
        return ((BaseFileInputFiles)this.inputFiles).getResourceDependencies(variables, transformMeta);
    }

    public abstract String getEncoding();

    public boolean isAcceptingFilenames() {
        Preconditions.checkNotNull(this.inputFiles);
        return ((BaseFileInputFiles)this.inputFiles).acceptingFilenames;
    }

    public String getAcceptingTransformName() {
        return this.inputFiles == null ? null : ((BaseFileInputFiles)this.inputFiles).acceptingTransformName;
    }

    public String getAcceptingField() {
        return this.inputFiles == null ? null : ((BaseFileInputFiles)this.inputFiles).acceptingField;
    }

    public String[] getFilePaths(IVariables variables, boolean showSamples) {
        FileInputList inputList;
        PipelineMeta parentPipelineMeta;
        TransformMeta parentTransformMeta = this.getParentTransformMeta();
        if (parentTransformMeta != null && (parentPipelineMeta = parentTransformMeta.getParentPipelineMeta()) != null && (inputList = this.getFileInputList(variables)) != null) {
            return inputList.getFileStrings();
        }
        return new String[0];
    }
}

