/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.structuredstreaming.translation.batch;

import java.util.Collection;
import org.apache.beam.runners.spark.structuredstreaming.translation.TransformTranslator;
import org.apache.beam.runners.spark.structuredstreaming.translation.batch.Aggregators;
import org.apache.beam.runners.spark.structuredstreaming.translation.batch.GroupByKeyHelpers;
import org.apache.beam.runners.spark.structuredstreaming.translation.utils.ScalaInterop;
import org.apache.beam.sdk.coders.CannotProvideCoderException;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderRegistry;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.expressions.Aggregator;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import scala.Tuple2;
import scala.collection.TraversableOnce;

class CombinePerKeyTranslatorBatch<@UnknownKeyFor K, @UnknownKeyFor InT, @UnknownKeyFor AccT, @UnknownKeyFor OutT>
extends TransformTranslator<PCollection<KV<K, InT>>, PCollection<KV<K, OutT>>, Combine.PerKey<K, InT, OutT>> {
    CombinePerKeyTranslatorBatch() {
        super(0.2f);
    }

    @Override
    public void translate(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Combine.PerKey<K, InT, OutT> transform, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized TransformTranslator. @UnknownKeyFor @NonNull @Initialized Context cxt) {
        Dataset result;
        WindowingStrategy windowing = ((PCollection)cxt.getInput()).getWindowingStrategy();
        Combine.CombineFn combineFn = (Combine.CombineFn)transform.getFn();
        KvCoder inputCoder = (KvCoder)((PCollection)cxt.getInput()).getCoder();
        KvCoder outputCoder = (KvCoder)((PCollection)cxt.getOutput()).getCoder();
        Encoder keyEnc = cxt.keyEncoderOf(inputCoder);
        Encoder inputEnc = cxt.encoderOf(inputCoder);
        Encoder wvOutputEnc = cxt.windowedEncoder(outputCoder);
        Encoder<AccT> accumEnc = this.accumEncoder(combineFn, inputCoder.getValueCoder(), cxt);
        boolean globalGroupBy = GroupByKeyHelpers.eligibleForGlobalGroupBy(windowing, true);
        boolean groupByWindow = GroupByKeyHelpers.eligibleForGroupByWindow(windowing, true);
        if (globalGroupBy || groupByWindow) {
            Aggregator valueAgg = Aggregators.value(combineFn, KV::getValue, accumEnc, cxt.valueEncoderOf(outputCoder));
            if (globalGroupBy) {
                result = cxt.getDataset((PCollection)cxt.getInput()).groupByKey(GroupByKeyHelpers.valueKey(), keyEnc).mapValues(GroupByKeyHelpers.value(), inputEnc).agg(valueAgg.toColumn()).map(CombinePerKeyTranslatorBatch.globalKV(), wvOutputEnc);
            } else {
                Encoder windowedKeyEnc = cxt.tupleEncoder(cxt.windowEncoder(), keyEnc);
                result = cxt.getDataset((PCollection)cxt.getInput()).flatMap(GroupByKeyHelpers.explodeWindowedKey(GroupByKeyHelpers.value()), cxt.tupleEncoder(windowedKeyEnc, inputEnc)).groupByKey(ScalaInterop.fun1(Tuple2::_1), windowedKeyEnc).mapValues(ScalaInterop.fun1(Tuple2::_2), inputEnc).agg(valueAgg.toColumn()).map(GroupByKeyHelpers.windowedKV(), wvOutputEnc);
            }
        } else {
            Aggregator aggregator = Aggregators.windowedValue(combineFn, GroupByKeyHelpers.valueValue(), windowing, cxt.windowEncoder(), accumEnc, cxt.windowedEncoder(outputCoder.getValueCoder()));
            result = cxt.getDataset((PCollection)cxt.getInput()).groupByKey(GroupByKeyHelpers.valueKey(), keyEnc).agg(aggregator.toColumn()).flatMap(CombinePerKeyTranslatorBatch.explodeWindows(), wvOutputEnc);
        }
        cxt.putDataset((PCollection)cxt.getOutput(), result);
    }

    private static <K, V> @UnknownKeyFor @NonNull @Initialized ScalaInterop.Fun1<@UnknownKeyFor @NonNull @Initialized Tuple2<K, @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized WindowedValue<V>>>, @UnknownKeyFor @NonNull @Initialized TraversableOnce<@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized KV<K, V>>>> explodeWindows() {
        return t -> ScalaInterop.scalaIterator((Iterable)t._2).map(wv -> wv.withValue((Object)KV.of((Object)t._1, (Object)wv.getValue())));
    }

    private static <K, V> @UnknownKeyFor @NonNull @Initialized ScalaInterop.Fun1<@UnknownKeyFor @NonNull @Initialized Tuple2<K, V>, @UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized KV<K, V>>> globalKV() {
        return t -> WindowedValue.valueInGlobalWindow((Object)KV.of((Object)t._1, (Object)t._2));
    }

    private @UnknownKeyFor @NonNull @Initialized Encoder<AccT> accumEncoder(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<InT, AccT, OutT> fn, @UnknownKeyFor @NonNull @Initialized Coder<InT> valueCoder, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized TransformTranslator. @UnknownKeyFor @NonNull @Initialized Context cxt) {
        try {
            CoderRegistry registry = ((PCollection)cxt.getInput()).getPipeline().getCoderRegistry();
            return cxt.encoderOf(fn.getAccumulatorCoder(registry, valueCoder));
        }
        catch (CannotProvideCoderException e) {
            throw new RuntimeException(e);
        }
    }
}

