/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.api.client.util.DateTime;
import com.google.api.core.InternalApi;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.TimestampBound;
import com.google.protobuf.Duration;
import com.google.protobuf.util.Durations;
import java.util.concurrent.TimeUnit;

@InternalApi
public class ReadOnlyStalenessUtil {
    static final TimeUnit[] SUPPORTED_UNITS = new TimeUnit[]{TimeUnit.SECONDS, TimeUnit.MILLISECONDS, TimeUnit.MICROSECONDS, TimeUnit.NANOSECONDS};

    public static Timestamp parseRfc3339(String str) throws SpannerException {
        try {
            DateTime.SecondsAndNanos secondsAndNanos = DateTime.parseRfc3339ToSecondsAndNanos((String)str);
            return Timestamp.ofTimeSecondsAndNanos((long)secondsAndNanos.getSeconds(), (int)secondsAndNanos.getNanos());
        }
        catch (NumberFormatException e) {
            throw SpannerExceptionFactory.newSpannerException(ErrorCode.INVALID_ARGUMENT, String.format("Invalid timestamp: %s", str), e);
        }
    }

    static String getTimeUnitAbbreviation(TimeUnit unit) {
        for (TimeUnitAbbreviation abb : TimeUnitAbbreviation.values()) {
            if (abb.unit != unit) continue;
            return abb.abbreviation;
        }
        throw SpannerExceptionFactory.newSpannerException(ErrorCode.INVALID_ARGUMENT, "Invalid option for time unit: " + (Object)((Object)unit));
    }

    static TimeUnit parseTimeUnit(String unit) {
        for (TimeUnitAbbreviation abb : TimeUnitAbbreviation.values()) {
            if (!abb.abbreviation.equalsIgnoreCase(unit)) continue;
            return abb.unit;
        }
        throw SpannerExceptionFactory.newSpannerException(ErrorCode.INVALID_ARGUMENT, "Invalid option for time unit: " + unit);
    }

    static String timestampBoundToString(TimestampBound staleness) {
        switch (staleness.getMode()) {
            case STRONG: {
                return "STRONG";
            }
            case READ_TIMESTAMP: {
                return "READ_TIMESTAMP " + staleness.getReadTimestamp().toString();
            }
            case MIN_READ_TIMESTAMP: {
                return "MIN_READ_TIMESTAMP " + staleness.getMinReadTimestamp().toString();
            }
            case EXACT_STALENESS: {
                return "EXACT_STALENESS " + ReadOnlyStalenessUtil.durationToString(new GetExactStaleness(staleness));
            }
            case MAX_STALENESS: {
                return "MAX_STALENESS " + ReadOnlyStalenessUtil.durationToString(new MaxStalenessGetter(staleness));
            }
        }
        throw new IllegalStateException("Unknown mode: " + (Object)((Object)staleness.getMode()));
    }

    static String durationToString(DurationValueGetter function) {
        TimeUnit unit = ReadOnlyStalenessUtil.getAppropriateTimeUnit(function);
        return function.getDuration(unit) + ReadOnlyStalenessUtil.getTimeUnitAbbreviation(unit);
    }

    static TimeUnit getAppropriateTimeUnit(DurationValueGetter durationGetter) {
        int index = 0;
        if (durationGetter.hasDuration()) {
            for (TimeUnit unit : SUPPORTED_UNITS) {
                long duration = durationGetter.getDuration(unit);
                if (index + 1 < SUPPORTED_UNITS.length) {
                    if (duration > 0L && duration * 1000L == durationGetter.getDuration(SUPPORTED_UNITS[index + 1])) {
                        return unit;
                    }
                } else {
                    return unit;
                }
                ++index;
            }
            throw new IllegalStateException("Unsupported duration");
        }
        return TimeUnit.NANOSECONDS;
    }

    static Duration createDuration(long num, TimeUnit units) {
        switch (units) {
            case NANOSECONDS: {
                return Durations.fromNanos((long)num);
            }
            case MICROSECONDS: {
                return Durations.fromMicros((long)num);
            }
            case MILLISECONDS: {
                return Durations.fromMillis((long)num);
            }
            case SECONDS: {
                return Durations.fromSeconds((long)num);
            }
        }
        return Durations.fromMillis((long)units.toMillis(num));
    }

    static long durationToUnits(Duration duration, TimeUnit units) {
        switch (units) {
            case NANOSECONDS: {
                return Durations.toNanos((Duration)duration);
            }
            case MICROSECONDS: {
                return Durations.toMicros((Duration)duration);
            }
            case MILLISECONDS: {
                return Durations.toMillis((Duration)duration);
            }
            case SECONDS: {
                return Durations.toSeconds((Duration)duration);
            }
        }
        throw new IllegalArgumentException();
    }

    static enum TimeUnitAbbreviation {
        NANOSECONDS("ns", TimeUnit.NANOSECONDS),
        MICROSECONDS("us", TimeUnit.MICROSECONDS),
        MILLISECONDS("ms", TimeUnit.MILLISECONDS),
        SECONDS("s", TimeUnit.SECONDS);

        private final String abbreviation;
        private final TimeUnit unit;

        private TimeUnitAbbreviation(String abbreviation, TimeUnit unit) {
            this.abbreviation = abbreviation;
            this.unit = unit;
        }

        String getAbbreviation() {
            return this.abbreviation;
        }

        TimeUnit getUnit() {
            return this.unit;
        }
    }

    static final class GetExactStaleness
    implements DurationValueGetter {
        private final TimestampBound staleness;

        public GetExactStaleness(TimestampBound staleness) {
            this.staleness = staleness;
        }

        @Override
        public long getDuration(TimeUnit unit) {
            return this.staleness.getExactStaleness(unit);
        }

        @Override
        public boolean hasDuration() {
            return this.staleness.getMode() == TimestampBound.Mode.EXACT_STALENESS;
        }
    }

    static interface DurationValueGetter {
        public long getDuration(TimeUnit var1);

        public boolean hasDuration();
    }

    static final class MaxStalenessGetter
    implements DurationValueGetter {
        private final TimestampBound staleness;

        public MaxStalenessGetter(TimestampBound staleness) {
            this.staleness = staleness;
        }

        @Override
        public long getDuration(TimeUnit unit) {
            return this.staleness.getMaxStaleness(unit);
        }

        @Override
        public boolean hasDuration() {
            return this.staleness.getMode() == TimestampBound.Mode.MAX_STALENESS;
        }
    }

    static final class DurationGetter
    implements DurationValueGetter {
        private final Duration duration;

        public DurationGetter(Duration duration) {
            this.duration = duration;
        }

        @Override
        public long getDuration(TimeUnit unit) {
            return ReadOnlyStalenessUtil.durationToUnits(this.duration, unit);
        }

        @Override
        public boolean hasDuration() {
            return this.duration.getNanos() > 0 || this.duration.getSeconds() > 0L;
        }
    }
}

