/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.RateLimiter;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import org.apache.cassandra.cache.CacheKey;
import org.apache.cassandra.cache.CounterCacheKey;
import org.apache.cassandra.cache.IRowCacheEntry;
import org.apache.cassandra.cache.RowCacheKey;
import org.apache.cassandra.cache.RowCacheSentinel;
import org.apache.cassandra.concurrent.ExecutorFactory;
import org.apache.cassandra.concurrent.ExecutorPlus;
import org.apache.cassandra.concurrent.FutureTask;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.DurationSpec;
import org.apache.cassandra.db.CassandraTableWriteHandler;
import org.apache.cassandra.db.ClockAndCount;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.ClusteringComparator;
import org.apache.cassandra.db.ColumnFamilyStoreMBean;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.Directories;
import org.apache.cassandra.db.DiskBoundaries;
import org.apache.cassandra.db.DiskBoundaryManager;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.PartitionPosition;
import org.apache.cassandra.db.SSTableImporter;
import org.apache.cassandra.db.SchemaCQLHelper;
import org.apache.cassandra.db.SerializationHeader;
import org.apache.cassandra.db.StorageHook;
import org.apache.cassandra.db.SystemKeyspace;
import org.apache.cassandra.db.TableWriteHandler;
import org.apache.cassandra.db.commitlog.CommitLog;
import org.apache.cassandra.db.commitlog.CommitLogPosition;
import org.apache.cassandra.db.compaction.AbstractCompactionStrategy;
import org.apache.cassandra.db.compaction.CompactionManager;
import org.apache.cassandra.db.compaction.CompactionStrategyManager;
import org.apache.cassandra.db.compaction.OperationType;
import org.apache.cassandra.db.compaction.Verifier;
import org.apache.cassandra.db.filter.ClusteringIndexFilter;
import org.apache.cassandra.db.filter.DataLimits;
import org.apache.cassandra.db.lifecycle.LifecycleNewTracker;
import org.apache.cassandra.db.lifecycle.LifecycleTransaction;
import org.apache.cassandra.db.lifecycle.SSTableSet;
import org.apache.cassandra.db.lifecycle.Tracker;
import org.apache.cassandra.db.lifecycle.View;
import org.apache.cassandra.db.memtable.Flushing;
import org.apache.cassandra.db.memtable.Memtable;
import org.apache.cassandra.db.memtable.ShardBoundaries;
import org.apache.cassandra.db.partitions.CachedPartition;
import org.apache.cassandra.db.partitions.PartitionUpdate;
import org.apache.cassandra.db.repair.CassandraTableRepairManager;
import org.apache.cassandra.db.rows.CellPath;
import org.apache.cassandra.db.streaming.CassandraStreamManager;
import org.apache.cassandra.db.view.TableViews;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.dht.Bounds;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Splitter;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.exceptions.StartupException;
import org.apache.cassandra.index.SecondaryIndexManager;
import org.apache.cassandra.index.internal.CassandraIndex;
import org.apache.cassandra.index.transactions.UpdateTransaction;
import org.apache.cassandra.io.FSReadError;
import org.apache.cassandra.io.FSWriteError;
import org.apache.cassandra.io.sstable.Component;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.SSTable;
import org.apache.cassandra.io.sstable.SSTableId;
import org.apache.cassandra.io.sstable.SSTableIdFactory;
import org.apache.cassandra.io.sstable.SSTableMultiWriter;
import org.apache.cassandra.io.sstable.format.SSTableFormat;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.sstable.format.Version;
import org.apache.cassandra.io.sstable.metadata.MetadataCollector;
import org.apache.cassandra.io.util.File;
import org.apache.cassandra.io.util.FileOutputStreamPlus;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.metrics.Sampler;
import org.apache.cassandra.metrics.TableMetrics;
import org.apache.cassandra.metrics.TopPartitionTracker;
import org.apache.cassandra.repair.TableRepairManager;
import org.apache.cassandra.repair.consistent.admin.CleanupSummary;
import org.apache.cassandra.repair.consistent.admin.PendingStat;
import org.apache.cassandra.schema.ColumnMetadata;
import org.apache.cassandra.schema.CompactionParams;
import org.apache.cassandra.schema.CompressionParams;
import org.apache.cassandra.schema.IndexMetadata;
import org.apache.cassandra.schema.Schema;
import org.apache.cassandra.schema.SchemaConstants;
import org.apache.cassandra.schema.TableId;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.schema.TableMetadataRef;
import org.apache.cassandra.schema.TableParams;
import org.apache.cassandra.service.ActiveRepairService;
import org.apache.cassandra.service.CacheService;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.service.paxos.Ballot;
import org.apache.cassandra.service.paxos.PaxosRepairHistory;
import org.apache.cassandra.service.paxos.TablePaxosRepairHistory;
import org.apache.cassandra.service.snapshot.SnapshotManifest;
import org.apache.cassandra.service.snapshot.TableSnapshot;
import org.apache.cassandra.streaming.TableStreamManager;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.Clock;
import org.apache.cassandra.utils.DefaultValue;
import org.apache.cassandra.utils.ExecutorUtils;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.JVMStabilityInspector;
import org.apache.cassandra.utils.MBeanWrapper;
import org.apache.cassandra.utils.NoSpamLogger;
import org.apache.cassandra.utils.TimeUUID;
import org.apache.cassandra.utils.WrappedRunnable;
import org.apache.cassandra.utils.concurrent.CountDownLatch;
import org.apache.cassandra.utils.concurrent.Future;
import org.apache.cassandra.utils.concurrent.OpOrder;
import org.apache.cassandra.utils.concurrent.Refs;
import org.apache.cassandra.utils.concurrent.UncheckedInterruptedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColumnFamilyStore
implements ColumnFamilyStoreMBean,
Memtable.Owner {
    private static final Logger logger = LoggerFactory.getLogger(ColumnFamilyStore.class);
    private static final ExecutorPlus flushExecutor = ExecutorFactory.Global.executorFactory().withJmxInternal().pooled("MemtableFlushWriter", DatabaseDescriptor.getFlushWriters());
    private static final ExecutorPlus postFlushExecutor = ExecutorFactory.Global.executorFactory().withJmxInternal().sequential("MemtablePostFlush");
    private static final ExecutorPlus reclaimExecutor = ExecutorFactory.Global.executorFactory().withJmxInternal().sequential("MemtableReclaimMemory");
    private static final PerDiskFlushExecutors perDiskflushExecutors = new PerDiskFlushExecutors(DatabaseDescriptor.getFlushWriters(), DatabaseDescriptor.getNonLocalSystemKeyspacesDataFileLocations(), DatabaseDescriptor.useSpecificLocationForLocalSystemData());
    private static final String[] COUNTER_NAMES = new String[]{"table", "count", "error", "value"};
    private static final String[] COUNTER_DESCS = new String[]{"keyspace.tablename", "number of occurances", "error bounds", "value"};
    private static final CompositeType COUNTER_COMPOSITE_TYPE;
    private static final String SAMPLING_RESULTS_NAME = "SAMPLING_RESULTS";
    public static final String SNAPSHOT_TRUNCATE_PREFIX = "truncated";
    public static final String SNAPSHOT_DROP_PREFIX = "dropped";
    static final String TOKEN_DELIMITER = ":";
    public final Keyspace keyspace;
    public final String name;
    public final TableMetadataRef metadata;
    private final String mbeanName;
    @Deprecated
    private final String oldMBeanName;
    private volatile boolean valid = true;
    private volatile Memtable.Factory memtableFactory;
    private final Tracker data;
    public final OpOrder readOrdering = new OpOrder();
    private final Supplier<? extends SSTableId> sstableIdGenerator;
    public final SecondaryIndexManager indexManager;
    public final TableViews viewManager;
    private volatile DefaultValue<Integer> minCompactionThreshold;
    private volatile DefaultValue<Integer> maxCompactionThreshold;
    private volatile DefaultValue<Double> crcCheckChance;
    private final CompactionStrategyManager compactionStrategyManager;
    private final Directories directories;
    public final TableMetrics metric;
    public volatile long sampleReadLatencyMicros;
    public volatile long additionalWriteLatencyMicros;
    private final CassandraTableWriteHandler writeHandler;
    private final CassandraStreamManager streamManager;
    private final TableRepairManager repairManager;
    public final TopPartitionTracker topPartitions;
    private final SSTableImporter sstableImporter;
    private volatile boolean compactionSpaceCheck = true;
    @VisibleForTesting
    final DiskBoundaryManager diskBoundaryManager = new DiskBoundaryManager();
    private volatile ShardBoundaries cachedShardBoundaries = null;
    private volatile boolean neverPurgeTombstones = false;
    private final PaxosRepairHistoryLoader paxosRepairHistory = new PaxosRepairHistoryLoader();
    private static final LifecycleNewTracker DO_NOT_TRACK;

    public static void shutdownPostFlushExecutor() throws InterruptedException {
        postFlushExecutor.shutdown();
        postFlushExecutor.awaitTermination(60L, TimeUnit.SECONDS);
    }

    public static void shutdownExecutorsAndWait(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        ArrayList<ExecutorService> executors = new ArrayList<ExecutorService>();
        Collections.addAll(executors, reclaimExecutor, postFlushExecutor, flushExecutor);
        perDiskflushExecutors.appendAllExecutors(executors);
        ExecutorUtils.shutdownAndWait(timeout, unit, executors);
    }

    public void reload() {
        if (!this.minCompactionThreshold.isModified()) {
            for (ColumnFamilyStore cfs : this.concatWithIndexes()) {
                cfs.minCompactionThreshold = new DefaultValue<Integer>(this.metadata().params.compaction.minCompactionThreshold());
            }
        }
        if (!this.maxCompactionThreshold.isModified()) {
            for (ColumnFamilyStore cfs : this.concatWithIndexes()) {
                cfs.maxCompactionThreshold = new DefaultValue<Integer>(this.metadata().params.compaction.maxCompactionThreshold());
            }
        }
        if (!this.crcCheckChance.isModified()) {
            for (ColumnFamilyStore cfs : this.concatWithIndexes()) {
                cfs.crcCheckChance = new DefaultValue<Double>(this.metadata().params.crcCheckChance);
            }
        }
        this.compactionStrategyManager.maybeReload(this.metadata());
        this.indexManager.reload();
        this.memtableFactory = this.metadata().params.memtable.factory();
        this.switchMemtableOrNotify(FlushReason.SCHEMA_CHANGE, Memtable::metadataUpdated);
    }

    public static Runnable getBackgroundCompactionTaskSubmitter() {
        return () -> {
            for (Keyspace keyspace : Keyspace.all()) {
                for (ColumnFamilyStore cfs : keyspace.getColumnFamilyStores()) {
                    CompactionManager.instance.submitBackground(cfs);
                }
            }
        };
    }

    @Override
    public Map<String, String> getCompactionParameters() {
        return this.compactionStrategyManager.getCompactionParams().asMap();
    }

    @Override
    public String getCompactionParametersJson() {
        return FBUtilities.json(this.getCompactionParameters());
    }

    @Override
    public void setCompactionParameters(Map<String, String> options) {
        try {
            CompactionParams compactionParams = CompactionParams.fromMap(options);
            compactionParams.validate();
            this.compactionStrategyManager.setNewLocalCompactionStrategy(compactionParams);
        }
        catch (Throwable t) {
            logger.error("Could not set new local compaction strategy", t);
            throw new IllegalArgumentException("Could not set new local compaction strategy: " + t.getMessage());
        }
    }

    @Override
    public void setCompactionParametersJson(String options) {
        this.setCompactionParameters(FBUtilities.fromJsonMap(options));
    }

    @Override
    public Map<String, String> getCompressionParameters() {
        return this.metadata.getLocal().params.compression.asMap();
    }

    @Override
    public String getCompressionParametersJson() {
        return FBUtilities.json(this.getCompressionParameters());
    }

    @Override
    public void setCompressionParameters(Map<String, String> opts) {
        try {
            CompressionParams params = CompressionParams.fromMap(opts);
            params.validate();
            this.metadata.setLocalOverrides(this.metadata().unbuild().compression(params).build());
        }
        catch (ConfigurationException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    @Override
    public void setCompressionParametersJson(String options) {
        this.setCompressionParameters(FBUtilities.fromJsonMap(options));
    }

    @VisibleForTesting
    public ColumnFamilyStore(Keyspace keyspace, String columnFamilyName, Supplier<? extends SSTableId> sstableIdGenerator, TableMetadataRef metadata, Directories directories, boolean loadSSTables, boolean registerBookeeping, boolean offline) {
        assert (directories != null);
        assert (metadata != null) : "null metadata for " + keyspace + ':' + columnFamilyName;
        this.keyspace = keyspace;
        this.metadata = metadata;
        this.directories = directories;
        this.name = columnFamilyName;
        this.minCompactionThreshold = new DefaultValue<Integer>(metadata.get().params.compaction.minCompactionThreshold());
        this.maxCompactionThreshold = new DefaultValue<Integer>(metadata.get().params.compaction.maxCompactionThreshold());
        this.crcCheckChance = new DefaultValue<Double>(metadata.get().params.crcCheckChance);
        this.viewManager = keyspace.viewManager.forTable(metadata.id);
        this.sstableIdGenerator = sstableIdGenerator;
        this.sampleReadLatencyMicros = DatabaseDescriptor.getReadRpcTimeout(TimeUnit.MICROSECONDS) / 2L;
        this.additionalWriteLatencyMicros = DatabaseDescriptor.getWriteRpcTimeout(TimeUnit.MICROSECONDS) / 2L;
        this.memtableFactory = metadata.get().params.memtable.factory();
        logger.info("Initializing {}.{}", (Object)keyspace.getName(), (Object)this.name);
        Memtable initialMemtable = null;
        TableMetrics.ReleasableMetric memtableMetrics = null;
        if (DatabaseDescriptor.isDaemonInitialized()) {
            initialMemtable = this.createMemtable(new AtomicReference<CommitLogPosition>(CommitLog.instance.getCurrentPosition()));
            memtableMetrics = this.memtableFactory.createMemtableMetrics(metadata);
        }
        this.data = new Tracker(this, initialMemtable, loadSSTables);
        this.data.subscribe(StorageService.instance.sstablesTracker);
        Collection<SSTableReader> sstables = null;
        if (this.data.loadsstables) {
            Directories.SSTableLister sstableFiles = directories.sstableLister(Directories.OnTxnErr.IGNORE).skipTemporary(true);
            sstables = SSTableReader.openAll(sstableFiles.list().entrySet(), metadata);
            this.data.addInitialSSTablesWithoutUpdatingSize(sstables);
        }
        this.compactionStrategyManager = new CompactionStrategyManager(this);
        if (this.maxCompactionThreshold.value() <= 0 || this.minCompactionThreshold.value() <= 0) {
            logger.warn("Disabling compaction strategy by setting compaction thresholds to 0 is deprecated, set the compaction option 'enabled' to 'false' instead.");
            this.compactionStrategyManager.disable();
        }
        this.indexManager = new SecondaryIndexManager(this);
        for (IndexMetadata info : metadata.get().indexes) {
            this.indexManager.addIndex(info, true);
        }
        this.metric = new TableMetrics(this, memtableMetrics);
        if (this.data.loadsstables) {
            this.data.updateInitialSSTableSize(sstables);
        }
        if (registerBookeeping) {
            String[] objectNames;
            this.mbeanName = ColumnFamilyStore.getTableMBeanName(keyspace.getName(), this.name, this.isIndex());
            this.oldMBeanName = ColumnFamilyStore.getColumnFamilieMBeanName(keyspace.getName(), this.name, this.isIndex());
            for (String objectName : objectNames = new String[]{this.mbeanName, this.oldMBeanName}) {
                MBeanWrapper.instance.registerMBean((Object)this, objectName);
            }
        } else {
            this.mbeanName = null;
            this.oldMBeanName = null;
        }
        this.writeHandler = new CassandraTableWriteHandler(this);
        this.streamManager = new CassandraStreamManager(this);
        this.repairManager = new CassandraTableRepairManager(this);
        this.sstableImporter = new SSTableImporter(this);
        this.topPartitions = SchemaConstants.isSystemKeyspace(keyspace.getName()) ? null : new TopPartitionTracker(this.metadata());
    }

    public static String getTableMBeanName(String ks, String name, boolean isIndex) {
        return String.format("org.apache.cassandra.db:type=%s,keyspace=%s,table=%s", isIndex ? "IndexTables" : "Tables", ks, name);
    }

    public static String getColumnFamilieMBeanName(String ks, String name, boolean isIndex) {
        return String.format("org.apache.cassandra.db:type=%s,keyspace=%s,columnfamily=%s", isIndex ? "IndexColumnFamilies" : "ColumnFamilies", ks, name);
    }

    public void updateSpeculationThreshold() {
        try {
            this.sampleReadLatencyMicros = this.metadata().params.speculativeRetry.calculateThreshold(this.metric.coordinatorReadLatency, this.sampleReadLatencyMicros);
            this.additionalWriteLatencyMicros = this.metadata().params.additionalWritePolicy.calculateThreshold(this.metric.coordinatorWriteLatency, this.additionalWriteLatencyMicros);
        }
        catch (Throwable e) {
            logger.error("Exception caught while calculating speculative retry threshold for {}: {}", (Object)this.metadata(), (Object)e);
        }
    }

    public TableWriteHandler getWriteHandler() {
        return this.writeHandler;
    }

    public TableStreamManager getStreamManager() {
        return this.streamManager;
    }

    public TableRepairManager getRepairManager() {
        return this.repairManager;
    }

    public TableMetadata metadata() {
        return this.metadata.get();
    }

    public Directories getDirectories() {
        return this.directories;
    }

    @Override
    public List<String> getDataPaths() throws IOException {
        ArrayList<String> dataPaths = new ArrayList<String>();
        for (File dataPath : this.directories.getCFDirectories()) {
            dataPaths.add(dataPath.canonicalPath());
        }
        return dataPaths;
    }

    public boolean writesShouldSkipCommitLog() {
        return this.memtableFactory.writesShouldSkipCommitLog();
    }

    public boolean memtableWritesAreDurable() {
        return this.memtableFactory.writesAreDurable();
    }

    public boolean streamToMemtable() {
        return this.memtableFactory.streamToMemtable();
    }

    public boolean streamFromMemtable() {
        return this.memtableFactory.streamFromMemtable();
    }

    public SSTableMultiWriter createSSTableMultiWriter(Descriptor descriptor, long keyCount, long repairedAt, TimeUUID pendingRepair, boolean isTransient, int sstableLevel, SerializationHeader header, LifecycleNewTracker lifecycleNewTracker) {
        MetadataCollector collector = new MetadataCollector(this.metadata().comparator).sstableLevel(sstableLevel);
        return this.createSSTableMultiWriter(descriptor, keyCount, repairedAt, pendingRepair, isTransient, collector, header, lifecycleNewTracker);
    }

    public SSTableMultiWriter createSSTableMultiWriter(Descriptor descriptor, long keyCount, long repairedAt, TimeUUID pendingRepair, boolean isTransient, MetadataCollector metadataCollector, SerializationHeader header, LifecycleNewTracker lifecycleNewTracker) {
        return this.getCompactionStrategyManager().createSSTableMultiWriter(descriptor, keyCount, repairedAt, pendingRepair, isTransient, metadataCollector, header, this.indexManager.listIndexes(), lifecycleNewTracker);
    }

    public boolean supportsEarlyOpen() {
        return this.compactionStrategyManager.supportsEarlyOpen();
    }

    public void invalidate() {
        this.invalidate(true, true);
    }

    public void invalidate(boolean expectMBean) {
        this.invalidate(expectMBean, true);
    }

    public void invalidate(boolean expectMBean, boolean dropData) {
        block5: {
            this.valid = false;
            try {
                this.unregisterMBean();
            }
            catch (Exception e) {
                if (!expectMBean) break block5;
                JVMStabilityInspector.inspectThrowable(e);
                logger.warn("Failed unregistering mbean: {}", (Object)this.mbeanName, (Object)e);
            }
        }
        this.compactionStrategyManager.shutdown();
        if (!this.metadata.get().isIndex()) {
            SystemKeyspace.removeTruncationRecord(this.metadata.id);
        }
        if (dropData) {
            this.data.dropSSTables();
            LifecycleTransaction.waitForDeletions();
        }
        this.indexManager.dropAllIndexes(dropData);
        this.invalidateCaches();
        if (this.topPartitions != null) {
            this.topPartitions.close();
        }
    }

    void maybeRemoveUnreadableSSTables(File directory) {
        this.data.removeUnreadableSSTables(directory);
    }

    void unregisterMBean() throws MalformedObjectNameException {
        ObjectName[] objectNames;
        for (ObjectName objectName : objectNames = new ObjectName[]{new ObjectName(this.mbeanName), new ObjectName(this.oldMBeanName)}) {
            if (!MBeanWrapper.instance.isRegistered(objectName)) continue;
            MBeanWrapper.instance.unregisterMBean(objectName);
        }
        this.metric.release();
    }

    public static ColumnFamilyStore createColumnFamilyStore(Keyspace keyspace, TableMetadataRef metadata, boolean loadSSTables) {
        return ColumnFamilyStore.createColumnFamilyStore(keyspace, metadata.name, metadata, loadSSTables);
    }

    public static ColumnFamilyStore createColumnFamilyStore(Keyspace keyspace, String columnFamily, TableMetadataRef metadata, boolean loadSSTables) {
        Directories directories = new Directories(metadata.get());
        return ColumnFamilyStore.createColumnFamilyStore(keyspace, columnFamily, metadata, directories, loadSSTables, true, false);
    }

    public static synchronized ColumnFamilyStore createColumnFamilyStore(Keyspace keyspace, String columnFamily, TableMetadataRef metadata, Directories directories, boolean loadSSTables, boolean registerBookkeeping, boolean offline) {
        return new ColumnFamilyStore(keyspace, columnFamily, directories.getUIDGenerator(SSTableIdFactory.instance.defaultBuilder()), metadata, directories, loadSSTables, registerBookkeeping, offline);
    }

    public static void scrubDataDirectories(TableMetadata metadata) throws StartupException {
        Directories directories = new Directories(metadata);
        HashSet<File> cleanedDirectories = new HashSet<File>();
        ColumnFamilyStore.clearEphemeralSnapshots(directories);
        directories.removeTemporaryDirectories();
        logger.trace("Removing temporary or obsoleted files from unfinished operations for table {}", (Object)metadata.name);
        if (!LifecycleTransaction.removeUnfinishedLeftovers(metadata)) {
            throw new StartupException(3, String.format("Cannot remove temporary or obsoleted files for %s due to a problem with transaction log files. Please check records with problems in the log messages above and fix them. Refer to the 3.0 upgrading instructions in NEWS.txt for a description of transaction log files.", metadata.toString()));
        }
        logger.trace("Further extra check for orphan sstable files for {}", (Object)metadata.name);
        for (Map.Entry<Descriptor, Set<Component>> sstableFiles : directories.sstableLister(Directories.OnTxnErr.IGNORE).list().entrySet()) {
            Descriptor desc = sstableFiles.getKey();
            File directory = desc.directory;
            Set<Component> components = sstableFiles.getValue();
            if (!cleanedDirectories.contains(directory)) {
                cleanedDirectories.add(directory);
                for (File tmpFile : desc.getTemporaryFiles()) {
                    logger.info("Removing unfinished temporary file {}", (Object)tmpFile);
                    tmpFile.tryDelete();
                }
            }
            File dataFile = new File(desc.filenameFor(Component.DATA));
            if (components.contains(Component.DATA) && dataFile.length() > 0L) continue;
            logger.warn("Removing orphans for {}: {}", (Object)desc, components);
            for (Component component : components) {
                File file = new File(desc.filenameFor(component));
                if (!file.exists()) continue;
                FileUtils.deleteWithConfirm(desc.filenameFor(component));
            }
        }
        Pattern tmpCacheFilePattern = Pattern.compile(metadata.keyspace + '-' + metadata.name + "-(Key|Row)Cache.*\\.tmp$");
        File dir = new File(DatabaseDescriptor.getSavedCachesLocation());
        if (dir.exists()) {
            assert (dir.isDirectory());
            for (File file : dir.tryList()) {
                if (!tmpCacheFilePattern.matcher(file.name()).matches() || file.tryDelete()) continue;
                logger.warn("could not delete {}", (Object)file.absolutePath());
            }
        }
        for (IndexMetadata index : metadata.indexes) {
            if (index.isCustom()) continue;
            TableMetadata indexMetadata = CassandraIndex.indexCfsMetadata(metadata, index);
            ColumnFamilyStore.scrubDataDirectories(indexMetadata);
        }
    }

    public static void loadNewSSTables(String ksName, String cfName) {
        Keyspace keyspace = Keyspace.open(ksName);
        keyspace.getColumnFamilyStore(cfName).loadNewSSTables();
    }

    @Override
    @Deprecated
    public void loadNewSSTables() {
        SSTableImporter.Options options = SSTableImporter.Options.options().resetLevel(true).build();
        this.sstableImporter.importNewSSTables(options);
    }

    @Override
    public synchronized List<String> importNewSSTables(Set<String> srcPaths, boolean resetLevel, boolean clearRepaired, boolean verifySSTables, boolean verifyTokens, boolean invalidateCaches, boolean extendedVerify, boolean copyData) {
        SSTableImporter.Options options = SSTableImporter.Options.options(srcPaths).resetLevel(resetLevel).clearRepaired(clearRepaired).verifySSTables(verifySSTables).verifyTokens(verifyTokens).invalidateCaches(invalidateCaches).extendedVerify(extendedVerify).copyData(copyData).build();
        return this.sstableImporter.importNewSSTables(options);
    }

    @Override
    public List<String> importNewSSTables(Set<String> srcPaths, boolean resetLevel, boolean clearRepaired, boolean verifySSTables, boolean verifyTokens, boolean invalidateCaches, boolean extendedVerify) {
        return this.importNewSSTables(srcPaths, resetLevel, clearRepaired, verifySSTables, verifyTokens, invalidateCaches, extendedVerify, false);
    }

    Descriptor getUniqueDescriptorFor(Descriptor descriptor, File targetDirectory) {
        Descriptor newDescriptor;
        while ((newDescriptor = new Descriptor(descriptor.version, targetDirectory, descriptor.ksname, descriptor.cfname, this.sstableIdGenerator.get(), descriptor.formatType)).fileFor(Component.DATA).exists()) {
        }
        return newDescriptor;
    }

    public void rebuildSecondaryIndex(String idxName) {
        ColumnFamilyStore.rebuildSecondaryIndex(this.keyspace.getName(), this.metadata.name, idxName);
    }

    public static void rebuildSecondaryIndex(String ksName, String cfName, String ... idxNames) {
        ColumnFamilyStore cfs = Keyspace.open(ksName).getColumnFamilyStore(cfName);
        logger.info("User Requested secondary index re-build for {}/{} indexes: {}", new Object[]{ksName, cfName, Joiner.on((char)',').join((Object[])idxNames)});
        cfs.indexManager.rebuildIndexesBlocking(Sets.newHashSet(Arrays.asList(idxNames)));
    }

    public AbstractCompactionStrategy createCompactionStrategyInstance(CompactionParams compactionParams) {
        try {
            Constructor<? extends AbstractCompactionStrategy> constructor = compactionParams.klass().getConstructor(ColumnFamilyStore.class, Map.class);
            return constructor.newInstance(this, compactionParams.options());
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @Deprecated
    public String getColumnFamilyName() {
        return this.getTableName();
    }

    @Override
    public String getTableName() {
        return this.name;
    }

    public Descriptor newSSTableDescriptor(File directory) {
        return this.newSSTableDescriptor(directory, SSTableFormat.Type.current().info.getLatestVersion(), SSTableFormat.Type.current());
    }

    public Descriptor newSSTableDescriptor(File directory, SSTableFormat.Type format) {
        return this.newSSTableDescriptor(directory, format.info.getLatestVersion(), format);
    }

    public Descriptor newSSTableDescriptor(File directory, Version version, SSTableFormat.Type format) {
        Descriptor newDescriptor = new Descriptor(version, directory, this.keyspace.getName(), this.name, this.sstableIdGenerator.get(), format);
        assert (!newDescriptor.fileFor(Component.DATA).exists());
        return newDescriptor;
    }

    private void switchMemtableOrNotify(FlushReason reason, Consumer<Memtable> elseNotify) {
        Memtable currentMemtable = this.data.getView().getCurrentMemtable();
        if (currentMemtable.shouldSwitch(reason)) {
            this.switchMemtableIfCurrent(currentMemtable, reason);
        } else {
            elseNotify.accept(currentMemtable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<CommitLogPosition> switchMemtableIfCurrent(Memtable memtable, FlushReason reason) {
        Tracker tracker = this.data;
        synchronized (tracker) {
            if (this.data.getView().getCurrentMemtable() == memtable) {
                return this.switchMemtable(reason);
            }
        }
        logger.debug("Memtable is no longer current, returning future that completes when current flushing operation completes");
        return this.waitForFlushes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public Future<CommitLogPosition> switchMemtable(FlushReason reason) {
        Tracker tracker = this.data;
        synchronized (tracker) {
            this.logFlush(reason);
            Flush flush = new Flush(false);
            flushExecutor.execute(flush);
            postFlushExecutor.execute(flush.postFlushTask);
            return flush.postFlushTask;
        }
    }

    private void logFlush(FlushReason reason) {
        Memtable.MemoryUsage usage = Memtable.newMemoryUsage();
        this.getTracker().getView().getCurrentMemtable().addMemoryUsageTo(usage);
        for (ColumnFamilyStore indexCfs : this.indexManager.getAllIndexColumnFamilyStores()) {
            indexCfs.getTracker().getView().getCurrentMemtable().addMemoryUsageTo(usage);
        }
        logger.info("Enqueuing flush of {}.{}, Reason: {}, Usage: {}", new Object[]{this.keyspace.getName(), this.name, reason, usage});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<CommitLogPosition> forceFlush(FlushReason reason) {
        Tracker tracker = this.data;
        synchronized (tracker) {
            Memtable current = this.data.getView().getCurrentMemtable();
            for (ColumnFamilyStore cfs : this.concatWithIndexes()) {
                if (cfs.data.getView().getCurrentMemtable().isClean()) continue;
                return this.flushMemtable(current, reason);
            }
            return this.waitForFlushes();
        }
    }

    public Future<?> forceFlush(CommitLogPosition flushIfDirtyBefore) {
        Memtable current = this.data.getView().getCurrentMemtable();
        if (current.mayContainDataBefore(flushIfDirtyBefore)) {
            return this.flushMemtable(current, FlushReason.COMMITLOG_DIRTY);
        }
        return this.waitForFlushes();
    }

    private Future<CommitLogPosition> flushMemtable(Memtable current, FlushReason reason) {
        if (current.shouldSwitch(reason)) {
            return this.switchMemtableIfCurrent(current, reason);
        }
        return this.waitForFlushes();
    }

    private Future<CommitLogPosition> waitForFlushes() {
        Memtable current = this.data.getView().getCurrentMemtable();
        return postFlushExecutor.submit(current::getCommitLogLowerBound);
    }

    public CommitLogPosition forceBlockingFlush(FlushReason reason) {
        return FBUtilities.waitOnFuture(this.forceFlush(reason));
    }

    public Memtable createMemtable(AtomicReference<CommitLogPosition> commitLogUpperBound) {
        return this.memtableFactory.create(commitLogUpperBound, this.metadata, this);
    }

    private static void setCommitLogUpperBound(AtomicReference<CommitLogPosition> commitLogUpperBound) {
        Memtable.LastCommitLogPosition lastReplayPosition;
        CommitLogPosition currentLast;
        do {
            lastReplayPosition = new Memtable.LastCommitLogPosition(CommitLog.instance.getCurrentPosition());
        } while ((currentLast = commitLogUpperBound.get()) != null && currentLast.compareTo(lastReplayPosition) > 0 || !commitLogUpperBound.compareAndSet(currentLast, lastReplayPosition));
    }

    @Override
    public Future<CommitLogPosition> signalFlushRequired(Memtable memtable, FlushReason reason) {
        return this.switchMemtableIfCurrent(memtable, reason);
    }

    @Override
    public Memtable getCurrentMemtable() {
        return this.data.getView().getCurrentMemtable();
    }

    public static Iterable<Memtable> activeMemtables() {
        return Iterables.transform(ColumnFamilyStore.all(), cfs -> cfs.getTracker().getView().getCurrentMemtable());
    }

    @Override
    public Iterable<Memtable> getIndexMemtables() {
        return Iterables.transform(this.indexManager.getAllIndexColumnFamilyStores(), cfs -> cfs.getTracker().getView().getCurrentMemtable());
    }

    public void apply(PartitionUpdate update, UpdateTransaction indexer, OpOrder.Group opGroup, CommitLogPosition commitLogPosition) {
        long start = Clock.Global.nanoTime();
        try {
            Memtable mt = this.data.getMemtableFor(opGroup, commitLogPosition);
            long timeDelta = mt.put(update, indexer, opGroup);
            DecoratedKey key = update.partitionKey();
            this.invalidateCachedPartition(key);
            this.metric.topWritePartitionFrequency.addSample(key.getKey(), 1);
            if (this.metric.topWritePartitionSize.isEnabled()) {
                this.metric.topWritePartitionSize.addSample(key.getKey(), update.dataSize());
            }
            StorageHook.instance.reportWrite(this.metadata.id, update);
            this.metric.writeLatency.addNano(Clock.Global.nanoTime() - start);
            if (timeDelta < Long.MAX_VALUE) {
                this.metric.colUpdateTimeDeltaHistogram.update(Math.min(18165375903306L, timeDelta));
            }
        }
        catch (RuntimeException e) {
            throw new RuntimeException(e.getMessage() + " for ks: " + this.keyspace.getName() + ", table: " + this.name, e);
        }
    }

    @Override
    public ShardBoundaries localRangeSplits(int shardCount) {
        if (shardCount == 1 || !this.getPartitioner().splitter().isPresent() || SchemaConstants.isLocalSystemKeyspace(this.keyspace.getName())) {
            return ShardBoundaries.NONE;
        }
        ShardBoundaries shardBoundaries = this.cachedShardBoundaries;
        if (shardBoundaries == null || shardBoundaries.shardCount() != shardCount || shardBoundaries.ringVersion != StorageService.instance.getTokenMetadata().getRingVersion()) {
            ImmutableList weightedRanges;
            DiskBoundaryManager.VersionedRangesAtEndpoint versionedLocalRanges = DiskBoundaryManager.getVersionedLocalRanges(this);
            Set<Range<Token>> localRanges = versionedLocalRanges.rangesAtEndpoint.ranges();
            if (localRanges.isEmpty()) {
                weightedRanges = ImmutableList.of((Object)new Splitter.WeightedRange(1.0, new Range<Token>(this.getPartitioner().getMinimumToken(), this.getPartitioner().getMaximumToken())));
            } else {
                weightedRanges = new ArrayList(localRanges.size());
                for (Range<Token> r : localRanges) {
                    for (Range<Token> u : r.unwrap()) {
                        weightedRanges.add(new Splitter.WeightedRange(1.0, u));
                    }
                }
                weightedRanges.sort(Comparator.comparing(Splitter.WeightedRange::left));
            }
            List<Token> boundaries = this.getPartitioner().splitter().get().splitOwnedRanges(shardCount, (List<Splitter.WeightedRange>)weightedRanges, false);
            this.cachedShardBoundaries = shardBoundaries = new ShardBoundaries(boundaries.subList(0, boundaries.size() - 1), versionedLocalRanges.ringVersion);
            logger.debug("Memtable shard boundaries for {}.{}: {}", new Object[]{this.keyspace.getName(), this.getTableName(), boundaries});
        }
        return shardBoundaries;
    }

    public Collection<SSTableReader> getOverlappingLiveSSTables(Iterable<SSTableReader> sstables) {
        logger.trace("Checking for sstables overlapping {}", sstables);
        if (!sstables.iterator().hasNext()) {
            return ImmutableSet.of();
        }
        View view = this.data.getView();
        ArrayList sortedByFirst = Lists.newArrayList(sstables);
        Collections.sort(sortedByFirst, (o1, o2) -> o1.first.compareTo(o2.first));
        ArrayList<AbstractBounds<DecoratedKey>> bounds = new ArrayList<AbstractBounds<DecoratedKey>>();
        DecoratedKey first = null;
        DecoratedKey last = null;
        for (SSTableReader sstable : sortedByFirst) {
            if (first == null) {
                first = sstable.first;
                last = sstable.last;
                continue;
            }
            if (sstable.first.compareTo(last) <= 0) {
                if (sstable.last.compareTo(last) <= 0) continue;
                last = sstable.last;
                continue;
            }
            bounds.add(AbstractBounds.bounds(first, true, last, true));
            first = sstable.first;
            last = sstable.last;
        }
        bounds.add(AbstractBounds.bounds(first, true, last, true));
        HashSet results = new HashSet();
        for (AbstractBounds abstractBounds : bounds) {
            Iterables.addAll(results, view.liveSSTablesInBounds((PartitionPosition)abstractBounds.left, (PartitionPosition)abstractBounds.right));
        }
        return Sets.difference(results, (Set)ImmutableSet.copyOf(sstables));
    }

    public Refs<SSTableReader> getAndReferenceOverlappingLiveSSTables(Iterable<SSTableReader> sstables) {
        Collection<SSTableReader> overlapped;
        Refs<SSTableReader> refs;
        while ((refs = Refs.tryRef(overlapped = this.getOverlappingLiveSSTables(sstables))) == null) {
        }
        return refs;
    }

    public void addSSTable(SSTableReader sstable) {
        assert (sstable.getColumnFamilyName().equals(this.name));
        this.addSSTables(Collections.singletonList(sstable));
    }

    public void addSSTables(Collection<SSTableReader> sstables) {
        this.data.addSSTables(sstables);
        CompactionManager.instance.submitBackground(this);
    }

    public long getExpectedCompactedFileSize(Iterable<SSTableReader> sstables, OperationType operation) {
        if (operation != OperationType.CLEANUP || this.isIndex()) {
            return SSTableReader.getTotalBytes(sstables);
        }
        long expectedFileSize = 0L;
        Set<Range<Token>> ranges = StorageService.instance.getLocalReplicas(this.keyspace.getName()).ranges();
        for (SSTableReader sstable : sstables) {
            List<SSTableReader.PartitionPositionBounds> positions = sstable.getPositionsForRanges(ranges);
            for (SSTableReader.PartitionPositionBounds position : positions) {
                expectedFileSize += position.upperPosition - position.lowerPosition;
            }
        }
        double compressionRatio = (Double)this.metric.compressionRatio.getValue();
        if (compressionRatio > 0.0) {
            expectedFileSize = (long)((double)expectedFileSize * compressionRatio);
        }
        return expectedFileSize;
    }

    public SSTableReader getMaxSizeFile(Iterable<SSTableReader> sstables) {
        long maxSize = 0L;
        SSTableReader maxFile = null;
        for (SSTableReader sstable : sstables) {
            if (sstable.onDiskLength() <= maxSize) continue;
            maxSize = sstable.onDiskLength();
            maxFile = sstable;
        }
        return maxFile;
    }

    public CompactionManager.AllSSTableOpStatus forceCleanup(int jobs) throws ExecutionException, InterruptedException {
        return CompactionManager.instance.performCleanup(this, jobs);
    }

    public CompactionManager.AllSSTableOpStatus scrub(boolean disableSnapshot, boolean skipCorrupted, boolean checkData, boolean reinsertOverflowedTTL, int jobs) throws ExecutionException, InterruptedException {
        return this.scrub(disableSnapshot, skipCorrupted, reinsertOverflowedTTL, false, checkData, jobs);
    }

    @VisibleForTesting
    public CompactionManager.AllSSTableOpStatus scrub(boolean disableSnapshot, boolean skipCorrupted, boolean reinsertOverflowedTTL, boolean alwaysFail, boolean checkData, int jobs) throws ExecutionException, InterruptedException {
        if (!disableSnapshot) {
            Instant creationTime = FBUtilities.now();
            String snapshotName = "pre-scrub-" + creationTime.toEpochMilli();
            this.snapshotWithoutMemtable(snapshotName, creationTime);
        }
        try {
            return CompactionManager.instance.performScrub(this, skipCorrupted, checkData, reinsertOverflowedTTL, jobs);
        }
        catch (Throwable t) {
            if (!this.rebuildOnFailedScrub(t)) {
                throw t;
            }
            return alwaysFail ? CompactionManager.AllSSTableOpStatus.ABORTED : CompactionManager.AllSSTableOpStatus.SUCCESSFUL;
        }
    }

    public boolean rebuildOnFailedScrub(Throwable failure) {
        if (!this.isIndex() || !SecondaryIndexManager.isIndexColumnFamilyStore(this)) {
            return false;
        }
        this.truncateBlocking();
        logger.warn("Rebuilding index for {} because of <{}>", (Object)this.name, (Object)failure.getMessage());
        ColumnFamilyStore parentCfs = SecondaryIndexManager.getParentCfs(this);
        assert (parentCfs.indexManager.getAllIndexColumnFamilyStores().contains(this));
        String indexName = SecondaryIndexManager.getIndexName(this);
        parentCfs.rebuildSecondaryIndex(indexName);
        return true;
    }

    public CompactionManager.AllSSTableOpStatus verify(Verifier.Options options) throws ExecutionException, InterruptedException {
        return CompactionManager.instance.performVerify(this, options);
    }

    public CompactionManager.AllSSTableOpStatus sstablesRewrite(boolean skipIfCurrentVersion, long skipIfNewerThanTimestamp, boolean skipIfCompressionMatches, int jobs) throws ExecutionException, InterruptedException {
        return CompactionManager.instance.performSSTableRewrite(this, skipIfCurrentVersion, skipIfNewerThanTimestamp, skipIfCompressionMatches, jobs);
    }

    public CompactionManager.AllSSTableOpStatus relocateSSTables(int jobs) throws ExecutionException, InterruptedException {
        return CompactionManager.instance.relocateSSTables(this, jobs);
    }

    public CompactionManager.AllSSTableOpStatus garbageCollect(CompactionParams.TombstoneOption tombstoneOption, int jobs) throws ExecutionException, InterruptedException {
        return CompactionManager.instance.performGarbageCollection(this, tombstoneOption, jobs);
    }

    public void markObsolete(Collection<SSTableReader> sstables, OperationType compactionType) {
        assert (!sstables.isEmpty());
        org.apache.cassandra.utils.Throwables.maybeFail(this.data.dropSSTables((Predicate<SSTableReader>)Predicates.in(sstables), compactionType, null));
    }

    void replaceFlushed(Memtable memtable, Collection<SSTableReader> sstables) {
        this.data.replaceFlushed(memtable, sstables);
        if (sstables != null && !sstables.isEmpty()) {
            CompactionManager.instance.submitBackground(this);
        }
    }

    public boolean isValid() {
        return this.valid;
    }

    public Tracker getTracker() {
        return this.data;
    }

    public Set<SSTableReader> getLiveSSTables() {
        return this.data.getView().liveSSTables();
    }

    public Iterable<SSTableReader> getSSTables(SSTableSet sstableSet) {
        return this.data.getView().select(sstableSet);
    }

    public Iterable<SSTableReader> getUncompactingSSTables() {
        return this.data.getUncompacting();
    }

    public Map<TimeUUID, PendingStat> getPendingRepairStats() {
        HashMap<TimeUUID, PendingStat.Builder> builders = new HashMap<TimeUUID, PendingStat.Builder>();
        for (SSTableReader sstable : this.getLiveSSTables()) {
            TimeUUID session = sstable.getPendingRepair();
            if (session == null) continue;
            if (!builders.containsKey(session)) {
                builders.put(session, new PendingStat.Builder());
            }
            ((PendingStat.Builder)builders.get(session)).addSSTable(sstable);
        }
        HashMap<TimeUUID, PendingStat> stats = new HashMap<TimeUUID, PendingStat>();
        for (Map.Entry entry : builders.entrySet()) {
            stats.put((TimeUUID)entry.getKey(), ((PendingStat.Builder)entry.getValue()).build());
        }
        return stats;
    }

    public CleanupSummary releaseRepairData(Collection<TimeUUID> sessions, boolean force) {
        if (force) {
            Predicate predicate = sst -> {
                TimeUUID session = sst.getPendingRepair();
                return session != null && sessions.contains(session);
            };
            return this.runWithCompactionsDisabled(() -> this.compactionStrategyManager.releaseRepairData(sessions), (Predicate<SSTableReader>)predicate, false, true, true);
        }
        return this.compactionStrategyManager.releaseRepairData(sessions);
    }

    public boolean isFilterFullyCoveredBy(ClusteringIndexFilter filter, DataLimits limits, CachedPartition cached, int nowInSec, boolean enforceStrictLiveness) {
        if (cached.cachedLiveRows() < this.metadata().params.caching.rowsPerPartitionToCache()) {
            return true;
        }
        return filter.isHeadFilter() && limits.hasEnoughLiveData(cached, nowInSec, filter.selectsAllPartition(), enforceStrictLiveness) || filter.isFullyCoveredBy(cached);
    }

    public PaxosRepairHistory getPaxosRepairHistory() {
        return this.paxosRepairHistory.get().getHistory();
    }

    public PaxosRepairHistory getPaxosRepairHistoryForRanges(Collection<Range<Token>> ranges) {
        return this.paxosRepairHistory.get().getHistoryForRanges(ranges);
    }

    public void syncPaxosRepairHistory(PaxosRepairHistory sync, boolean flush) {
        this.paxosRepairHistory.get().merge(sync, flush);
    }

    public void onPaxosRepairComplete(Collection<Range<Token>> ranges, Ballot highBallot) {
        this.paxosRepairHistory.get().add(ranges, highBallot, true);
    }

    public Ballot getPaxosRepairLowBound(DecoratedKey key) {
        return this.paxosRepairHistory.get().getBallotForToken(key.getToken());
    }

    public int gcBefore(int nowInSec) {
        return nowInSec - this.metadata().params.gcGraceSeconds;
    }

    public RefViewFragment selectAndReference(Function<View, Iterable<SSTableReader>> filter) {
        long failingSince = -1L;
        while (true) {
            ViewFragment view = this.select(filter);
            Refs<SSTableReader> refs = Refs.tryRef(view.sstables);
            if (refs != null) {
                return new RefViewFragment(view.sstables, view.memtables, refs);
            }
            if (failingSince <= 0L) {
                failingSince = Clock.Global.nanoTime();
                continue;
            }
            if (Clock.Global.nanoTime() - failingSince <= TimeUnit.MILLISECONDS.toNanos(100L)) continue;
            ArrayList<SSTableReader> released = new ArrayList<SSTableReader>();
            for (SSTableReader reader : view.sstables) {
                if (reader.selfRef().globalCount() != 0) continue;
                released.add(reader);
            }
            NoSpamLogger.log(logger, NoSpamLogger.Level.WARN, 1L, TimeUnit.SECONDS, "Spinning trying to capture readers {}, released: {}, ", view.sstables, released);
            failingSince = Clock.Global.nanoTime();
        }
    }

    public ViewFragment select(Function<View, Iterable<SSTableReader>> filter) {
        View view = this.data.getView();
        ArrayList sstables = Lists.newArrayList((Iterable)((Iterable)Objects.requireNonNull(filter.apply((Object)view))));
        return new ViewFragment(sstables, view.getAllMemtables());
    }

    @Override
    public List<String> getSSTablesForKey(String key) {
        return this.getSSTablesForKey(key, false);
    }

    @Override
    public List<String> getSSTablesForKey(String key, boolean hexFormat) {
        ByteBuffer keyBuffer = hexFormat ? ByteBufferUtil.hexToBytes(key) : this.metadata().partitionKeyType.fromString(key);
        DecoratedKey dk = this.decorateKey(keyBuffer);
        try (OpOrder.Group op = this.readOrdering.start();){
            ArrayList<String> files = new ArrayList<String>();
            for (SSTableReader sstr : this.select(View.select((SSTableSet)SSTableSet.LIVE, (DecoratedKey)dk)).sstables) {
                if (sstr.getPosition((PartitionPosition)dk, SSTableReader.Operator.EQ, false) == null) continue;
                files.add(sstr.getFilename());
            }
            ArrayList<String> arrayList = files;
            return arrayList;
        }
    }

    @Override
    public void beginLocalSampling(String sampler, int capacity, int durationMillis) {
        this.metric.samplers.get((Object)Sampler.SamplerType.valueOf(sampler)).beginSampling(capacity, durationMillis);
    }

    @Override
    public List<CompositeData> finishLocalSampling(String sampler, int count) throws OpenDataException {
        Sampler<?> samplerImpl = this.metric.samplers.get((Object)Sampler.SamplerType.valueOf(sampler));
        List<Sampler.Sample<?>> samplerResults = samplerImpl.finishSampling(count);
        ArrayList<CompositeData> result = new ArrayList<CompositeData>(count);
        for (Sampler.Sample<?> counter : samplerResults) {
            result.add(new CompositeDataSupport(COUNTER_COMPOSITE_TYPE, COUNTER_NAMES, new Object[]{this.keyspace.getName() + "." + this.name, counter.count, counter.error, samplerImpl.toString(counter.value)}));
        }
        return result;
    }

    @Override
    public boolean isCompactionDiskSpaceCheckEnabled() {
        return this.compactionSpaceCheck;
    }

    @Override
    public void compactionDiskSpaceCheck(boolean enable) {
        this.compactionSpaceCheck = enable;
    }

    public void cleanupCache() {
        DecoratedKey dk;
        CacheKey key;
        Set ranges = StorageService.instance.getLocalReplicas(this.keyspace.getName()).ranges();
        Iterator keyIter = CacheService.instance.rowCache.keyIterator();
        while (keyIter.hasNext()) {
            key = (RowCacheKey)keyIter.next();
            dk = this.decorateKey(ByteBuffer.wrap(((RowCacheKey)key).key));
            if (!key.sameTable(this.metadata()) || Range.isInRanges(dk.getToken(), ranges)) continue;
            this.invalidateCachedPartition(dk);
        }
        if (this.metadata().isCounter()) {
            keyIter = CacheService.instance.counterCache.keyIterator();
            while (keyIter.hasNext()) {
                key = (CounterCacheKey)keyIter.next();
                dk = this.decorateKey(((CounterCacheKey)key).partitionKey());
                if (!key.sameTable(this.metadata()) || Range.isInRanges(dk.getToken(), ranges)) continue;
                CacheService.instance.counterCache.remove((CounterCacheKey)key);
            }
        }
    }

    public ClusteringComparator getComparator() {
        return this.metadata().comparator;
    }

    public TableSnapshot snapshotWithoutMemtable(String snapshotName) {
        return this.snapshotWithoutMemtable(snapshotName, FBUtilities.now());
    }

    public TableSnapshot snapshotWithoutMemtable(String snapshotName, Instant creationTime) {
        return this.snapshotWithoutMemtable(snapshotName, null, false, null, null, creationTime);
    }

    public TableSnapshot snapshotWithoutMemtable(String snapshotName, Predicate<SSTableReader> predicate, boolean ephemeral, DurationSpec.IntSecondsBound ttl, RateLimiter rateLimiter, Instant creationTime) {
        if (ephemeral && ttl != null) {
            throw new IllegalStateException(String.format("can not take ephemeral snapshot (%s) while ttl is specified too", snapshotName));
        }
        if (rateLimiter == null) {
            rateLimiter = DatabaseDescriptor.getSnapshotRateLimiter();
        }
        LinkedHashSet<SSTableReader> snapshottedSSTables = new LinkedHashSet<SSTableReader>();
        for (ColumnFamilyStore cfs : this.concatWithIndexes()) {
            RefViewFragment currentView = cfs.selectAndReference(View.select(SSTableSet.CANONICAL, (Predicate<SSTableReader>)((Predicate)x -> predicate == null || predicate.apply(x))));
            Throwable throwable = null;
            try {
                for (SSTableReader ssTable : currentView.sstables) {
                    File snapshotDirectory = Directories.getSnapshotDirectory(ssTable.descriptor, snapshotName);
                    ssTable.createLinks(snapshotDirectory.path(), rateLimiter);
                    if (logger.isTraceEnabled()) {
                        logger.trace("Snapshot for {} keyspace data file {} created in {}", new Object[]{this.keyspace, ssTable.getFilename(), snapshotDirectory});
                    }
                    snapshottedSSTables.add(ssTable);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (currentView == null) continue;
                if (throwable != null) {
                    try {
                        currentView.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                currentView.close();
            }
        }
        return this.createSnapshot(snapshotName, ephemeral, ttl, snapshottedSSTables, creationTime);
    }

    protected TableSnapshot createSnapshot(String tag, boolean ephemeral, DurationSpec.IntSecondsBound ttl, Set<SSTableReader> sstables, Instant creationTime) {
        Set snapshotDirs = sstables.stream().map(s -> Directories.getSnapshotDirectory(s.descriptor, tag).toAbsolute()).filter(dir -> !Directories.isSecondaryIndexFolder(dir)).collect(Collectors.toCollection(HashSet::new));
        SnapshotManifest manifest = new SnapshotManifest(this.mapToDataFilenames(sstables), ttl, creationTime);
        File manifestFile = this.getDirectories().getSnapshotManifestFile(tag);
        this.writeSnapshotManifest(manifest, manifestFile);
        snapshotDirs.add(manifestFile.parent().toAbsolute());
        if (!SchemaConstants.isLocalSystemKeyspace(this.metadata.keyspace) && !SchemaConstants.isReplicatedSystemKeyspace(this.metadata.keyspace)) {
            File schemaFile = this.getDirectories().getSnapshotSchemaFile(tag);
            this.writeSnapshotSchema(schemaFile);
            snapshotDirs.add(schemaFile.parent().toAbsolute());
        }
        if (ephemeral) {
            File ephemeralSnapshotMarker = this.getDirectories().getNewEphemeralSnapshotMarkerFile(tag);
            this.createEphemeralSnapshotMarkerFile(tag, ephemeralSnapshotMarker);
            snapshotDirs.add(ephemeralSnapshotMarker.parent().toAbsolute());
        }
        TableSnapshot snapshot = new TableSnapshot(this.metadata.keyspace, this.metadata.name, this.metadata.id.asUUID(), tag, manifest.createdAt, manifest.expiresAt, snapshotDirs);
        StorageService.instance.addSnapshot(snapshot);
        return snapshot;
    }

    private SnapshotManifest writeSnapshotManifest(SnapshotManifest manifest, File manifestFile) {
        try {
            manifestFile.parent().tryCreateDirectories();
            manifest.serializeToJsonFile(manifestFile);
            return manifest;
        }
        catch (IOException e) {
            throw new FSWriteError((Throwable)e, manifestFile);
        }
    }

    private List<String> mapToDataFilenames(Collection<SSTableReader> sstables) {
        return sstables.stream().map(s -> s.descriptor.relativeFilenameFor(Component.DATA)).collect(Collectors.toList());
    }

    private void writeSnapshotSchema(File schemaFile) {
        try {
            if (!schemaFile.parent().exists()) {
                schemaFile.parent().tryCreateDirectories();
            }
            try (PrintStream out = new PrintStream(new FileOutputStreamPlus(schemaFile));){
                SchemaCQLHelper.reCreateStatementsForSchemaCql(this.metadata(), this.keyspace.getMetadata()).forEach(out::println);
            }
        }
        catch (IOException e) {
            throw new FSWriteError((Throwable)e, schemaFile);
        }
    }

    private void createEphemeralSnapshotMarkerFile(String snapshot, File ephemeralSnapshotMarker) {
        try {
            if (!ephemeralSnapshotMarker.parent().exists()) {
                ephemeralSnapshotMarker.parent().tryCreateDirectories();
            }
            Files.createFile(ephemeralSnapshotMarker.toPath(), new FileAttribute[0]);
            if (logger.isTraceEnabled()) {
                logger.trace("Created ephemeral snapshot marker file on {}.", (Object)ephemeralSnapshotMarker.absolutePath());
            }
        }
        catch (IOException e) {
            logger.warn(String.format("Could not create marker file %s for ephemeral snapshot %s. In case there is a failure in the operation that created this snapshot, you may need to clean it manually afterwards.", ephemeralSnapshotMarker.absolutePath(), snapshot), (Throwable)e);
        }
    }

    protected static void clearEphemeralSnapshots(Directories directories) {
        RateLimiter clearSnapshotRateLimiter = DatabaseDescriptor.getSnapshotRateLimiter();
        for (String ephemeralSnapshot : directories.listEphemeralSnapshots()) {
            logger.trace("Clearing ephemeral snapshot {} leftover from previous session.", (Object)ephemeralSnapshot);
            Directories.clearSnapshot(ephemeralSnapshot, directories.getCFDirectories(), clearSnapshotRateLimiter);
        }
    }

    public Refs<SSTableReader> getSnapshotSSTableReaders(String tag) throws IOException {
        HashMap<SSTableId, SSTableReader> active = new HashMap<SSTableId, SSTableReader>();
        for (SSTableReader sstable : this.getSSTables(SSTableSet.CANONICAL)) {
            active.put(sstable.descriptor.id, sstable);
        }
        Map<Descriptor, Set<Component>> snapshots = this.getDirectories().sstableLister(Directories.OnTxnErr.IGNORE).snapshots(tag).list();
        Refs<SSTableReader> refs = new Refs<SSTableReader>();
        try {
            for (Map.Entry<Descriptor, Set<Component>> entries : snapshots.entrySet()) {
                SSTableReader sstable = (SSTableReader)active.get(entries.getKey().id);
                if (sstable == null || !refs.tryRef(sstable)) {
                    if (logger.isTraceEnabled()) {
                        logger.trace("using snapshot sstable {}", (Object)entries.getKey());
                    }
                    sstable = SSTableReader.open(entries.getKey(), entries.getValue(), this.metadata, true, true);
                    refs.tryRef(sstable);
                    sstable.selfRef().release();
                    continue;
                }
                if (!logger.isTraceEnabled()) continue;
                logger.trace("using active sstable {}", (Object)entries.getKey());
            }
        }
        catch (RuntimeException | FSReadError e) {
            refs.release();
            throw e;
        }
        return refs;
    }

    public TableSnapshot snapshot(String snapshotName) {
        return this.snapshot(snapshotName, null);
    }

    public TableSnapshot snapshot(String snapshotName, DurationSpec.IntSecondsBound ttl) {
        return this.snapshot(snapshotName, false, ttl, null, FBUtilities.now());
    }

    public TableSnapshot snapshot(String snapshotName, boolean skipMemtable, DurationSpec.IntSecondsBound ttl, RateLimiter rateLimiter, Instant creationTime) {
        return this.snapshot(snapshotName, null, false, skipMemtable, ttl, rateLimiter, creationTime);
    }

    public TableSnapshot snapshot(String snapshotName, Predicate<SSTableReader> predicate, boolean ephemeral, boolean skipMemtable) {
        return this.snapshot(snapshotName, predicate, ephemeral, skipMemtable, null, null, FBUtilities.now());
    }

    public TableSnapshot snapshot(String snapshotName, Predicate<SSTableReader> predicate, boolean ephemeral, boolean skipMemtable, DurationSpec.IntSecondsBound ttl, RateLimiter rateLimiter, Instant creationTime) {
        Memtable current;
        if (!skipMemtable && !(current = this.getTracker().getView().getCurrentMemtable()).isClean()) {
            if (current.shouldSwitch(FlushReason.SNAPSHOT)) {
                FBUtilities.waitOnFuture(this.switchMemtableIfCurrent(current, FlushReason.SNAPSHOT));
            } else {
                current.performSnapshot(snapshotName);
            }
        }
        return this.snapshotWithoutMemtable(snapshotName, predicate, ephemeral, ttl, rateLimiter, creationTime);
    }

    public boolean snapshotExists(String snapshotName) {
        return this.getDirectories().snapshotExists(snapshotName);
    }

    public void clearSnapshot(String snapshotName) {
        RateLimiter clearSnapshotRateLimiter = DatabaseDescriptor.getSnapshotRateLimiter();
        List<File> snapshotDirs = this.getDirectories().getCFDirectories();
        Directories.clearSnapshot(snapshotName, snapshotDirs, clearSnapshotRateLimiter);
    }

    public Map<String, TableSnapshot> listSnapshots() {
        return this.getDirectories().listSnapshots();
    }

    public CachedPartition getRawCachedPartition(DecoratedKey key) {
        if (!this.isRowCacheEnabled()) {
            return null;
        }
        IRowCacheEntry cached = (IRowCacheEntry)CacheService.instance.rowCache.getInternal(new RowCacheKey(this.metadata(), key));
        return cached == null || cached instanceof RowCacheSentinel ? null : (CachedPartition)cached;
    }

    private void invalidateCaches() {
        CacheService.instance.invalidateKeyCacheForCf(this.metadata());
        CacheService.instance.invalidateRowCacheForCf(this.metadata());
        if (this.metadata().isCounter()) {
            CacheService.instance.invalidateCounterCacheForCf(this.metadata());
        }
    }

    public int invalidateRowCache(Collection<Bounds<Token>> boundsToInvalidate) {
        int invalidatedKeys = 0;
        Iterator keyIter = CacheService.instance.rowCache.keyIterator();
        while (keyIter.hasNext()) {
            RowCacheKey key = (RowCacheKey)keyIter.next();
            DecoratedKey dk = this.decorateKey(ByteBuffer.wrap(key.key));
            if (!key.sameTable(this.metadata()) || !Bounds.isInBounds(dk.getToken(), boundsToInvalidate)) continue;
            this.invalidateCachedPartition(dk);
            ++invalidatedKeys;
        }
        return invalidatedKeys;
    }

    public int invalidateCounterCache(Collection<Bounds<Token>> boundsToInvalidate) {
        int invalidatedKeys = 0;
        Iterator keyIter = CacheService.instance.counterCache.keyIterator();
        while (keyIter.hasNext()) {
            CounterCacheKey key = (CounterCacheKey)keyIter.next();
            DecoratedKey dk = this.decorateKey(key.partitionKey());
            if (!key.sameTable(this.metadata()) || !Bounds.isInBounds(dk.getToken(), boundsToInvalidate)) continue;
            CacheService.instance.counterCache.remove(key);
            ++invalidatedKeys;
        }
        return invalidatedKeys;
    }

    public boolean containsCachedParition(DecoratedKey key) {
        return CacheService.instance.rowCache.getCapacity() != 0L && CacheService.instance.rowCache.containsKey(new RowCacheKey(this.metadata(), key));
    }

    public void invalidateCachedPartition(RowCacheKey key) {
        CacheService.instance.rowCache.remove(key);
    }

    public void invalidateCachedPartition(DecoratedKey key) {
        if (!this.isRowCacheEnabled()) {
            return;
        }
        this.invalidateCachedPartition(new RowCacheKey(this.metadata(), key));
    }

    public ClockAndCount getCachedCounter(ByteBuffer partitionKey, Clustering<?> clustering, ColumnMetadata column, CellPath path) {
        if (CacheService.instance.counterCache.getCapacity() == 0L) {
            return null;
        }
        return (ClockAndCount)CacheService.instance.counterCache.get(CounterCacheKey.create(this.metadata(), partitionKey, clustering, column, path));
    }

    public void putCachedCounter(ByteBuffer partitionKey, Clustering<?> clustering, ColumnMetadata column, CellPath path, ClockAndCount clockAndCount) {
        if (CacheService.instance.counterCache.getCapacity() == 0L) {
            return;
        }
        CacheService.instance.counterCache.put(CounterCacheKey.create(this.metadata(), partitionKey, clustering, column, path), clockAndCount);
    }

    public void forceMajorCompaction() {
        this.forceMajorCompaction(false);
    }

    @Override
    public void forceMajorCompaction(boolean splitOutput) {
        CompactionManager.instance.performMaximal(this, splitOutput);
    }

    @Override
    public void forceCompactionForTokenRange(Collection<Range<Token>> tokenRanges) throws ExecutionException, InterruptedException {
        CompactionManager.instance.forceCompactionForTokenRange(this, tokenRanges);
    }

    @Override
    public void forceCompactionForTokenRanges(String ... strings) {
        CompactionManager.instance.forceCompactionForTokenRange(this, ColumnFamilyStore.toTokenRanges(DatabaseDescriptor.getPartitioner(), strings));
    }

    static Set<Range<Token>> toTokenRanges(IPartitioner partitioner, String ... strings) {
        Token.TokenFactory tokenFactory = partitioner.getTokenFactory();
        HashSet<Range<Token>> tokenRanges = new HashSet<Range<Token>>();
        for (String str : strings) {
            String[] splits = str.split(TOKEN_DELIMITER);
            assert (splits.length == 2) : String.format("Unable to parse token range %s; needs to have two tokens separated by %s", str, ":");
            String lhsStr = splits[0];
            assert (!Strings.isNullOrEmpty((String)lhsStr)) : String.format("Unable to parse token range %s; left hand side of the token separater is empty", str);
            String rhsStr = splits[1];
            assert (!Strings.isNullOrEmpty((String)rhsStr)) : String.format("Unable to parse token range %s; right hand side of the token separater is empty", str);
            Token lhs = tokenFactory.fromString(lhsStr);
            Token rhs = tokenFactory.fromString(rhsStr);
            tokenRanges.add(new Range<Token>(lhs, rhs));
        }
        return tokenRanges;
    }

    public void forceCompactionForKey(DecoratedKey key) {
        CompactionManager.instance.forceCompactionForKey(this, key);
    }

    public static Iterable<ColumnFamilyStore> all() {
        ArrayList<Collection<ColumnFamilyStore>> stores = new ArrayList<Collection<ColumnFamilyStore>>(Schema.instance.getKeyspaces().size());
        for (Keyspace keyspace : Keyspace.all()) {
            stores.add(keyspace.getColumnFamilyStores());
        }
        return Iterables.concat(stores);
    }

    public Iterable<DecoratedKey> keySamples(Range<Token> range) {
        try (RefViewFragment view = this.selectAndReference(View.selectFunction(SSTableSet.CANONICAL));){
            Iterable[] samples = new Iterable[view.sstables.size()];
            int i = 0;
            for (SSTableReader sstable : view.sstables) {
                samples[i++] = sstable.getKeySamples(range);
            }
            Iterable iterable = Iterables.concat((Iterable[])samples);
            return iterable;
        }
    }

    public long estimatedKeysForRange(Range<Token> range) {
        try (RefViewFragment view = this.selectAndReference(View.selectFunction(SSTableSet.CANONICAL));){
            long count = 0L;
            for (SSTableReader sstable : view.sstables) {
                count += sstable.estimatedKeysForRanges(Collections.singleton(range));
            }
            long l = count;
            return l;
        }
    }

    public void writeAndAddMemtableRanges(TimeUUID repairSessionID, Supplier<Collection<Range<PartitionPosition>>> rangesSupplier, Refs<SSTableReader> placeIntoRefs) {
        SSTableMultiWriter memtableContent = this.writeMemtableRanges(rangesSupplier, repairSessionID);
        if (memtableContent != null) {
            try {
                Collection<SSTableReader> sstables = memtableContent.finish(true);
                try (Refs<SSTableReader> sstableReferences = Refs.ref(sstables);){
                    placeIntoRefs.addAll(sstableReferences);
                }
                for (SSTableReader rdr : sstables) {
                    rdr.selfRef().release();
                    logger.info("Memtable ranges (keys {} size {}) written in {}", new Object[]{rdr.estimatedKeys(), rdr.getDataChannel().size(), rdr});
                }
            }
            catch (Throwable t) {
                memtableContent.close();
                Throwables.propagate((Throwable)t);
            }
        }
    }

    private SSTableMultiWriter writeMemtableRanges(Supplier<Collection<Range<PartitionPosition>>> rangesSupplier, TimeUUID repairSessionID) {
        if (!this.streamFromMemtable()) {
            return null;
        }
        Collection<Range<PartitionPosition>> ranges = rangesSupplier.get();
        Memtable current = this.getTracker().getView().getCurrentMemtable();
        if (current.isClean()) {
            return null;
        }
        ArrayList dataSets = new ArrayList(ranges.size());
        long keys = 0L;
        for (Range<PartitionPosition> range : ranges) {
            Memtable.FlushablePartitionSet<?> dataSet = current.getFlushSet((PartitionPosition)range.left, (PartitionPosition)range.right);
            dataSets.add(dataSet);
            keys += dataSet.partitionCount();
        }
        if (keys == 0L) {
            return null;
        }
        Memtable.FlushablePartitionSet firstDataSet = (Memtable.FlushablePartitionSet)dataSets.get(0);
        SSTableMultiWriter writer = this.createSSTableMultiWriter(this.newSSTableDescriptor(this.directories.getDirectoryForNewSSTables()), keys, 0L, repairSessionID, false, 0, new SerializationHeader(true, firstDataSet.metadata(), firstDataSet.columns(), firstDataSet.encodingStats()), DO_NOT_TRACK);
        try {
            for (Memtable.FlushablePartitionSet flushablePartitionSet : dataSets) {
                new Flushing.FlushRunnable(flushablePartitionSet, writer, this.metric, false).call();
            }
            return writer;
        }
        catch (Error | RuntimeException t) {
            writer.abort(t);
            throw t;
        }
    }

    @VisibleForTesting
    public void clearUnsafe() {
        for (ColumnFamilyStore cfs : this.concatWithIndexes()) {
            cfs.runWithCompactionsDisabled(() -> {
                cfs.data.reset(this.memtableFactory.create(new AtomicReference<CommitLogPosition>(CommitLogPosition.NONE), cfs.metadata, cfs));
                return null;
            }, true, false);
        }
    }

    public void truncateBlocking() {
        this.truncateBlocking(false);
    }

    public void truncateBlockingWithoutSnapshot() {
        this.truncateBlocking(true);
    }

    private void truncateBlocking(final boolean noSnapshot) {
        CommitLogPosition replayAfter;
        logger.info("Truncating {}.{}", (Object)this.keyspace.getName(), (Object)this.name);
        this.viewManager.stopBuild();
        if (!noSnapshot && (this.keyspace.getMetadata().params.durableWrites && !this.memtableWritesAreDurable() || DatabaseDescriptor.isAutoSnapshot())) {
            replayAfter = this.forceBlockingFlush(FlushReason.TRUNCATE);
            this.viewManager.forceBlockingFlush(FlushReason.TRUNCATE);
        } else {
            this.viewManager.dumpMemtables();
            replayAfter = FBUtilities.waitOnFuture(this.dumpMemtable());
        }
        long now = Clock.Global.currentTimeMillis();
        for (ColumnFamilyStore cfs : this.concatWithIndexes()) {
            for (SSTableReader sstable : cfs.getLiveSSTables()) {
                now = Math.max(now, sstable.maxDataAge);
            }
        }
        final long truncatedAt = now;
        Runnable truncateRunnable = new Runnable(){

            @Override
            public void run() {
                logger.info("Truncating {}.{} with truncatedAt={}", new Object[]{ColumnFamilyStore.this.keyspace.getName(), ColumnFamilyStore.this.getTableName(), truncatedAt});
                ActiveRepairService.instance.abort(prs -> prs.getTableIds().contains(ColumnFamilyStore.this.metadata.id), "Stopping parent sessions {} due to truncation of tableId=" + ColumnFamilyStore.this.metadata.id);
                ColumnFamilyStore.this.data.notifyTruncated(truncatedAt);
                if (!noSnapshot && DatabaseDescriptor.isAutoSnapshot()) {
                    ColumnFamilyStore.this.snapshot(Keyspace.getTimestampedSnapshotNameWithPrefix(ColumnFamilyStore.this.name, ColumnFamilyStore.SNAPSHOT_TRUNCATE_PREFIX), DatabaseDescriptor.getAutoSnapshotTtl());
                }
                ColumnFamilyStore.this.discardSSTables(truncatedAt);
                ColumnFamilyStore.this.indexManager.truncateAllIndexesBlocking(truncatedAt);
                ColumnFamilyStore.this.viewManager.truncateBlocking(replayAfter, truncatedAt);
                SystemKeyspace.saveTruncationRecord(ColumnFamilyStore.this, truncatedAt, replayAfter);
                logger.trace("cleaning out row cache");
                ColumnFamilyStore.this.invalidateCaches();
            }
        };
        this.runWithCompactionsDisabled(FutureTask.callable(truncateRunnable), true, true);
        this.viewManager.build();
        logger.info("Truncate of {}.{} is complete", (Object)this.keyspace.getName(), (Object)this.name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<CommitLogPosition> dumpMemtable() {
        Tracker tracker = this.data;
        synchronized (tracker) {
            Flush flush = new Flush(true);
            flushExecutor.execute(flush);
            postFlushExecutor.execute(flush.postFlushTask);
            return flush.postFlushTask;
        }
    }

    public void unloadCf() {
        if (this.keyspace.getMetadata().params.durableWrites && !this.memtableWritesAreDurable()) {
            this.forceBlockingFlush(FlushReason.DROP);
        } else {
            FBUtilities.waitOnFuture(this.dumpMemtable());
        }
    }

    public <V> V runWithCompactionsDisabled(Callable<V> callable, boolean interruptValidation, boolean interruptViews) {
        return this.runWithCompactionsDisabled(callable, (Predicate<SSTableReader>)((Predicate)sstable -> true), interruptValidation, interruptViews, true);
    }

    /*
     * Exception decompiling
     */
    public <V> V runWithCompactionsDisabled(Callable<V> callable, Predicate<SSTableReader> sstablesPredicate, boolean interruptValidation, boolean interruptViews, boolean interruptIndexes) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 31[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static CompactionManager.CompactionPauser pauseCompactionStrategies(Iterable<ColumnFamilyStore> toPause) {
        ArrayList<ColumnFamilyStore> successfullyPaused = new ArrayList<ColumnFamilyStore>();
        try {
            for (ColumnFamilyStore cfs : toPause) {
                successfullyPaused.ensureCapacity(successfullyPaused.size() + 1);
                cfs.getCompactionStrategyManager().pause();
                successfullyPaused.add(cfs);
            }
            return () -> org.apache.cassandra.utils.Throwables.maybeFail(ColumnFamilyStore.resumeAll(null, toPause));
        }
        catch (Throwable t) {
            ColumnFamilyStore.resumeAll(t, successfullyPaused);
            throw t;
        }
    }

    private static Throwable resumeAll(Throwable accumulate, Iterable<ColumnFamilyStore> cfss) {
        for (ColumnFamilyStore cfs : cfss) {
            try {
                cfs.getCompactionStrategyManager().resume();
            }
            catch (Throwable t) {
                accumulate = org.apache.cassandra.utils.Throwables.merge(accumulate, t);
            }
        }
        return accumulate;
    }

    public LifecycleTransaction markAllCompacting(OperationType operationType) {
        Callable<LifecycleTransaction> callable = () -> {
            assert (this.data.getCompacting().isEmpty()) : this.data.getCompacting();
            Collection<SSTableReader> sstables = this.getLiveSSTables();
            sstables = AbstractCompactionStrategy.filterSuspectSSTables(sstables);
            LifecycleTransaction modifier = this.data.tryModify(sstables, operationType);
            assert (modifier != null) : "something marked things compacting while compactions are disabled";
            return modifier;
        };
        return this.runWithCompactionsDisabled(callable, false, false);
    }

    public String toString() {
        return "CFS(Keyspace='" + this.keyspace.getName() + '\'' + ", ColumnFamily='" + this.name + '\'' + ')';
    }

    public void disableAutoCompaction() {
        this.compactionStrategyManager.disable();
    }

    public void enableAutoCompaction() {
        this.enableAutoCompaction(false);
    }

    @VisibleForTesting
    public void enableAutoCompaction(boolean waitForFutures) {
        this.compactionStrategyManager.enable();
        List<Future<?>> futures = CompactionManager.instance.submitBackground(this);
        if (waitForFutures) {
            FBUtilities.waitOnFutures(futures);
        }
    }

    @Override
    public boolean isAutoCompactionDisabled() {
        return !this.compactionStrategyManager.isEnabled();
    }

    public CompactionStrategyManager getCompactionStrategyManager() {
        return this.compactionStrategyManager;
    }

    @Override
    public void setCrcCheckChance(double crcCheckChance) {
        try {
            TableParams.builder().crcCheckChance(crcCheckChance).build().validate();
            for (ColumnFamilyStore cfs : this.concatWithIndexes()) {
                cfs.crcCheckChance.set(crcCheckChance);
                for (SSTableReader sstable : cfs.getSSTables(SSTableSet.LIVE)) {
                    sstable.setCrcCheckChance(crcCheckChance);
                }
            }
        }
        catch (ConfigurationException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public Double getCrcCheckChance() {
        return this.crcCheckChance.value();
    }

    @Override
    public void setCompactionThresholds(int minThreshold, int maxThreshold) {
        this.validateCompactionThresholds(minThreshold, maxThreshold);
        this.minCompactionThreshold.set(minThreshold);
        this.maxCompactionThreshold.set(maxThreshold);
        CompactionManager.instance.submitBackground(this);
    }

    @Override
    public int getMinimumCompactionThreshold() {
        return this.minCompactionThreshold.value();
    }

    @Override
    public void setMinimumCompactionThreshold(int minCompactionThreshold) {
        this.validateCompactionThresholds(minCompactionThreshold, this.maxCompactionThreshold.value());
        this.minCompactionThreshold.set(minCompactionThreshold);
    }

    @Override
    public int getMaximumCompactionThreshold() {
        return this.maxCompactionThreshold.value();
    }

    @Override
    public void setMaximumCompactionThreshold(int maxCompactionThreshold) {
        this.validateCompactionThresholds(this.minCompactionThreshold.value(), maxCompactionThreshold);
        this.maxCompactionThreshold.set(maxCompactionThreshold);
    }

    private void validateCompactionThresholds(int minThreshold, int maxThreshold) {
        if (minThreshold > maxThreshold) {
            throw new RuntimeException(String.format("The min_compaction_threshold cannot be larger than the max_compaction_threshold. Min is '%d', Max is '%d'.", minThreshold, maxThreshold));
        }
        if (maxThreshold == 0 || minThreshold == 0) {
            throw new RuntimeException("Disabling compaction by setting min_compaction_threshold or max_compaction_threshold to 0 is deprecated, set the compaction strategy option 'enabled' to 'false' instead or use the nodetool command 'disableautocompaction'.");
        }
    }

    public int getMeanEstimatedCellPerPartitionCount() {
        long sum = 0L;
        long count = 0L;
        for (SSTableReader sstable : this.getSSTables(SSTableSet.CANONICAL)) {
            long n = sstable.getEstimatedCellPerPartitionCount().count();
            sum += sstable.getEstimatedCellPerPartitionCount().mean() * n;
            count += n;
        }
        return count > 0L ? (int)(sum / count) : 0;
    }

    public double getMeanPartitionSize() {
        long sum = 0L;
        long count = 0L;
        for (SSTableReader sstable : this.getSSTables(SSTableSet.CANONICAL)) {
            long n = sstable.getEstimatedPartitionSize().count();
            sum += sstable.getEstimatedPartitionSize().mean() * n;
            count += n;
        }
        return count > 0L ? (double)sum * 1.0 / (double)count : 0.0;
    }

    public int getMeanRowCount() {
        long totalRows = 0L;
        long totalPartitions = 0L;
        for (SSTableReader sstable : this.getSSTables(SSTableSet.CANONICAL)) {
            totalPartitions += sstable.getEstimatedPartitionSize().count();
            totalRows += sstable.getTotalRows();
        }
        return totalPartitions > 0L ? (int)(totalRows / totalPartitions) : 0;
    }

    @Override
    public long estimateKeys() {
        long n = 0L;
        for (SSTableReader sstable : this.getSSTables(SSTableSet.CANONICAL)) {
            n += sstable.estimatedKeys();
        }
        return n;
    }

    public IPartitioner getPartitioner() {
        return this.metadata().partitioner;
    }

    public DecoratedKey decorateKey(ByteBuffer key) {
        return this.getPartitioner().decorateKey(key);
    }

    public boolean isIndex() {
        return this.metadata().isIndex();
    }

    public Iterable<ColumnFamilyStore> concatWithIndexes() {
        return Iterables.concat(Collections.singleton(this), this.indexManager.getAllIndexColumnFamilyStores());
    }

    @Override
    public List<String> getBuiltIndexes() {
        return this.indexManager.getBuiltIndexNames();
    }

    @Override
    public int getUnleveledSSTables() {
        return this.compactionStrategyManager.getUnleveledSSTables();
    }

    @Override
    public int[] getSSTableCountPerLevel() {
        return this.compactionStrategyManager.getSSTableCountPerLevel();
    }

    @Override
    public long[] getPerLevelSizeBytes() {
        return this.compactionStrategyManager.getPerLevelSizeBytes();
    }

    @Override
    public int getLevelFanoutSize() {
        return this.compactionStrategyManager.getLevelFanoutSize();
    }

    public boolean isEmpty() {
        return this.data.getView().isEmpty();
    }

    public boolean isRowCacheEnabled() {
        boolean retval;
        boolean bl = retval = this.metadata().params.caching.cacheRows() && CacheService.instance.rowCache.getCapacity() > 0L;
        assert (!retval || !this.isIndex());
        return retval;
    }

    public boolean isCounterCacheEnabled() {
        return this.metadata().isCounter() && CacheService.instance.counterCache.getCapacity() > 0L;
    }

    public boolean isKeyCacheEnabled() {
        return this.metadata().params.caching.cacheKeys() && CacheService.instance.keyCache.getCapacity() > 0L;
    }

    public void discardSSTables(long truncatedAt) {
        assert (this.data.getCompacting().isEmpty()) : this.data.getCompacting();
        ArrayList<SSTableReader> truncatedSSTables = new ArrayList<SSTableReader>();
        int keptSSTables = 0;
        for (SSTableReader sstable : this.getSSTables(SSTableSet.LIVE)) {
            if (!sstable.newSince(truncatedAt)) {
                truncatedSSTables.add(sstable);
                continue;
            }
            ++keptSSTables;
            logger.info("Truncation is keeping {} maxDataAge={} truncatedAt={}", new Object[]{sstable, sstable.maxDataAge, truncatedAt});
        }
        if (!truncatedSSTables.isEmpty()) {
            logger.info("Truncation is dropping {} sstables and keeping {} due to sstable.maxDataAge > truncatedAt", (Object)truncatedSSTables.size(), (Object)keptSSTables);
            this.markObsolete(truncatedSSTables, OperationType.UNKNOWN);
        }
    }

    @Override
    public double getDroppableTombstoneRatio() {
        double allDroppable = 0.0;
        long allColumns = 0L;
        int localTime = (int)(Clock.Global.currentTimeMillis() / 1000L);
        for (SSTableReader sstable : this.getSSTables(SSTableSet.LIVE)) {
            allDroppable += sstable.getDroppableTombstonesBefore(localTime - this.metadata().params.gcGraceSeconds);
            allColumns += sstable.getEstimatedCellPerPartitionCount().mean() * sstable.getEstimatedCellPerPartitionCount().count();
        }
        return allColumns > 0L ? allDroppable / (double)allColumns : 0.0;
    }

    @Override
    public long trueSnapshotsSize() {
        return this.getDirectories().trueSnapshotsSize();
    }

    public static ColumnFamilyStore getIfExists(TableId id) {
        TableMetadata metadata = Schema.instance.getTableMetadata(id);
        if (metadata == null) {
            return null;
        }
        Keyspace keyspace = Keyspace.open(metadata.keyspace);
        if (keyspace == null) {
            return null;
        }
        return keyspace.hasColumnFamilyStore(id) ? keyspace.getColumnFamilyStore(id) : null;
    }

    public static ColumnFamilyStore getIfExists(String ksName, String cfName) {
        if (ksName == null || cfName == null) {
            return null;
        }
        Keyspace keyspace = Keyspace.open(ksName);
        if (keyspace == null) {
            return null;
        }
        TableMetadata table = Schema.instance.getTableMetadata(ksName, cfName);
        if (table == null) {
            return null;
        }
        return keyspace.getColumnFamilyStore(table.id);
    }

    public static TableMetrics metricsFor(TableId tableId) {
        return Objects.requireNonNull(ColumnFamilyStore.getIfExists((TableId)tableId)).metric;
    }

    public DiskBoundaries getDiskBoundaries() {
        return this.diskBoundaryManager.getDiskBoundaries(this);
    }

    public void invalidateLocalRanges() {
        this.diskBoundaryManager.invalidate();
        this.switchMemtableOrNotify(FlushReason.OWNED_RANGES_CHANGE, Memtable::localRangesUpdated);
    }

    @Override
    public void setNeverPurgeTombstones(boolean value) {
        if (this.neverPurgeTombstones != value) {
            logger.info("Changing neverPurgeTombstones for {}.{} from {} to {}", new Object[]{this.keyspace.getName(), this.getTableName(), this.neverPurgeTombstones, value});
        } else {
            logger.info("Not changing neverPurgeTombstones for {}.{}, it is {}", new Object[]{this.keyspace.getName(), this.getTableName(), this.neverPurgeTombstones});
        }
        this.neverPurgeTombstones = value;
    }

    @Override
    public boolean getNeverPurgeTombstones() {
        return this.neverPurgeTombstones;
    }

    void onTableDropped() {
        this.indexManager.markAllIndexesRemoved();
        CompactionManager.instance.interruptCompactionForCFs(this.concatWithIndexes(), sstable -> true, true);
        if (DatabaseDescriptor.isAutoSnapshot()) {
            this.snapshot(Keyspace.getTimestampedSnapshotNameWithPrefix(this.name, SNAPSHOT_DROP_PREFIX), DatabaseDescriptor.getAutoSnapshotTtl());
        }
        CommitLog.instance.forceRecycleAllSegments(Collections.singleton(this.metadata.id));
        this.compactionStrategyManager.shutdown();
        Keyspace.writeOrder.awaitNewBarrier();
        this.readOrdering.awaitNewBarrier();
    }

    @Override
    public boolean hasMisplacedSSTables() {
        if (!this.getPartitioner().splitter().isPresent()) {
            return false;
        }
        DiskBoundaries diskBoundaries = this.getDiskBoundaries();
        for (SSTableReader sstable : this.getSSTables(SSTableSet.CANONICAL)) {
            Directories.DataDirectory dataDirectory;
            if (diskBoundaries.isInCorrectLocation(sstable, dataDirectory = this.getDirectories().getDataDirectoryForFile(sstable.descriptor))) continue;
            return true;
        }
        return false;
    }

    @Override
    public Map<String, Long> getTopSizePartitions() {
        if (this.topPartitions == null) {
            return Collections.emptyMap();
        }
        return this.topPartitions.getTopSizePartitionMap();
    }

    @Override
    public Long getTopSizePartitionsLastUpdate() {
        if (this.topPartitions == null) {
            return null;
        }
        return this.topPartitions.topSizes().lastUpdate;
    }

    @Override
    public Map<String, Long> getTopTombstonePartitions() {
        if (this.topPartitions == null) {
            return Collections.emptyMap();
        }
        return this.topPartitions.getTopTombstonePartitionMap();
    }

    @Override
    public Long getTopTombstonePartitionsLastUpdate() {
        if (this.topPartitions == null) {
            return null;
        }
        return this.topPartitions.topTombstones().lastUpdate;
    }

    static {
        try {
            OpenType[] counterTypes = new OpenType[]{SimpleType.STRING, SimpleType.LONG, SimpleType.LONG, SimpleType.STRING};
            COUNTER_COMPOSITE_TYPE = new CompositeType(SAMPLING_RESULTS_NAME, SAMPLING_RESULTS_NAME, COUNTER_NAMES, COUNTER_DESCS, counterTypes);
        }
        catch (OpenDataException e) {
            throw new RuntimeException(e);
        }
        DO_NOT_TRACK = new LifecycleNewTracker(){

            @Override
            public void trackNew(SSTable table) {
            }

            @Override
            public void untrackNew(SSTable table) {
            }

            @Override
            public OperationType opType() {
                return OperationType.FLUSH;
            }
        };
    }

    private static final class PerDiskFlushExecutors {
        private final ExecutorPlus[] nonLocalSystemflushExecutors;
        private final ExecutorPlus[] localSystemDiskFlushExecutors;
        private final boolean useSpecificExecutorForSystemKeyspaces;

        public PerDiskFlushExecutors(int flushWriters, String[] locationsForNonSystemKeyspaces, boolean useSpecificLocationForSystemKeyspaces) {
            ExecutorPlus[] executorPlusArray;
            ExecutorPlus[] flushExecutors = PerDiskFlushExecutors.createPerDiskFlushWriters(locationsForNonSystemKeyspaces.length, flushWriters);
            this.nonLocalSystemflushExecutors = flushExecutors;
            this.useSpecificExecutorForSystemKeyspaces = useSpecificLocationForSystemKeyspaces;
            if (useSpecificLocationForSystemKeyspaces) {
                ExecutorPlus[] executorPlusArray2 = new ExecutorPlus[1];
                executorPlusArray = executorPlusArray2;
                executorPlusArray2[0] = PerDiskFlushExecutors.newThreadPool("LocalSystemKeyspacesDiskMemtableFlushWriter", flushWriters);
            } else {
                ExecutorPlus[] executorPlusArray3 = new ExecutorPlus[1];
                executorPlusArray = executorPlusArray3;
                executorPlusArray3[0] = flushExecutors[0];
            }
            this.localSystemDiskFlushExecutors = executorPlusArray;
        }

        private static ExecutorPlus[] createPerDiskFlushWriters(int numberOfExecutors, int flushWriters) {
            ExecutorPlus[] flushExecutors = new ExecutorPlus[numberOfExecutors];
            for (int i = 0; i < numberOfExecutors; ++i) {
                flushExecutors[i] = PerDiskFlushExecutors.newThreadPool("PerDiskMemtableFlushWriter_" + i, flushWriters);
            }
            return flushExecutors;
        }

        private static ExecutorPlus newThreadPool(String poolName, int size) {
            return ExecutorFactory.Global.executorFactory().withJmxInternal().pooled(poolName, size);
        }

        public ExecutorPlus[] getExecutorsFor(String keyspaceName, String tableName) {
            return Directories.isStoredInLocalSystemKeyspacesDataLocation(keyspaceName, tableName) ? this.localSystemDiskFlushExecutors : this.nonLocalSystemflushExecutors;
        }

        public void appendAllExecutors(Collection<ExecutorService> collection) {
            Collections.addAll(collection, this.nonLocalSystemflushExecutors);
            if (this.useSpecificExecutorForSystemKeyspaces) {
                Collections.addAll(collection, this.localSystemDiskFlushExecutors);
            }
        }
    }

    public static class RefViewFragment
    extends ViewFragment
    implements AutoCloseable {
        public final Refs<SSTableReader> refs;

        public RefViewFragment(List<SSTableReader> sstables, Iterable<Memtable> memtables, Refs<SSTableReader> refs) {
            super(sstables, memtables);
            this.refs = refs;
        }

        public void release() {
            this.refs.release();
        }

        @Override
        public void close() {
            this.refs.release();
        }
    }

    public static class ViewFragment {
        public final List<SSTableReader> sstables;
        public final Iterable<Memtable> memtables;

        public ViewFragment(List<SSTableReader> sstables, Iterable<Memtable> memtables) {
            this.sstables = sstables;
            this.memtables = memtables;
        }
    }

    private final class Flush
    implements Runnable {
        final OpOrder.Barrier writeBarrier;
        final Map<ColumnFamilyStore, Memtable> memtables;
        final FutureTask<CommitLogPosition> postFlushTask;
        final PostFlush postFlush;
        final boolean truncate;

        private Flush(boolean truncate) {
            if (logger.isTraceEnabled()) {
                logger.trace("Creating flush task {}@{}", (Object)this.hashCode(), (Object)ColumnFamilyStore.this.name);
            }
            this.truncate = truncate;
            ColumnFamilyStore.this.metric.pendingFlushes.inc();
            this.writeBarrier = Keyspace.writeOrder.newBarrier();
            this.memtables = new LinkedHashMap<ColumnFamilyStore, Memtable>();
            AtomicReference<CommitLogPosition> commitLogUpperBound = new AtomicReference<CommitLogPosition>();
            for (ColumnFamilyStore cfs : ColumnFamilyStore.this.concatWithIndexes()) {
                Memtable newMemtable = cfs.createMemtable(commitLogUpperBound);
                Memtable oldMemtable = cfs.data.switchMemtable(truncate, newMemtable);
                oldMemtable.switchOut(this.writeBarrier, commitLogUpperBound);
                this.memtables.put(cfs, oldMemtable);
            }
            ColumnFamilyStore.setCommitLogUpperBound(commitLogUpperBound);
            this.writeBarrier.issue();
            this.postFlush = new PostFlush((Memtable)Iterables.get(this.memtables.values(), (int)0, null));
            this.postFlushTask = new FutureTask<CommitLogPosition>(this.postFlush);
        }

        @Override
        public void run() {
            if (logger.isTraceEnabled()) {
                logger.trace("Flush task {}@{} starts executing, waiting on barrier", (Object)this.hashCode(), (Object)ColumnFamilyStore.this.name);
            }
            long start = Clock.Global.nanoTime();
            this.writeBarrier.markBlocking();
            this.writeBarrier.await();
            if (logger.isTraceEnabled()) {
                logger.trace("Flush task for task {}@{} waited {} ms at the barrier", new Object[]{this.hashCode(), ColumnFamilyStore.this.name, TimeUnit.NANOSECONDS.toMillis(Clock.Global.nanoTime() - start)});
            }
            for (Map.Entry<ColumnFamilyStore, Memtable> entry : this.memtables.entrySet()) {
                entry.getKey().data.markFlushing(entry.getValue());
            }
            ColumnFamilyStore.this.metric.memtableSwitchCount.inc();
            try {
                boolean first = true;
                for (Map.Entry<ColumnFamilyStore, Memtable> entry : this.memtables.entrySet()) {
                    this.flushMemtable(entry.getKey(), entry.getValue(), first);
                    first = false;
                }
            }
            catch (Throwable t) {
                JVMStabilityInspector.inspectThrowable(t);
                this.postFlush.flushFailure = t;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("Flush task {}@{} signaling post flush task", (Object)this.hashCode(), (Object)ColumnFamilyStore.this.name);
            }
            this.postFlush.latch.decrement();
            if (logger.isTraceEnabled()) {
                logger.trace("Flush task task {}@{} finished", (Object)this.hashCode(), (Object)ColumnFamilyStore.this.name);
            }
        }

        public Collection<SSTableReader> flushMemtable(ColumnFamilyStore cfs, Memtable memtable, boolean flushNonCf2i) {
            if (logger.isTraceEnabled()) {
                logger.trace("Flush task task {}@{} flushing memtable {}", new Object[]{this.hashCode(), ColumnFamilyStore.this.name, memtable});
            }
            if (memtable.isClean() || this.truncate) {
                cfs.replaceFlushed(memtable, Collections.emptyList());
                this.reclaim(memtable);
                return Collections.emptyList();
            }
            ArrayList futures = new ArrayList();
            long totalBytesOnDisk = 0L;
            long maxBytesOnDisk = 0L;
            long minBytesOnDisk = Long.MAX_VALUE;
            ArrayList<SSTableReader> sstables = new ArrayList<SSTableReader>();
            try (LifecycleTransaction txn = LifecycleTransaction.offline(OperationType.FLUSH);){
                List<Flushing.FlushRunnable> flushRunnables = null;
                ArrayList flushResults = null;
                try {
                    flushRunnables = Flushing.flushRunnables(cfs, memtable, txn);
                    ExecutorPlus[] executors = perDiskflushExecutors.getExecutorsFor(ColumnFamilyStore.this.keyspace.getName(), ColumnFamilyStore.this.name);
                    for (int i = 0; i < flushRunnables.size(); ++i) {
                        futures.add(executors[i].submit((Callable)flushRunnables.get(i)));
                    }
                    if (flushNonCf2i) {
                        ColumnFamilyStore.this.indexManager.flushAllNonCFSBackedIndexesBlocking(memtable);
                    }
                    flushResults = Lists.newArrayList(FBUtilities.waitOnFutures(futures));
                }
                catch (Throwable t) {
                    t = Flushing.abortRunnables(flushRunnables, t);
                    t = txn.abort(t);
                    throw Throwables.propagate((Throwable)t);
                }
                try {
                    Iterator writerIterator = flushResults.iterator();
                    while (writerIterator.hasNext()) {
                        SSTableMultiWriter writer = (SSTableMultiWriter)writerIterator.next();
                        if (writer.getFilePointer() > 0L) {
                            writer.setOpenResult(true).prepareToCommit();
                            continue;
                        }
                        org.apache.cassandra.utils.Throwables.maybeFail(writer.abort(null));
                        writerIterator.remove();
                    }
                }
                catch (Throwable t) {
                    for (SSTableMultiWriter writer : flushResults) {
                        t = writer.abort(t);
                    }
                    t = txn.abort(t);
                    Throwables.propagate((Throwable)t);
                }
                txn.prepareToCommit();
                Throwable accumulate = null;
                for (SSTableMultiWriter writer : flushResults) {
                    accumulate = writer.commit(accumulate);
                }
                org.apache.cassandra.utils.Throwables.maybeFail(txn.commit(accumulate));
                for (SSTableMultiWriter writer : flushResults) {
                    Collection<SSTableReader> flushedSSTables = writer.finished();
                    for (SSTableReader sstable : flushedSSTables) {
                        if (sstable == null) continue;
                        sstables.add(sstable);
                        long size = sstable.bytesOnDisk();
                        totalBytesOnDisk += size;
                        maxBytesOnDisk = Math.max(maxBytesOnDisk, size);
                        minBytesOnDisk = Math.min(minBytesOnDisk, size);
                    }
                }
            }
            cfs.replaceFlushed(memtable, sstables);
            this.reclaim(memtable);
            ((ColumnFamilyStore)cfs).compactionStrategyManager.compactionLogger.flush(sstables);
            logger.debug("Flushed to {} ({} sstables, {}), biggest {}, smallest {}", new Object[]{sstables, sstables.size(), FBUtilities.prettyPrintMemory(totalBytesOnDisk), FBUtilities.prettyPrintMemory(maxBytesOnDisk), FBUtilities.prettyPrintMemory(minBytesOnDisk)});
            return sstables;
        }

        private void reclaim(final Memtable memtable) {
            final OpOrder.Barrier readBarrier = ColumnFamilyStore.this.readOrdering.newBarrier();
            readBarrier.issue();
            this.postFlushTask.addListener(new WrappedRunnable(){

                @Override
                public void runMayThrow() {
                    readBarrier.await();
                    memtable.discard();
                }
            }, reclaimExecutor);
        }

        public String toString() {
            return "Flush " + ColumnFamilyStore.this.keyspace + '.' + ColumnFamilyStore.this.name;
        }
    }

    private final class PostFlush
    implements Callable<CommitLogPosition> {
        final CountDownLatch latch = CountDownLatch.newCountDownLatch(1);
        final Memtable mainMemtable;
        volatile Throwable flushFailure = null;

        private PostFlush(Memtable mainMemtable) {
            this.mainMemtable = mainMemtable;
        }

        @Override
        public CommitLogPosition call() {
            try {
                this.latch.await();
            }
            catch (InterruptedException e) {
                throw new UncheckedInterruptedException(e);
            }
            CommitLogPosition commitLogUpperBound = CommitLogPosition.NONE;
            if (this.flushFailure == null && this.mainMemtable != null) {
                commitLogUpperBound = this.mainMemtable.getFinalCommitLogUpperBound();
                CommitLog.instance.discardCompletedSegments(ColumnFamilyStore.this.metadata.id, this.mainMemtable.getCommitLogLowerBound(), commitLogUpperBound);
            }
            ColumnFamilyStore.this.metric.pendingFlushes.dec();
            if (this.flushFailure != null) {
                throw Throwables.propagate((Throwable)this.flushFailure);
            }
            return commitLogUpperBound;
        }
    }

    private class PaxosRepairHistoryLoader {
        private TablePaxosRepairHistory history;

        private PaxosRepairHistoryLoader() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        TablePaxosRepairHistory get() {
            if (this.history != null) {
                return this.history;
            }
            PaxosRepairHistoryLoader paxosRepairHistoryLoader = this;
            synchronized (paxosRepairHistoryLoader) {
                if (this.history != null) {
                    return this.history;
                }
                this.history = TablePaxosRepairHistory.load(ColumnFamilyStore.this.keyspace.getName(), ColumnFamilyStore.this.name);
                return this.history;
            }
        }
    }

    public static enum FlushReason {
        COMMITLOG_DIRTY,
        MEMTABLE_LIMIT,
        MEMTABLE_PERIOD_EXPIRED,
        INDEX_BUILD_STARTED,
        INDEX_BUILD_COMPLETED,
        INDEX_REMOVED,
        INDEX_TABLE_FLUSH,
        VIEW_BUILD_STARTED,
        INTERNALLY_FORCED,
        USER_FORCED,
        STARTUP,
        DRAIN,
        SNAPSHOT,
        TRUNCATE,
        DROP,
        STREAMING,
        STREAMS_RECEIVED,
        VALIDATION,
        ANTICOMPACTION,
        SCHEMA_CHANGE,
        OWNED_RANGES_CHANGE,
        UNIT_TESTS;

    }
}

